/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.analyser;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.WebApplicationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.common.security.AuthorizedTasks;
import org.gcube.common.security.secrets.Secret;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.IdentifiableElement;
import org.gcube.informationsystem.model.reference.ERElement;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.queries.templates.impl.properties.QueryTemplateReferenceImpl;
import org.gcube.informationsystem.queries.templates.reference.entities.QueryTemplate;
import org.gcube.informationsystem.queries.templates.reference.properties.QueryTemplateReference;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.rest.SharingPath;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClient;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClientFactory;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisher;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisherFactory;
import org.gcube.informationsystem.resourceregistry.queries.templates.ResourceRegistryQueryTemplateClient;
import org.gcube.informationsystem.resourceregistry.queries.templates.ResourceRegistryQueryTemplateClientFactory;
import org.gcube.informationsystem.serialization.ElementMapper;
import org.gcube.informationsystem.utils.TypeUtility;
import org.gcube.resourcemanagement.analyser.InstanceAnalyserFactory;
import org.gcube.resourcemanagement.context.TargetContext;
import org.gcube.resourcemanagement.resource.DerivatedRelatedResourceGroup;
import org.gcube.resourcemanagement.resource.Instance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InstanceAnalyser<R extends Resource, I extends Instance> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String type;
    protected UUID instanceUUID;
    protected ResourceRegistryClient client = ResourceRegistryClientFactory.create();
    protected ResourceRegistryPublisher publisher;
    protected ResourceRegistryQueryTemplateClient templateClient;
    protected int level = 0;
    protected boolean mandatory;
    protected Resource ancestor;
    protected R resource;
    protected I instance;
    protected List<Resource> mandatoryRelatedResources;
    protected Set<DerivatedRelatedResourceGroup<I>> derivatedRelatedResourceGroups;
    protected ObjectMapper mapper = new ObjectMapper();
    protected TargetContext targetContext;

    public InstanceAnalyser() {
    }

    public InstanceAnalyser(String type, UUID instanceUUID) {
        this();
        this.type = type;
        this.instanceUUID = instanceUUID;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public String getType() {
        if (this.type == null) {
            this.type = TypeUtility.getTypeName(this.getTypeClass());
        }
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public abstract Class<R> getTypeClass();

    public abstract Class<I> getInstanceClass();

    public UUID getInstanceUUID() {
        return this.instanceUUID;
    }

    public void setInstanceUUID(UUID instanceUUID) {
        this.instanceUUID = instanceUUID;
    }

    public void setTargetContext(TargetContext targetContext) {
        this.targetContext = targetContext;
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("It analyses instances of type ");
        sb.append(this.getType());
        if (this.polymorphic()) {
            sb.append(" and all its derivated types");
        }
        return sb.toString();
    }

    public boolean polymorphic() {
        return false;
    }

    public Integer getPriority() {
        return 100;
    }

    public Resource getAncestor() {
        return this.ancestor;
    }

    public void setAncestor(Resource ancestor) {
        this.ancestor = ancestor;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public R getResource() throws WebApplicationException, ResourceRegistryException {
        if (this.resource == null) {
            this.resource = (Resource)this.client.getInstance(this.getTypeClass(), this.instanceUUID);
        }
        return this.resource;
    }

    public void setResource(R resource) {
        this.resource = resource;
    }

    protected abstract Set<DerivatedRelatedResourceGroup<I>> getDerivatedRelatedResourceGroup() throws WebApplicationException, ResourceRegistryException;

    protected abstract List<IdentifiableElement> validateInstancesToCreate(List<IdentifiableElement> var1) throws WebApplicationException, ResourceRegistryException;

    protected abstract List<IdentifiableElement> getNewInstances() throws WebApplicationException, ResourceRegistryException;

    protected QueryTemplateReference getMandatoryRelatedResourcesQTR() {
        QueryTemplateReferenceImpl queryTemplateReference = new QueryTemplateReferenceImpl();
        queryTemplateReference.setName("GetMandatoryRelatedResources");
        queryTemplateReference.addVariable("$id", (Object)this.instanceUUID.toString());
        queryTemplateReference.addVariable("$type", (Object)this.getType());
        return queryTemplateReference;
    }

    public List<Resource> getMandatoryRelatedResources() throws WebApplicationException, ResourceRegistryException {
        if (this.mandatoryRelatedResources == null) {
            this.logger.debug("Going to discover Mandatory Related Resources (M-RRs) from {} with UUID: {}", (Object)this.getType(), (Object)this.instanceUUID);
            this.mandatoryRelatedResources = new ArrayList<Resource>();
            QueryTemplateReference queryTemplateReference = this.getMandatoryRelatedResourcesQTR();
            this.mandatoryRelatedResources.addAll(this.executeQueryTemplate(queryTemplateReference));
        }
        return this.mandatoryRelatedResources;
    }

    public Set<DerivatedRelatedResourceGroup<I>> getDerivatedRelatedResources() throws WebApplicationException, ResourceRegistryException {
        if (this.derivatedRelatedResourceGroups == null) {
            this.logger.debug("Going to get Derivated Related Resources (D-RRs) from {} with UUID: {}", (Object)this.getType(), (Object)this.instanceUUID);
            this.derivatedRelatedResourceGroups = this.getDerivatedRelatedResourceGroup();
        }
        return this.derivatedRelatedResourceGroups;
    }

    protected List<Resource> executeQuery(JsonNode query) throws WebApplicationException, ResourceRegistryException {
        this.logger.trace("Executing query: {}", (Object)query);
        List resources = this.client.jsonQuery(query);
        return resources;
    }

    protected List<Resource> executeQueryTemplate(QueryTemplateReference queryTemplateReference) throws WebApplicationException, ResourceRegistryException {
        List resources;
        this.logger.trace("Executing query template: {}", (Object)queryTemplateReference);
        ObjectNode parameters = (ObjectNode)this.mapper.valueToTree((Object)queryTemplateReference.getVariables());
        String ret = this.client.runQueryTemplate(queryTemplateReference.getName(), (JsonNode)parameters);
        try {
            resources = ElementMapper.unmarshalList(Resource.class, (String)ret);
        }
        catch (IOException e) {
            StringBuffer error = new StringBuffer();
            error.append("Error while unmarshalling the result of the query template ");
            error.append(queryTemplateReference);
            this.logger.error(error.toString(), (Throwable)e);
            throw new InternalServerErrorException(error.toString(), (Throwable)e);
        }
        return resources;
    }

    public I read(SharingPath.SharingOperation operation) throws WebApplicationException, ResourceRegistryException {
        if (operation == SharingPath.SharingOperation.ADD) {
            return this.readToAdd();
        }
        if (operation == SharingPath.SharingOperation.REMOVE) {
            return this.readToRemove();
        }
        throw new UnsupportedOperationException("Operation not supported");
    }

    protected I readToAdd() throws WebApplicationException, ResourceRegistryException {
        Instance i = null;
        try {
            i = (Instance)this.getInstanceClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            StringBuffer error = new StringBuffer();
            error.append("Error while creating a new instance of ");
            error.append(this.getInstanceClass().getName());
            this.logger.error(error.toString(), (Throwable)e);
            throw new InternalServerErrorException(error.toString(), (Throwable)e);
        }
        i.setResource((Resource)this.getResource());
        List<IdentifiableElement> elements = this.getNewInstances();
        i.addNewInstances(elements);
        for (Resource rr : this.getMandatoryRelatedResources()) {
            InstanceAnalyser<Resource, Instance> analyser = InstanceAnalyserFactory.getInstanceAnalyser(rr.getTypeName(), rr.getID());
            if (analyser == null) continue;
            analyser.setAncestor((Resource)this.resource);
            analyser.setResource(rr);
            analyser.setLevel(this.getLevel() + 1);
            Instance in = analyser.getInstance();
            i.addMandatoryRelatedResource(in);
        }
        if (this.level == 0 || this.ancestor == null || this.mandatory) {
            this.getDerivatedRelatedResources();
            Iterator<Object> iterator = this.derivatedRelatedResourceGroups.iterator();
            while (iterator.hasNext()) {
                DerivatedRelatedResourceGroup group;
                DerivatedRelatedResourceGroup g = group = (DerivatedRelatedResourceGroup)iterator.next();
                i.addDerivatedRelatedResource(g);
            }
        }
        return (I)i;
    }

    public I getInstance() throws WebApplicationException, ResourceRegistryException {
        if (this.instance == null) {
            this.instance = this.readToAdd();
        }
        return this.instance;
    }

    public void setInstance(I instance) {
        this.instance = instance;
        if (this.instanceUUID != null && this.instanceUUID.compareTo(((Instance)instance).getID()) != 0) {
            StringBuffer error = new StringBuffer();
            error.append("The instance UUID ");
            error.append(this.instanceUUID);
            error.append(" is different from the instance UUID ");
            error.append(((Instance)instance).getID());
            this.logger.error(error.toString());
            throw new BadRequestException(error.toString());
        }
        this.instanceUUID = ((Instance)instance).getID();
    }

    public I readToRemove() throws WebApplicationException {
        throw new UnsupportedOperationException("Method not implemented yet");
    }

    protected List<ERElement> executeAdd() throws WebApplicationException, ResourceRegistryException {
        ResourceRegistryPublisher rrp = ResourceRegistryPublisherFactory.create();
        List added = rrp.addResourceToContext(((Instance)this.instance).getType(), ((Instance)this.instance).getID(), this.targetContext.getUUID(), Boolean.valueOf(false));
        return added;
    }

    protected List<IdentifiableElement> createNewInstances() throws WebApplicationException, ResourceRegistryException {
        List<IdentifiableElement> newInstancesToCreate = this.validateInstancesToCreate(((Instance)this.instance).getNewInstances());
        for (IdentifiableElement newInstanceToCreate : newInstancesToCreate) {
            if (newInstanceToCreate instanceof QueryTemplate) {
                QueryTemplate queryTemplate = (QueryTemplate)newInstanceToCreate;
                QueryTemplate createdQueryTemplate = this.templateClient.create(queryTemplate);
                newInstancesToCreate.add((IdentifiableElement)createdQueryTemplate);
                continue;
            }
            if (newInstanceToCreate instanceof ERElement) {
                ERElement element = (ERElement)newInstanceToCreate;
                ERElement createdElement = this.publisher.create(element);
                newInstancesToCreate.add((IdentifiableElement)createdElement);
                continue;
            }
            this.logger.warn("It is supported creation of {} i.e. {}. It will be skipped", (Object)AccessType.getAccessType(newInstanceToCreate.getClass()), (Object)newInstanceToCreate.getTypeName());
        }
        return newInstancesToCreate;
    }

    protected Set<Instance> validateMandatoryRelatedResources(I expectedInstance) throws WebApplicationException, ResourceRegistryException {
        Set<Instance> expectedMRRs;
        Set<Instance> requestedMRRs = ((Instance)this.instance).getMandatoryRelatedResources();
        if (!requestedMRRs.containsAll(expectedMRRs = ((Instance)expectedInstance).getMandatoryRelatedResources())) {
            StringBuffer error = new StringBuffer();
            error.append("Not all mandatory related resources for ");
            error.append(this.getType());
            error.append(" ");
            error.append(this.getInstanceUUID());
            error.append(" are present in the request. ");
            expectedMRRs.removeAll(requestedMRRs);
            error.append("Missing mandatory related resources are ");
            error.append(expectedMRRs);
            this.logger.error(error.toString());
            throw new WebApplicationException(error.toString());
        }
        this.logger.debug("All expected mandatory related resources for {} {} are present in the request.", (Object)this.getType(), (Object)this.getInstanceUUID());
        if (!expectedMRRs.containsAll(requestedMRRs)) {
            StringBuffer error = new StringBuffer();
            error.append("Requested mandatory related resources for ");
            error.append(this.getType());
            error.append(" ");
            error.append(this.getInstanceUUID());
            error.append(" in the request are more than the expected ones. ");
            requestedMRRs.removeAll(expectedMRRs);
            error.append("Unexpected mandatory related resources are ");
            error.append(requestedMRRs);
            this.logger.error(error.toString());
            throw new WebApplicationException(error.toString());
        }
        this.logger.debug("Mandatory related resources in the request for {} {} are exactly the expected ones.", (Object)this.getType(), (Object)this.getInstanceUUID());
        return expectedMRRs;
    }

    protected Set<Instance> addMandatoryRelatedResources(I expectedInstance) throws WebApplicationException, ResourceRegistryException {
        HashSet<Instance> addedMandatoryRelatedResources = new HashSet<Instance>();
        Set<Instance> requestedMRRs = ((Instance)this.instance).getMandatoryRelatedResources();
        this.validateMandatoryRelatedResources(expectedInstance);
        for (Instance mandatory : requestedMRRs) {
            this.logger.debug("Going to add mandatory related resource: {}", (Object)mandatory);
            InstanceAnalyser<Resource, Instance> analyser = InstanceAnalyserFactory.getInstanceAnalyser(mandatory.getType(), mandatory.getID());
            if (analyser == null) continue;
            analyser.setAncestor((Resource)this.resource);
            analyser.setLevel(this.getLevel() + 1);
            analyser.setInstance(mandatory);
            analyser.setTargetContext(this.targetContext);
            Instance mandatoryRR = analyser.add();
            if (mandatoryRR == null) continue;
            addedMandatoryRelatedResources.add(mandatoryRR);
        }
        return addedMandatoryRelatedResources;
    }

    protected DerivatedRelatedResourceGroup<Instance> addDerivatedRelatedResourceGroup(DerivatedRelatedResourceGroup<Instance> requested, DerivatedRelatedResourceGroup<Instance> expected) throws WebApplicationException, ResourceRegistryException {
        DerivatedRelatedResourceGroup<Instance> drrgToAdd = new DerivatedRelatedResourceGroup<Instance>(expected.getInstanceClass());
        drrgToAdd.setName(expected.getName());
        drrgToAdd.setDescription(expected.getDescription());
        drrgToAdd.setMin(expected.getMin());
        drrgToAdd.setMax(expected.getMax());
        drrgToAdd.setAncestor((Resource)this.getResource());
        HashSet<Instance> requestedInstances = new HashSet<Instance>(requested.getInstances());
        requestedInstances.retainAll(expected.getInstances());
        int size = requestedInstances.size();
        if (size < expected.getMin()) {
            StringBuffer error = new StringBuffer();
            error.append("The number of requested instances for ");
            error.append(this.getType());
            error.append(" ");
            error.append(this.getInstanceUUID());
            error.append(" is less than the minimum expected. ");
            error.append("Requested: ");
            error.append(size);
            error.append(" Minimum: ");
            error.append(expected.getMin());
            this.logger.error(error.toString());
            throw new WebApplicationException(error.toString());
        }
        if (size > expected.getMax()) {
            StringBuffer error = new StringBuffer();
            error.append("The number of requested instances for ");
            error.append(this.getType());
            error.append(" ");
            error.append(this.getInstanceUUID());
            error.append(" is more than the maximum expected. ");
            error.append("Requested: ");
            error.append(size);
            error.append(" Maximum: ");
            error.append(expected.getMax());
            this.logger.error(error.toString());
            throw new WebApplicationException(error.toString());
        }
        HashSet<Instance> addedInstances = new HashSet<Instance>();
        for (Instance instance : requestedInstances) {
            InstanceAnalyser<Resource, Instance> analyser = InstanceAnalyserFactory.getInstanceAnalyser(instance.getType(), instance.getID());
            if (analyser == null) continue;
            analyser.setAncestor((Resource)this.resource);
            analyser.setLevel(this.getLevel() + 1);
            analyser.setInstance(instance);
            analyser.setTargetContext(this.targetContext);
            Instance instanceToAdd = analyser.add();
            if (instanceToAdd == null) continue;
            addedInstances.add(instanceToAdd);
        }
        drrgToAdd.addInstances(addedInstances);
        return drrgToAdd;
    }

    protected Map<String, DerivatedRelatedResourceGroup<Instance>> getDRRMap(Collection<DerivatedRelatedResourceGroup<Instance>> derivatedRelatedResources) {
        HashMap<String, DerivatedRelatedResourceGroup<Instance>> map = new HashMap<String, DerivatedRelatedResourceGroup<Instance>>();
        for (DerivatedRelatedResourceGroup<Instance> drr : derivatedRelatedResources) {
            map.put(drr.getName(), drr);
        }
        return map;
    }

    protected Map<String, DerivatedRelatedResourceGroup<Instance>> validateDerivatedRelatedResources(I expectedInstance) throws WebApplicationException, ResourceRegistryException {
        Set<DerivatedRelatedResourceGroup<Instance>> requestedDRRs = ((Instance)this.instance).getDerivatedRelatedResources();
        Set<DerivatedRelatedResourceGroup<Instance>> expectedDRRs = ((Instance)expectedInstance).getDerivatedRelatedResources();
        Map<String, DerivatedRelatedResourceGroup<Instance>> expected = this.getDRRMap(expectedDRRs);
        if (!requestedDRRs.containsAll(expectedDRRs)) {
            StringBuffer error = new StringBuffer();
            error.append("Not all derivated related resources for ");
            error.append(this.getType());
            error.append(" ");
            error.append(this.getInstanceUUID());
            error.append(" are present in the request. ");
            expectedDRRs.removeAll(requestedDRRs);
            error.append("Missing derivated related resources are ");
            error.append(expectedDRRs);
            this.logger.error(error.toString());
            throw new WebApplicationException(error.toString());
        }
        this.logger.debug("All expected derivated related resources for {} {} are present in the request.", (Object)this.getType(), (Object)this.getInstanceUUID());
        if (!expectedDRRs.containsAll(requestedDRRs)) {
            StringBuffer error = new StringBuffer();
            error.append("Requested derivated related resources for ");
            error.append(this.getType());
            error.append(" ");
            error.append(this.getInstanceUUID());
            error.append(" in the request are more than the expected ones. ");
            requestedDRRs.removeAll(expectedDRRs);
            error.append("Unexpected derivated related resources are ");
            error.append(expectedDRRs);
            this.logger.error(error.toString());
            throw new WebApplicationException(error.toString());
        }
        this.logger.debug("Derivated related resources in the request for {} {} are exactly the expected ones.", (Object)this.getType(), (Object)this.getInstanceUUID());
        return expected;
    }

    protected Set<DerivatedRelatedResourceGroup<Instance>> addDerivatedRelatedResources(I expectedInstance) throws WebApplicationException, ResourceRegistryException {
        HashSet<DerivatedRelatedResourceGroup<Instance>> addedDerivatedRelatedResources = new HashSet<DerivatedRelatedResourceGroup<Instance>>();
        Set<DerivatedRelatedResourceGroup<Instance>> requestedDRRs = ((Instance)this.instance).getDerivatedRelatedResources();
        Map<String, DerivatedRelatedResourceGroup<Instance>> expectedDRRs = this.validateDerivatedRelatedResources(expectedInstance);
        for (DerivatedRelatedResourceGroup<Instance> requested : requestedDRRs) {
            DerivatedRelatedResourceGroup<Instance> expected = expectedDRRs.get(requested.getName());
            DerivatedRelatedResourceGroup<Instance> drrgToAdd = this.addDerivatedRelatedResourceGroup(requested, expected);
            addedDerivatedRelatedResources.add(drrgToAdd);
        }
        return addedDerivatedRelatedResources;
    }

    public I add() throws WebApplicationException, ResourceRegistryException {
        Instance addedInstance = null;
        try {
            Instance i;
            addedInstance = i = (Instance)this.instance.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            StringBuffer error = new StringBuffer();
            error.append("Error while creating a new instance of ");
            error.append(this.getInstanceClass().getName());
            this.logger.error(error.toString(), (Throwable)e);
            throw new InternalServerErrorException(error.toString(), (Throwable)e);
        }
        this.publisher = ResourceRegistryPublisherFactory.create();
        this.templateClient = ResourceRegistryQueryTemplateClientFactory.create();
        I expectedInstance = this.readToAdd();
        Set<Instance> mandatoryRelatedResources = this.addMandatoryRelatedResources(expectedInstance);
        addedInstance.setMandatoryRelatedResources(mandatoryRelatedResources);
        Set<DerivatedRelatedResourceGroup<Instance>> addedDerivatedRelatedResourceGroups = this.addDerivatedRelatedResources(expectedInstance);
        addedInstance.setDerivatedRelatedResources(addedDerivatedRelatedResourceGroups);
        if (this.level == 0 || this.ancestor == null) {
            List<ERElement> addedElements = this.executeAdd();
            addedInstance.addAddedElements(addedElements);
        }
        Callable<List<IdentifiableElement>> callable = new Callable<List<IdentifiableElement>>(){

            @Override
            public List<IdentifiableElement> call() throws WebApplicationException, ResourceRegistryException {
                return InstanceAnalyser.this.createNewInstances();
            }
        };
        Secret secret = this.targetContext.getSecret();
        if (secret == null) {
            StringBuffer error = new StringBuffer();
            error.append("Secret not found for ");
            error.append(this.targetContext.getContextFullPath());
            error.append(" UUID ");
            error.append(this.targetContext.getUUID());
            this.logger.error(error.toString());
            throw new InternalServerErrorException(error.toString());
        }
        try {
            List createdInstances = (List)AuthorizedTasks.executeSafely((Callable)callable, (Secret)secret);
            addedInstance.setNewInstances(createdInstances);
        }
        catch (WebApplicationException | ResourceRegistryException e) {
            StringBuffer error = new StringBuffer();
            error.append("Error while creating new instances");
            this.logger.error(error.toString(), e);
            throw e;
        }
        catch (Throwable t) {
            throw new InternalServerErrorException("Error while creating new instances", t);
        }
        return (I)addedInstance;
    }

    public I remove() throws WebApplicationException {
        throw new UnsupportedOperationException("Method not implemented yet");
    }
}

