/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.analyser;

import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.WebApplicationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.UUID;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.tree.Node;
import org.gcube.informationsystem.tree.Tree;
import org.gcube.informationsystem.types.knowledge.TypesKnowledge;
import org.gcube.informationsystem.types.reference.Type;
import org.gcube.resourcemanagement.analyser.InstanceAnalyser;
import org.gcube.resourcemanagement.resource.Instance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceAnalyserFactory {
    protected static Logger logger = LoggerFactory.getLogger(InstanceAnalyserFactory.class);
    protected static Map<String, InstanceAnalyser<Resource, Instance>> instances = new HashMap<String, InstanceAnalyser<Resource, Instance>>();
    protected static Map<String, InstanceAnalyser<Resource, Instance>> polymorphicInstances = new HashMap<String, InstanceAnalyser<Resource, Instance>>();

    protected static void addPolymorphicInstanceAnalyser(String type, InstanceAnalyser<Resource, Instance> analyser) {
        if (!analyser.polymorphic()) {
            return;
        }
        TypesKnowledge tk = TypesKnowledge.getInstance();
        Tree resourceTree = tk.getModelKnowledge().getTree(AccessType.RESOURCE);
        Node node = resourceTree.getNodeByIdentifier(type);
        Set descendants = node.getDescendants();
        for (Node child : descendants) {
            String childTypeName = child.getIdentifier();
            if (instances.containsKey(childTypeName)) {
                if (!polymorphicInstances.containsKey(childTypeName)) continue;
                polymorphicInstances.remove(childTypeName);
                continue;
            }
            if (!polymorphicInstances.containsKey(childTypeName)) {
                polymorphicInstances.put(childTypeName, analyser);
                continue;
            }
            InstanceAnalyserFactory.evaluateBestInstanceAnalyser(childTypeName, analyser, (Tree<Type>)resourceTree);
        }
    }

    protected static void evaluateBestInstanceAnalyser(String type, InstanceAnalyser<Resource, Instance> candidatedAnalyser, Tree<Type> resourceTree) throws WebApplicationException {
        String typeOfCandidatedAnalyser;
        InstanceAnalyser<Resource, Instance> currentAnalyser = polymorphicInstances.get(type);
        String typeOfCurrentAnalyser = currentAnalyser.getType();
        if (typeOfCurrentAnalyser.compareTo(typeOfCandidatedAnalyser = candidatedAnalyser.getType()) == 0) {
            throw new InternalServerErrorException("Two polymorphic analysers with the same type found. This is not allowed");
        }
        if (resourceTree.isChildOf(typeOfCurrentAnalyser, typeOfCandidatedAnalyser)) {
            polymorphicInstances.remove(type);
            polymorphicInstances.put(type, candidatedAnalyser);
        }
    }

    protected static void analyseInstanceAnalyser(InstanceAnalyser<Resource, Instance> analyser) {
        try {
            String name = analyser.getName();
            logger.debug("{} {} found", (Object)name, (Object)InstanceAnalyser.class.getSimpleName());
            String type = analyser.getType();
            if (instances.get(type) != null) {
                throw new InternalServerErrorException("Two analysers with the same type found. This is not allowed");
            }
            instances.put(type, analyser);
            InstanceAnalyserFactory.addPolymorphicInstanceAnalyser(type, analyser);
        }
        catch (Exception e) {
            logger.error("{} {} not initialized correctly. It will not be used", (Object)analyser.getName(), (Object)InstanceAnalyser.class.getSimpleName());
        }
    }

    public static InstanceAnalyser<Resource, Instance> getInstanceAnalyser(String type, UUID id) {
        InstanceAnalyser instanceAnalyser = null;
        if (instances.containsKey(type)) {
            InstanceAnalyser<Resource, Instance> analyser = instances.get(type);
            try {
                Class<?> clz = analyser.getClass();
                instanceAnalyser = (InstanceAnalyser)clz.getDeclaredConstructor(String.class, UUID.class).newInstance(type, id);
            }
            catch (Exception e) {
                logger.error("Error while creating {} instance", (Object)InstanceAnalyser.class.getSimpleName(), (Object)e);
            }
        } else if (polymorphicInstances.containsKey(type)) {
            InstanceAnalyser<Resource, Instance> analyser = polymorphicInstances.get(type);
            try {
                Class<?> clz = analyser.getClass();
                instanceAnalyser = (InstanceAnalyser)clz.getDeclaredConstructor(String.class, UUID.class).newInstance(type, id);
            }
            catch (Exception e) {
                logger.error("Error while creating {} instance", (Object)InstanceAnalyser.class.getSimpleName(), (Object)e);
            }
        } else {
            logger.error("No {} found for type {}", (Object)InstanceAnalyser.class.getSimpleName(), (Object)type);
        }
        if (instanceAnalyser == null) {
            throw new InternalServerErrorException("No instance analyser found for type " + type);
        }
        return instanceAnalyser;
    }

    static {
        ServiceLoader<InstanceAnalyser> serviceLoader = ServiceLoader.load(InstanceAnalyser.class);
        Iterator<Object> iterator = serviceLoader.iterator();
        while (iterator.hasNext()) {
            InstanceAnalyser analyser;
            InstanceAnalyser instanceAnalyser = analyser = iterator.next();
            InstanceAnalyserFactory.analyseInstanceAnalyser(instanceAnalyser);
        }
        if (logger.isTraceEnabled()) {
            InstanceAnalyser<Resource, Instance> analyser;
            logger.trace("{} initialized with the following {}s:", (Object)InstanceAnalyserFactory.class.getSimpleName(), (Object)InstanceAnalyserFactory.class.getSimpleName());
            for (String type : instances.keySet()) {
                analyser = instances.get(type);
                logger.trace("{} will be managed managed by {}", (Object)type, (Object)analyser.getName());
            }
            logger.trace("{} initialized with the following polymorphic {}s:", (Object)InstanceAnalyserFactory.class.getSimpleName(), (Object)InstanceAnalyserFactory.class.getSimpleName());
            for (String type : polymorphicInstances.keySet()) {
                analyser = polymorphicInstances.get(type);
                logger.trace("{} will be managed managed by {} because is polymorphic", (Object)type, (Object)analyser.getName());
            }
        }
    }
}

