package org.gcube.resourcemanagement.analyser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.queries.templates.reference.properties.QueryTemplateReference;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.resourcemanagement.model.reference.entities.facets.DiscoveryFacet;
import org.gcube.resourcemanagement.model.reference.entities.resources.GCubeResource;
import org.gcube.resourcemanagement.resource.DerivatedRelatedResourceGroup;
import org.gcube.resourcemanagement.resources.GCubeInstance;

import jakarta.ws.rs.WebApplicationException;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public abstract class GCubeAnalyser<GR extends GCubeResource> extends InstanceAnalyser<GR, GCubeInstance> {

    public GCubeAnalyser() {
        super();
    }

    public GCubeAnalyser(String type, UUID instanceUUID) {
        super(type, instanceUUID);
    }

    @Override
    public Class<GCubeInstance> getInstanceClass() {
        return GCubeInstance.class;
    }

    @Override
    protected Set<DerivatedRelatedResourceGroup<GCubeInstance>> getDerivatedRelatedResourceGroup() throws WebApplicationException, ResourceRegistryException {
        Set<DerivatedRelatedResourceGroup<GCubeInstance>> derivatedRelatedResourceGroups = new HashSet<>();
        List<DiscoveryFacet> discoveryFacets = resource.getFacets(DiscoveryFacet.class);
        for(DiscoveryFacet discoveryFacet : discoveryFacets){
            DerivatedRelatedResourceGroup<GCubeInstance> derivatedRelatedResourceGroup = getDerivatedRelatedResourceGroup(discoveryFacet);
            derivatedRelatedResourceGroups.add(derivatedRelatedResourceGroup);
        }
        return derivatedRelatedResourceGroups;
    }

    protected DerivatedRelatedResourceGroup<GCubeInstance> getDerivatedRelatedResourceGroup(DiscoveryFacet discoveryFacet) throws WebApplicationException, ResourceRegistryException {
        logger.trace("Analyzing DiscoveryFacet: {}", discoveryFacet);
        
        DerivatedRelatedResourceGroup<GCubeInstance> derivatedRelatedResourceGroup = new DerivatedRelatedResourceGroup<GCubeInstance>(getInstanceClass());
        derivatedRelatedResourceGroup.setAncestor(getResource());
        derivatedRelatedResourceGroup.setName(discoveryFacet.getGroup());
        derivatedRelatedResourceGroup.setDescription(discoveryFacet.getDescription());
        derivatedRelatedResourceGroup.setMin(discoveryFacet.getMin());
        derivatedRelatedResourceGroup.setMax(discoveryFacet.getMax());

        List<Resource> derivatedRelatedResources = discoverDerivatedRelatedResources(discoveryFacet);
        derivatedRelatedResourceGroup.setRelatedResources(derivatedRelatedResources);

        return derivatedRelatedResourceGroup;
    }

    protected List<Resource> discoverDerivatedRelatedResources(DiscoveryFacet discoveryFacet) throws WebApplicationException, ResourceRegistryException {
        logger.debug("Discovering Derivated Related Resources (D-RRs) according DiscoveryFacet: {}", discoveryFacet);
        
        List<Resource> derivatedRelatedResources = new ArrayList<>();
        ArrayNode queries = discoveryFacet.getQueries();
        for(JsonNode query : queries){
            derivatedRelatedResources.addAll(executeQuery(query));
        }

        List<QueryTemplateReference> queryTemplates = discoveryFacet.getQueryTemplates();
        for(QueryTemplateReference queryTemplate : queryTemplates){
            derivatedRelatedResources.addAll(executeQueryTemplate(queryTemplate));
        }
        return derivatedRelatedResources;
    }

}
