/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.analyser;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.WebApplicationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.com.fasterxml.jackson.core.TreeNode;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.base.reference.IdentifiableElement;
import org.gcube.informationsystem.model.impl.properties.PropagationConstraintImpl;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.model.reference.relations.IsRelatedTo;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.serialization.ElementMapper;
import org.gcube.informationsystem.tree.Tree;
import org.gcube.informationsystem.types.impl.validator.ObjectNodeValidator;
import org.gcube.informationsystem.types.knowledge.TypesKnowledge;
import org.gcube.resourcemanagement.analyser.GCubeAnalyser;
import org.gcube.resourcemanagement.model.impl.entities.resources.ConfigurationImpl;
import org.gcube.resourcemanagement.model.impl.entities.resources.ConfigurationTemplateImpl;
import org.gcube.resourcemanagement.model.impl.relations.isrelatedto.IsCustomizedByImpl;
import org.gcube.resourcemanagement.model.impl.relations.isrelatedto.IsDerivationOfImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.TemplateFacet;
import org.gcube.resourcemanagement.model.reference.entities.resources.Configuration;
import org.gcube.resourcemanagement.model.reference.entities.resources.ConfigurationTemplate;
import org.gcube.resourcemanagement.model.reference.entities.resources.Service;

public class ConfigurationTemplateAnalyser
extends GCubeAnalyser<ConfigurationTemplate> {
    public ConfigurationTemplateAnalyser() {
    }

    public ConfigurationTemplateAnalyser(String type, UUID instanceUUID) {
        super(type, instanceUUID);
    }

    public Class<ConfigurationTemplate> getTypeClass() {
        return ConfigurationTemplate.class;
    }

    public boolean polymorphic() {
        return true;
    }

    protected List<TemplateFacet> getTemplateFacets() throws WebApplicationException, ResourceRegistryException {
        return ((ConfigurationTemplate)this.resource).getFacets(TemplateFacet.class);
    }

    protected List<IdentifiableElement> getTemplateFacetsAsIdentifiableElements() throws WebApplicationException, ResourceRegistryException {
        List<TemplateFacet> templateFacets = this.getTemplateFacets();
        ArrayList<IdentifiableElement> identifiableElements = new ArrayList<IdentifiableElement>(templateFacets.size());
        for (TemplateFacet facet : templateFacets) {
            TemplateFacet clone = null;
            try {
                String s = ElementMapper.marshal((Element)facet);
                clone = (TemplateFacet)ElementMapper.unmarshal(TemplateFacet.class, (String)s);
            }
            catch (IOException e) {
                throw new InternalServerErrorException((Throwable)e);
            }
            clone.setID(null);
            identifiableElements.add((IdentifiableElement)clone);
        }
        return identifiableElements;
    }

    protected boolean validateInstanceAgainstTemplate(TemplateFacet tf, Facet newFacet) throws WebApplicationException, ResourceRegistryException {
        String expectedTargetType = tf.getTargetType();
        TypesKnowledge tk = TypesKnowledge.getInstance();
        Tree facetTree = tk.getModelKnowledge().getTree(AccessType.FACET);
        String newFacetType = newFacet.getTypeName();
        if (newFacetType.compareTo(expectedTargetType) != 0 && !facetTree.isChildOf(expectedTargetType, newFacetType)) {
            return false;
        }
        ObjectNode node = (ObjectNode)ElementMapper.getObjectMapper().valueToTree((Object)newFacet);
        ObjectNodeValidator validator = new ObjectNodeValidator(node, tf.getProperties());
        boolean valid = validator.validate();
        if (valid) {
            this.logger.trace("The instance {} is valid against the template facet {}", (Object)newFacet, (Object)tf);
        } else {
            this.logger.trace("The instance {} is not valid against the template facet {}. The errors are: {}", new Object[]{newFacet, tf, validator.getValidatorReport().getErrors()});
        }
        return valid;
    }

    protected List<IdentifiableElement> validateInstancesToCreate(List<IdentifiableElement> newInstances) throws WebApplicationException, ResourceRegistryException {
        ArrayList<IdentifiableElement> elements = new ArrayList<IdentifiableElement>();
        UUID configurationUUID = UUID.randomUUID();
        ConfigurationImpl configuration = new ConfigurationImpl();
        configuration.setID(configurationUUID);
        ConfigurationTemplateImpl configurationTemplate = new ConfigurationTemplateImpl();
        configurationTemplate.setID(((ConfigurationTemplate)this.getResource()).getID());
        PropagationConstraintImpl propagationConstraint = new PropagationConstraintImpl();
        propagationConstraint.setAddConstraint(PropagationConstraint.AddConstraint.unpropagate);
        propagationConstraint.setRemoveConstraint(PropagationConstraint.RemoveConstraint.keep);
        propagationConstraint.setDeleteConstraint(PropagationConstraint.DeleteConstraint.keep);
        IsDerivationOfImpl isDerivationOf = new IsDerivationOfImpl((Configuration)configuration, (ConfigurationTemplate)configurationTemplate, (PropagationConstraint)propagationConstraint);
        configuration.attachResource((IsRelatedTo)isDerivationOf);
        HashSet<Facet> validInstances = new HashSet<Facet>();
        int templateFacetCount = 0;
        ConfigurationTemplate clone = null;
        try {
            String resourceString = ElementMapper.marshal((Element)((ConfigurationTemplate)this.getResource()));
            clone = (ConfigurationTemplate)ElementMapper.unmarshal(ConfigurationTemplate.class, (String)resourceString);
        }
        catch (IOException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
        Iterator e = clone.getConsistsOf().iterator();
        while (e.hasNext()) {
            ConsistsOf consistsOf;
            ConsistsOf co = consistsOf = (ConsistsOf)e.next();
            co.setSource((Resource)configuration);
            co.setID(null);
            Facet f = (Facet)co.getTarget();
            f.setID(null);
            if (f instanceof TemplateFacet) {
                ++templateFacetCount;
                boolean found = false;
                TemplateFacet tf = (TemplateFacet)f;
                for (IdentifiableElement ie : newInstances) {
                    Facet newFacet = (Facet)ie;
                    if (!this.validateInstanceAgainstTemplate(tf, newFacet)) continue;
                    found = true;
                    boolean added = validInstances.add(newFacet);
                    if (!added) {
                        this.logger.debug("Valid instance found (i.e. {}) for the template facet {}. Please note that this instance match also other template facets.", (Object)newFacet, (Object)tf);
                        continue;
                    }
                    this.logger.info("Valid instance found (i.e. {}) for the template facet {} ", (Object)newFacet, (Object)tf);
                }
                if (found) continue;
                throw new BadRequestException("No valid instances found for the template facet " + tf.toString());
            }
            configuration.addFacet(co);
        }
        if (templateFacetCount < validInstances.size()) {
            throw new BadRequestException("The number of valid instances found " + validInstances.size() + " is minor of the number of template facets " + templateFacetCount);
        }
        for (IdentifiableElement identifiableElement : validInstances) {
            configuration.addFacet((Facet)identifiableElement);
        }
        elements.add((IdentifiableElement)configuration);
        if (this.ancestor instanceof Service) {
            Service service;
            PropagationConstraintImpl pc = new PropagationConstraintImpl();
            pc.setAddConstraint(PropagationConstraint.AddConstraint.unpropagate);
            pc.setRemoveConstraint(PropagationConstraint.RemoveConstraint.cascade);
            pc.setDeleteConstraint(PropagationConstraint.DeleteConstraint.cascadeWhenOrphan);
            ObjectNode objectNode = (ObjectNode)ElementMapper.getObjectMapper().valueToTree((Object)this.ancestor);
            ((ArrayNode)objectNode.get("consistsOf")).removeAll();
            ((ArrayNode)objectNode.get("isRelatedTo")).removeAll();
            objectNode.remove("metadata");
            try {
                service = (Service)ElementMapper.getObjectMapper().treeToValue((TreeNode)objectNode, Service.class);
            }
            catch (JsonProcessingException e2) {
                throw new InternalServerErrorException((Throwable)e2);
            }
            ConfigurationImpl conf = new ConfigurationImpl();
            conf.setID(configurationUUID);
            IsCustomizedByImpl isCustomizedBy = new IsCustomizedByImpl(service, (ConfigurationTemplate)conf, (PropagationConstraint)pc);
            elements.add((IdentifiableElement)isCustomizedBy);
        }
        return elements;
    }

    protected List<IdentifiableElement> getNewInstances() throws WebApplicationException, ResourceRegistryException {
        List<IdentifiableElement> elements = this.getTemplateFacetsAsIdentifiableElements();
        return elements;
    }
}

