/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.manager.webapp.context;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.gcube.common.gxrest.response.outbound.ErrorCode;
import org.gcube.common.gxrest.response.outbound.LocalCodeException;
import org.gcube.informationsystem.model.reference.entities.Context;
import org.gcube.informationsystem.model.reference.relations.IsParentOf;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextAlreadyPresentException;
import org.gcube.resourcemanagement.manager.io.rs.RMCreateContextCode;
import org.gcube.resourcemanagement.manager.webapp.context.ContextHolder;
import org.gcube.resourcemanagement.manager.webapp.context.Queries;
import org.gcube.resourcemanagement.manager.webapp.context.RequestToResourceRegistry;
import org.gcube.resourcemanagement.manager.webapp.context.ResponseFromResourceRegistry;

public final class CreateRequest
extends RequestToResourceRegistry {
    private Context context;

    private CreateRequest(Context context) {
        this.context = context;
    }

    public static CreateRequest fromHolder(ContextHolder holder) {
        Objects.requireNonNull(holder);
        return new CreateRequest(holder.getContext());
    }

    public void validate() throws LocalCodeException {
        if (Objects.nonNull(this.context.getParent())) {
            try {
                IsParentOf relationship = this.context.getParent();
                logger.info("Fetching parent with UUID: " + ((Context)relationship.getSource()).getHeader().getUUID().toString());
                Context parent = new Queries(this.getContextClient(), this.getRegistryClient()).fetchContext(((Context)relationship.getSource()).getHeader().getUUID());
                if (Objects.isNull(parent)) {
                    throw new LocalCodeException((ErrorCode)RMCreateContextCode.CONTEXT_PARENT_DOES_NOT_EXIST);
                }
            }
            catch (Exception e) {
                throw new LocalCodeException((ErrorCode)RMCreateContextCode.CONTEXT_PARENT_DOES_NOT_EXIST);
            }
        }
    }

    protected ResponseFromResourceRegistry send() {
        try {
            Context created = this.getContextClient().create(this.context);
            if (Objects.nonNull(created)) {
                return ResponseFromResourceRegistry.newSuccessResponseWithMessage((String)"Context successfully created.", (URI)new URI(created.getHeader().getUUID().toString()));
            }
            return ResponseFromResourceRegistry.newFailureResponse((String)"Invalid response from the RR (null?)");
        }
        catch (ContextAlreadyPresentException cape) {
            return ResponseFromResourceRegistry.fromErrorCode((ErrorCode)RMCreateContextCode.CONTEXT_ALREADY_EXISTS);
        }
        catch (ResourceRegistryException e) {
            return ResponseFromResourceRegistry.fromErrorCode((ErrorCode)RMCreateContextCode.GENERIC_ERROR_FROM_RR);
        }
        catch (URISyntaxException e) {
            return ResponseFromResourceRegistry.fromErrorCode((ErrorCode)RMCreateContextCode.GENERIC_ERROR_FROM_RR);
        }
    }
}

