/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.manager.webapp.context;

import java.util.Objects;
import java.util.UUID;
import org.gcube.informationsystem.model.reference.entities.Context;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClient;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClientFactory;
import org.gcube.informationsystem.resourceregistry.context.ResourceRegistryContextClient;
import org.gcube.informationsystem.resourceregistry.context.ResourceRegistryContextClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Queries {
    private final ResourceRegistryContextClient cclient;
    private final ResourceRegistryClient rclient;
    protected static Logger logger = LoggerFactory.getLogger(Queries.class);

    protected Queries() {
        this.cclient = ResourceRegistryContextClientFactory.create();
        this.rclient = ResourceRegistryClientFactory.create();
    }

    protected Queries(ResourceRegistryContextClient cclient, ResourceRegistryClient rclient) {
        this.cclient = cclient;
        this.rclient = rclient;
    }

    protected boolean contextExists(UUID context) {
        try {
            Context results = this.cclient.read(context);
            return Objects.nonNull(results);
        }
        catch (ContextNotFoundException e) {
            logger.warn("Context not found: " + e.getMessage());
            return false;
        }
        catch (Exception e) {
            logger.warn("Failed to query the Resource Registry: " + e.getMessage());
            return false;
        }
    }

    protected Context fetchContext(UUID context) {
        try {
            return this.cclient.read(context);
        }
        catch (ResourceRegistryException e) {
            logger.warn("Failed to query the Resource Registry: " + e.getMessage());
            return null;
        }
    }

    protected boolean isContextEmpty(UUID context) {
        try {
            return this.rclient.getInstances(Resource.class, Boolean.valueOf(true)).size() == 0;
        }
        catch (ResourceRegistryException e) {
            logger.warn("Failed to query the Resource Registry: " + e.getMessage());
            return false;
        }
    }
}

