/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resource.management.quota.manager.service;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resource.management.quota.library.QuotaList;
import org.gcube.resource.management.quota.library.quotalist.Quota;
import org.gcube.resource.management.quota.manager.check.MyAppManager;
import org.gcube.resource.management.quota.manager.persistence.QuotaDBPersistence;
import org.gcube.smartgears.ApplicationManagerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="quotaManager")
public class QuotaManager {
    private static Logger log = LoggerFactory.getLogger(QuotaManager.class);
    QuotaDBPersistence quotaPersistence;
    private MyAppManager appManager = (MyAppManager)ApplicationManagerProvider.get(MyAppManager.class);

    @POST
    @Consumes(value={"text/xml"})
    @Path(value="/insert")
    public Response insertQuote(QuotaList quote) {
        try {
            log.info("insert quote init");
            log.info("insert quote: {}", (Object)quote.getQuotaList().toString());
            this.quotaPersistence = this.appManager.getQuotaDbPersistence();
            this.quotaPersistence.addQuote(quote.getQuotaList());
        }
        catch (Exception e) {
            log.error("error insert quote", (Throwable)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error insert quote: " + e.getMessage())).type("text/plain").build());
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/detail/{quota_id}")
    @Produces(value={"text/xml"})
    public Quota getDetailQuota(@NotNull @PathParam(value="quota_id") long quotaId) {
        try {
            log.info("retrieving detail quote {}", (Object)quotaId);
            this.quotaPersistence = this.appManager.getQuotaDbPersistence();
            Quota quota = this.quotaPersistence.getQuota(quotaId);
            log.info("quota {}", (Object)quota);
            return quota;
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error : " + e.getMessage())).type("text/plain").build());
        }
    }

    @DELETE
    @Path(value="/remove/{quota_id}")
    public Response removeQuota(@Null @PathParam(value="quota_id") long quotaId) {
        try {
            log.info("removing quota with id {}", (Object)quotaId);
            this.quotaPersistence = this.appManager.getQuotaDbPersistence();
            this.quotaPersistence.removeQuota(quotaId);
        }
        catch (Exception e) {
            log.error("error removing quota", (Throwable)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error removing quota: " + e.getMessage())).type("text/plain").build());
        }
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/list")
    public QuotaList getQuotePerContext() {
        String context = ScopeProvider.instance.get();
        try {
            log.info("retrieving quote in context {}", (Object)context);
            this.quotaPersistence = this.appManager.getQuotaDbPersistence();
            return new QuotaList(this.quotaPersistence.getQuote(context));
        }
        catch (Exception e) {
            log.error("error retrieving quote per context {}", (Object)context, (Object)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error retrieving quote: " + e.getMessage())).type("text/plain").build());
        }
    }
}

