/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.resources.deployment;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.service.MainPackage;
import org.gcube.common.core.resources.service.Package;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.vremanagement.deployer.impl.contexts.Configuration;
import org.gcube.common.vremanagement.deployer.impl.operators.ant.AntInterfaceException;
import org.gcube.common.vremanagement.deployer.impl.operators.common.DeployException;
import org.gcube.common.vremanagement.deployer.impl.operators.common.InvalidPackageArchiveException;
import org.gcube.common.vremanagement.deployer.impl.operators.deployment.PackageExtractor;
import org.gcube.common.vremanagement.deployer.impl.resources.BaseTypedPackage;
import org.gcube.common.vremanagement.deployer.impl.resources.deployment.DeployablePackage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DMainPackage
extends DeployablePackage {
    private static final long serialVersionUID = -3346696597160674566L;
    protected transient MainPackage packageprofile;
    protected String garID;
    protected String garFile;
    protected String garname;
    private static String JNDIFileName = "jndi-config.xml";

    public DMainPackage(MainPackage packageprofile, PackageExtractor extractor) throws Exception {
        super((Package)packageprofile, extractor);
        this.packageprofile = packageprofile;
        this.analysePackage();
        this.garID = this.generateID();
        this.setProperty("gar.name", this.garID);
        this.setType(BaseTypedPackage.TYPE.MAINPACKAGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deployPackage(Set<GCUBEScope> targets) throws DeployException, InvalidPackageArchiveException {
        boolean available = false;
        this.logger.debug((Object)("Deploying the main package " + this.getKey().getPackageName() + " in scope(s) " + targets.toString()));
        if (!this.extractor.isUpdate()) {
            try {
                GHNContext.getContext().getServiceContext(this.getKey().getServiceClass(), this.getKey().getServiceName());
                available = true;
            }
            catch (Exception e) {
                if (available) {
                    this.logger.warn((Object)("unable to deploy " + this.toString() + ": the RI is already deployed on this node"));
                    throw new DeployException("unable to deploy because of a RI of the service is already deployed on this node");
                }
            }
            finally {
                if (available) {
                    this.logger.warn((Object)("unable to deploy " + this.toString() + ": the RI is already deployed on this node"));
                    throw new DeployException("unable to deploy because of a RI of the service is already deployed on this node");
                }
            }
        }
        this._deploy();
        try {
            this.setStartScopes(targets);
        }
        catch (Exception e) {
            this.logger.error((Object)("Could not set start scopes for the package " + e.getMessage()));
            throw new DeployException(e);
        }
        this.setScopesToAdd(targets);
    }

    @Override
    public boolean requireRestart() {
        return true;
    }

    @Override
    protected Package getPackageProfile() {
        return this.packageprofile;
    }

    @Override
    public boolean verify() throws InvalidPackageArchiveException {
        File targetFolder = new File(this.getPackageTargetFolder());
        if (!targetFolder.exists()) {
            return false;
        }
        return targetFolder.listFiles() != null && targetFolder.listFiles().length != 0;
    }

    private String generateID() throws InvalidPackageArchiveException {
        String[] pathTokes = this.packageprofile.getGarArchive().split(File.separator);
        String[] temp = pathTokes[pathTokes.length - 1].split(".gar");
        if (temp == null || temp.length < 1) {
            throw new InvalidPackageArchiveException("Invalid GAR name " + this.garname);
        }
        this.logger.trace((Object)("Using the GAR ID: " + temp[0]));
        return temp[0];
    }

    private void _deploy() throws InvalidPackageArchiveException, DeployException {
        if (this.extractor == null) {
            throw new DeployException("invalid download manager");
        }
        this.preDeploy();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("gar.name", this.packageprofile.getGarArchive().trim());
        properties.put("gar.id", this.garID);
        properties.put("package.name", this.getKey().getPackageName());
        properties.put("service.id", this.extractor.getServiceKey());
        properties.put("package.file", this.extractor.getDownloadedFile().getName());
        properties.put("package.source.dir", Configuration.BASESOURCEDIR);
        properties.put("base.deploy.dir", Configuration.BASEDEPLOYDIR);
        try {
            this.run.setProperties(properties, true);
            this.run.runTarget("deployWSRFService");
        }
        catch (AntInterfaceException aie) {
            throw new DeployException("Runtime deployment error: " + aie.getMessage());
        }
    }

    private void setStartScopes(Set<GCUBEScope> scopes) throws Exception {
        if (scopes == null || scopes.size() == 0) {
            return;
        }
        ArrayList<GCUBEScope> clonedScopes = new ArrayList<GCUBEScope>();
        for (GCUBEScope toclone : scopes) {
            clonedScopes.add(toclone);
        }
        String JNDIFilePath = this.getPackageTargetFolder() + File.separator + JNDIFileName;
        this.logger.trace((Object)("Compiling JNDI at " + JNDIFilePath));
        File JNDIFile = new File(JNDIFilePath);
        if (!JNDIFile.exists()) {
            throw new FileNotFoundException("File does not exist: " + JNDIFile);
        }
        if (!JNDIFile.isFile()) {
            throw new IllegalArgumentException("Should not be a directory: " + JNDIFile);
        }
        if (!JNDIFile.canWrite()) {
            throw new IllegalArgumentException("File cannot be written: " + JNDIFile);
        }
        StringBuilder startScopesAttributeValue = new StringBuilder();
        startScopesAttributeValue.append(clonedScopes.remove(0));
        for (GCUBEScope scope : clonedScopes) {
            startScopesAttributeValue.append("," + scope);
        }
        this.logger.trace((Object)("Adding scope(s) " + startScopesAttributeValue.toString() + " to package: " + this.getKey().toString()));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document document = parser.parse(new File(JNDIFilePath));
        NodeList services = document.getElementsByTagName("service");
        for (int i = 0; i < services.getLength(); ++i) {
            this.logger.trace((Object)"Adding scope to service element");
            Element service = (Element)services.item(i);
            Element envElement = document.createElement("environment");
            envElement.setAttribute("name", "startScopes");
            envElement.setAttribute("value", startScopesAttributeValue.toString());
            envElement.setAttribute("type", "java.lang.String");
            envElement.setAttribute("override", "false");
            service.appendChild(envElement);
        }
        TransformerFactory transfac = TransformerFactory.newInstance();
        Transformer trans = transfac.newTransformer();
        trans.setOutputProperty("omit-xml-declaration", "yes");
        trans.setOutputProperty("indent", "yes");
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        DOMSource source = new DOMSource(document);
        trans.transform(source, result);
        this.setJNDIContents(JNDIFile, sw.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setJNDIContents(File JNDIFile, String content) throws FileNotFoundException, IOException {
        if (JNDIFile == null) {
            throw new IllegalArgumentException("File should not be null.");
        }
        BufferedWriter output = new BufferedWriter(new FileWriter(JNDIFile));
        try {
            output.write(content);
        }
        finally {
            ((Writer)output).close();
        }
    }

    private String getPackageTargetFolder() {
        return GHNContext.getContext().getLocation() + File.separator + "etc" + File.separator + this.garID;
    }
}

