/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.operators;

import java.io.File;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.common.PlatformDescription;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vremanagement.deployer.impl.operators.common.Report;
import org.gcube.common.vremanagement.deployer.impl.operators.deployment.Downloader;
import org.gcube.common.vremanagement.deployer.impl.operators.deployment.ExternalPackageExtractor;
import org.gcube.common.vremanagement.deployer.impl.operators.deployment.PackageExtractor;
import org.gcube.common.vremanagement.deployer.impl.resources.deployment.Deployable;
import org.gcube.common.vremanagement.deployer.impl.state.DeployerResource;
import org.gcube.common.vremanagement.deployer.stubs.common.PackageInfo;
import org.gcube.common.vremanagement.deployer.stubs.deployer.DeployParameters;

public class DeployerOperator
extends GCUBEHandler<DeployerResource> {
    static ReentrantLock deployLock = new ReentrantLock();
    protected final GCUBELog logger = new GCUBELog(DeployerOperator.class);
    private DeployParameters params;
    private boolean rollback = false;
    private DeployerResource resource = null;
    private GCUBEScope callerScope = null;

    public DeployerOperator(DeployParameters params, GCUBEScope callerScope) {
        this.params = params;
        this.callerScope = callerScope;
    }

    public void run() throws Exception {
        PackageInfo[] packages = this.params.get_package();
        String callbackID = this.params.getCallbackID() == null || this.params.getCallbackID().trim() == "" ? "DEFAULT" : this.params.getCallbackID();
        this.logger.trace((Object)("Using callback ID: " + callbackID));
        this.logger.trace((Object)"Locking the Deployer Operator...");
        deployLock.lock();
        this.logger.trace((Object)(deployLock.getClass().getSimpleName() + " - Lock acquired"));
        this.resource = (DeployerResource)((Object)this.getHandled());
        Report finalreport = new Report(this.params.getEndpointReference(), callbackID, packages.length, Report.TYPE.DEPLOY, this.callerScope);
        this.resource.setLastDeployment(callbackID);
        for (int i = 0; i < packages.length; ++i) {
            PackageInfo deployable_package = packages[i];
            finalreport.addPackage(deployable_package, Report.PACKAGESTATUS.WAITING, i, new String[0]);
        }
        HashSet<GCUBEScope> targets = new HashSet<GCUBEScope>();
        for (String scope : this.params.getTargetScope()) {
            targets.add(GCUBEScope.getScope((String)scope));
        }
        this.logger.trace((Object)"Looping on the packages..");
        boolean restart = false;
        for (int i = 0; i < packages.length; ++i) {
            PackageInfo deployable_package = packages[i];
            this.logger.info((Object)("Deploying package " + deployable_package.getName() + "... "));
            if (this.rollback) {
                finalreport.addPackage(deployable_package, Report.PACKAGESTATUS.SKIPPED, i, "The package could not be deployed because it depends on a package which has an error");
                this.logger.warn((Object)("The package " + deployable_package.getName() + " could not be deployed because it depends on a package which has an error"));
                continue;
            }
            try {
                Downloader downloader = new Downloader(deployable_package, new boolean[0]);
                if (!this.downloadFromHTTPPath(deployable_package, downloader) && !this.downloadFromLocalPath(deployable_package, downloader)) {
                    this.downloadFromRepository(deployable_package, downloader);
                }
                Deployable pack = null;
                if (downloader.getPackagetype() == Downloader.PackageType.SERVICEARCHIVE) {
                    pack = new PackageExtractor(downloader).getPackage();
                } else if (downloader.getPackagetype() == Downloader.PackageType.JAR) {
                    pack = new ExternalPackageExtractor(downloader).getPackage();
                }
                this.deployPackage(pack, finalreport, deployable_package, targets, i);
                if (!pack.requireRestart()) continue;
                restart = true;
                continue;
            }
            catch (Downloader.UnreachablePackageException ue) {
                this.logger.warn((Object)("The package " + deployable_package.getName() + " has NOT been successfully deployed"), (Throwable)ue);
                finalreport.addPackage(deployable_package, Report.PACKAGESTATUS.FAILED, i, "The package has NOT been successfully deployed. Possible cause: unable to download the package from the Software Repository");
                this.rollback = true;
                continue;
            }
            catch (Exception e) {
                this.logger.warn((Object)("The package " + deployable_package.getName() + " has NOT been successfully deployed"), (Throwable)e);
                finalreport.addPackage(deployable_package, Report.PACKAGESTATUS.FAILED, i, "The package has NOT been successfully deployed. Possible cause: " + e.getMessage());
                this.rollback = true;
            }
        }
        if (this.rollback) {
            this.rollback();
        }
        if (restart) {
            finalreport.send();
            finalreport.save();
            GHNContext.getContext().restart(new String[0]);
        } else {
            finalreport.close();
            finalreport.send();
            finalreport.save();
        }
        deployLock.unlock();
    }

    private boolean downloadFromLocalPath(PackageInfo deployable_package, Downloader manager) {
        if (deployable_package.getLocation() == null) {
            return false;
        }
        try {
            this.logger.trace((Object)("Using local path at " + deployable_package.getLocation().getLocalPath() + "... "));
            manager.downloadPackage(new File(deployable_package.getLocation().getLocalPath()));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean downloadFromHTTPPath(PackageInfo deployable_package, Downloader manager) {
        if (deployable_package.getLocation() == null) {
            return false;
        }
        try {
            this.logger.trace((Object)("Using HTTP location at " + deployable_package.getLocation().getHttpPath() + "... "));
            manager.downloadPatch(new URI(deployable_package.getLocation().getHttpPath()));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void deployPackage(Deployable pack, Report finalreport, PackageInfo deployable_package, Set<GCUBEScope> targets, int i) throws Exception {
        if (pack != null) {
            if (!this.resource.isDeployed(pack.getSourcePackage())) {
                PlatformDescription packagePlatform = pack.getTargetPlatform();
                if (packagePlatform == null || packagePlatform.getName().equalsIgnoreCase("gCore")) {
                    pack.deploy(targets);
                    if (pack.verify()) {
                        finalreport.addPackage(deployable_package, Report.PACKAGESTATUS.DEPLOYED, i, new String[0]);
                    } else {
                        finalreport.addPackage(deployable_package, Report.PACKAGESTATUS.NOTVERIFIED, i, new String[0]);
                    }
                } else {
                    this.logger.debug((Object)("The target platform for the package is " + packagePlatform.toString()));
                    String id = pack.deployApp(targets);
                    finalreport.addPackage(deployable_package, Report.PACKAGESTATUS.ACTIVATED, i, new String[0]);
                    finalreport.addRI(id, deployable_package);
                }
                this.logger.info((Object)("The package " + deployable_package.getName() + " has been successfully deployed"));
                this.logger.trace((Object)("Adding package " + pack.getSourcePackage().getKey() + " to the serialized state"));
                this.resource.addPackage(pack.getSourcePackage());
            } else {
                this.logger.info((Object)("The package " + deployable_package.getName() + " has been already deployed"));
                finalreport.addPackage(deployable_package, Report.PACKAGESTATUS.ALREADYDEPLOYED, i, new String[0]);
                pack.getSourcePackage().setScopes(targets);
                this.resource.addPackage(pack.getSourcePackage());
            }
        } else {
            throw new Exception("unable to find the package description in the service profile");
        }
        pack.clean();
    }

    private boolean downloadFromRepository(PackageInfo deployable_package, Downloader manager) throws Downloader.UnreachablePackageException, Exception {
        this.logger.debug((Object)"Trying to download from the Software Gateway... ");
        manager.downloadPackage(new GCUBEScope[0]);
        return true;
    }

    private void rollback() {
    }
}

