/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.operators.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vremanagement.deployer.impl.contexts.Configuration;
import org.gcube.common.vremanagement.deployer.impl.contexts.ServiceContext;
import org.gcube.common.vremanagement.deployer.impl.operators.common.ProfileDate;
import org.gcube.common.vremanagement.deployer.stubs.common.FeedbackMessage;
import org.gcube.common.vremanagement.deployer.stubs.common.PackageInfo;
import org.gcube.common.vremanagement.deployer.stubs.common.PackageInfoStatus;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.ResourceManagerPortType;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.SendReportParameters;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.service.ResourceManagerServiceAddressingLocator;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;

public class Report {
    private static final long serialVersionUID = -2356724474252349627L;
    private EndpointReferenceType callbackEPR = null;
    private String callbackID = "";
    private TYPE type;
    private REPORTSTATUS status = REPORTSTATUS.OPEN;
    private Map<String, PackageInfo> riids = new HashMap<String, PackageInfo>();
    private PackageInfoStatus[] report_data;
    private Date lastUpdate;
    private boolean localDeployment = false;
    private GCUBEScope callerScope;
    protected final GCUBELog logger = new GCUBELog((Object)this);

    public Report(EndpointReferenceType callbackEPR, String callbackID, int numOfPackages, TYPE type, GCUBEScope callerScope) {
        this.callbackEPR = callbackEPR;
        this.callbackID = callbackID;
        this.callerScope = callerScope;
        if (callbackEPR == null || callbackID == null || callbackID.compareToIgnoreCase("") == 0) {
            this.localDeployment = true;
        }
        this.report_data = new PackageInfoStatus[numOfPackages];
        this.type = type;
    }

    private Report() {
    }

    public void addPackage(PackageInfo deployedpackage, PACKAGESTATUS status, int position, String ... message) {
        PackageInfoStatus pack = new PackageInfoStatus();
        pack.set_package(deployedpackage);
        pack.setStatus(status.name());
        if (message != null && message.length > 0) {
            pack.setMessage(message[0]);
        } else {
            pack.setMessage("");
        }
        this.report_data[position] = pack;
        this.lastUpdate = new GregorianCalendar().getTime();
    }

    public void addRI(String riid, PackageInfo pack) {
        this.riids.put(riid, pack);
    }

    public void send() throws IOException {
        FeedbackMessage message = new FeedbackMessage();
        message.setPackageInfoStatus(this.report_data);
        message.setType(this.type.name());
        message.setRunningInstanceIDsList(null);
        message.setCallbackID(this.callbackID);
        boolean sent = false;
        if (this.localDeployment || this.callbackEPR == null) {
            this.logger.debug((Object)"Local deployment report: ");
            this.logger.debug((Object)this.toXML());
            sent = true;
        } else {
            this.logger.debug((Object)"Sending deployment report: ");
            this.logger.debug((Object)this.toXML());
            this.logger.debug((Object)("Trying to send report to: " + this.callbackEPR.toString()));
            int attempt = 0;
            while (attempt++ < 3 && !sent) {
                try {
                    ResourceManagerPortType pt = (ResourceManagerPortType)GCUBERemotePortTypeContext.getProxy((Remote)new ResourceManagerServiceAddressingLocator().getResourceManagerPortTypePort(this.callbackEPR), (GCUBEScope)this.callerScope, (int)120000, (GCUBESecurityManager[])new GCUBESecurityManager[]{ServiceContext.getContext()});
                    pt.sendReport(new SendReportParameters(this.callbackID, this.toXML()));
                    sent = true;
                }
                catch (Exception e) {
                    this.logger.error((Object)"Error while trying to contact the VREManager to send the deployment report ", (Throwable)e);
                }
            }
        }
        if (sent) {
            this.logger.debug((Object)"Report sent");
        } else {
            this.logger.error((Object)"Unable to sebd back the deployment report");
        }
    }

    public PackageInfo getPackageInfo(int i) {
        return this.report_data[i].get_package();
    }

    public String getPackageStatus(int i) {
        return this.report_data[i].getStatus();
    }

    public void close() {
        this.status = REPORTSTATUS.CLOSED;
        this.lastUpdate = new GregorianCalendar().getTime();
    }

    private String toXML() throws IOException {
        StringWriter report = new StringWriter();
        String NS = "";
        KXmlSerializer serializer = new KXmlSerializer();
        serializer.setOutput((Writer)report);
        try {
            serializer.startDocument("", Boolean.valueOf(true));
            serializer.startTag("", "Report");
            if (this.callbackEPR != null && this.callbackEPR.getAddress() != null) {
                serializer.startTag("", "Caller").text(this.callbackEPR.getAddress().toString()).endTag("", "Caller");
            }
            if (this.callerScope != null) {
                serializer.startTag("", "CallerScope").text(this.callerScope.toString()).endTag("", "CallerScope");
            }
            serializer.startTag("", "CallbackID").text(this.callbackID).endTag("", "CallbackID");
            serializer.startTag("", "GHNID").text(GHNContext.getContext().getGHNID()).endTag("", "GHNID");
            serializer.startTag("", "Type").text(this.type.name()).endTag("", "Type");
            serializer.startTag("", "Status").text(this.status.name()).endTag("", "Status");
            serializer.startTag("", "LastUpdate").text(ProfileDate.toXMLDateAndTime(this.lastUpdate)).endTag("", "LastUpdate");
            serializer.startTag("", "Packages");
            for (PackageInfoStatus p : this.report_data) {
                serializer.startTag("", "Package");
                serializer.startTag("", "ServiceClass").text(p.get_package().getServiceClass()).endTag("", "ServiceClass");
                serializer.startTag("", "ServiceName").text(p.get_package().getServiceName()).endTag("", "ServiceName");
                serializer.startTag("", "ServiceVersion").text(p.get_package().getServiceVersion()).endTag("", "ServiceVersion");
                serializer.startTag("", "PackageName").text(p.get_package().getName()).endTag("", "PackageName");
                serializer.startTag("", "PackageVersion").text(p.get_package().getVersion()).endTag("", "PackageVersion");
                serializer.startTag("", "Status");
                if (p.getStatus().compareToIgnoreCase(PACKAGESTATUS.DEPLOYED.name()) == 0 && this.status == REPORTSTATUS.CLOSED) {
                    serializer.text(PACKAGESTATUS.ACTIVATED.name());
                } else {
                    serializer.text(p.getStatus());
                }
                serializer.endTag("", "Status");
                serializer.startTag("", "Host").text(GHNContext.getContext().getHostnameAndPort()).endTag("", "Host");
                serializer.startTag("", "Message").text(p.getMessage()).endTag("", "Message");
                serializer.endTag("", "Package");
            }
            serializer.endTag("", "Packages");
            if (this.type == TYPE.DEPLOY) {
                serializer.startTag("", "NewInstances");
                for (String riid : this.riids.keySet()) {
                    serializer.startTag("", "NewInstance");
                    serializer.startTag("", "ID").text(riid).endTag("", "ID");
                    serializer.startTag("", "ServiceClass").text(this.riids.get(riid).getServiceClass()).endTag("", "ServiceClass");
                    serializer.startTag("", "ServiceName").text(this.riids.get(riid).getServiceName()).endTag("", "ServiceName");
                    serializer.startTag("", "ServiceVersion").text(this.riids.get(riid).getServiceVersion()).endTag("", "ServiceVersion");
                    serializer.startTag("", "PackageName").text(this.riids.get(riid).getName()).endTag("", "PackageName");
                    serializer.startTag("", "PackageVersion").text(this.riids.get(riid).getVersion()).endTag("", "PackageVersion");
                    serializer.endTag("", "NewInstance");
                }
                serializer.endTag("", "NewInstances");
            }
            serializer.endTag("", "Report");
            serializer.endDocument();
        }
        catch (Exception e) {
            this.logger.error((Object)"The report does not have a valid serialisation ", (Throwable)e);
            throw new IOException("The report does not have a valid serialisation " + e.getMessage());
        }
        finally {
            report.close();
        }
        return report.toString();
    }

    public synchronized void save() throws IOException {
        FileWriter file = new FileWriter(Report.getReportFile(this.callbackID));
        this.logger.trace((Object)("Saving report to " + Report.getReportFile(this.callbackID)));
        file.write(this.toXML());
        file.flush();
        file.close();
    }

    public synchronized boolean delete() throws IOException {
        return Report.getReportFile(this.callbackID).delete();
    }

    private static File getReportFile(String id) throws IOException {
        return new File(Configuration.REPORTDIR + File.separator + id + ".xml");
    }

    public static Report load(String id) throws ReportNotFoundException, IOException, ReportNotValidException, Exception {
        String s;
        GCUBELog logger = new GCUBELog(Report.class);
        logger.trace((Object)"Checking the report ID...");
        if (id == null || id.compareTo("") == 0) {
            throw new ReportNotFoundException();
        }
        logger.trace((Object)"Opening the report...");
        File f = Report.getReportFile(id);
        logger.trace((Object)("Checking the report file at " + f.getAbsolutePath()));
        if (!f.exists()) {
            throw new ReportNotFoundException();
        }
        logger.trace((Object)"Deserializing the report...");
        BufferedReader br = new BufferedReader(new FileReader(f));
        StringBuilder report = new StringBuilder();
        while ((s = br.readLine()) != null) {
            report.append(s);
        }
        br.close();
        return Report.parse(report.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Report parse(String report) throws ReportNotValidException, Exception {
        GCUBELog logger = new GCUBELog(Report.class);
        logger.debug((Object)("Parsing report " + report));
        Report reportobj = new Report();
        KXmlParser parser = new KXmlParser();
        try {
            parser.setInput((Reader)new BufferedReader(new StringReader(report)));
            while (true) {
                switch (parser.next()) {
                    case 2: {
                        if (parser.getName().equals("CallbackID")) {
                            reportobj.callbackID = parser.nextText();
                            break;
                        }
                        if (parser.getName().equals("Caller")) {
                            reportobj.callbackEPR = new EndpointReferenceType();
                            reportobj.callbackEPR.setAddress((AttributedURI)new Address(parser.nextText().trim()));
                            break;
                        }
                        if (parser.getName().equals("CallerScope")) {
                            reportobj.callerScope = GCUBEScope.getScope((String)parser.nextText());
                            break;
                        }
                        if (parser.getName().equals("Type")) {
                            reportobj.type = TYPE.valueOf(parser.nextText());
                            break;
                        }
                        if (parser.getName().equals("LastUpdate")) {
                            reportobj.lastUpdate = ProfileDate.fromXMLDateAndTime(parser.nextText());
                            break;
                        }
                        if (parser.getName().equals("Status")) {
                            reportobj.status = REPORTSTATUS.valueOf(parser.nextText());
                            break;
                        }
                        if (!parser.getName().equals("Packages")) break;
                        Report.parsePackages(parser, reportobj);
                        break;
                    }
                    case 1: {
                        return reportobj;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Unable to parse the Deployer Report ", (Throwable)e);
            throw e;
        }
    }

    private static void parsePackages(KXmlParser parser, Report report) throws Exception {
        ArrayList<PackageInfoStatus> packagelist;
        block23: {
            packagelist = new ArrayList<PackageInfoStatus>();
            while (true) {
                block1 : switch (parser.next()) {
                    case 2: {
                        if (parser.getName().equals("Package")) {
                            PackageInfoStatus pstatus = new PackageInfoStatus();
                            pstatus.set_package(new PackageInfo());
                            while (true) {
                                switch (parser.next()) {
                                    case 2: {
                                        if (parser.getName().equals("ServiceClass")) {
                                            pstatus.get_package().setServiceClass(parser.nextText());
                                            break;
                                        }
                                        if (parser.getName().equals("ServiceName")) {
                                            pstatus.get_package().setServiceName(parser.nextText());
                                            break;
                                        }
                                        if (parser.getName().equals("ServiceVersion")) {
                                            pstatus.get_package().setServiceVersion(parser.nextText());
                                            break;
                                        }
                                        if (parser.getName().equals("PackageName")) {
                                            pstatus.get_package().setName(parser.nextText());
                                            break;
                                        }
                                        if (parser.getName().equals("PackageVersion")) {
                                            pstatus.get_package().setVersion(parser.nextText());
                                            break;
                                        }
                                        if (parser.getName().equals("Status")) {
                                            pstatus.setStatus(parser.nextText());
                                            break;
                                        }
                                        if (parser.getName().equals("Message")) {
                                            pstatus.setMessage(parser.nextText());
                                            break;
                                        }
                                        parser.nextText();
                                        break;
                                    }
                                    case 3: {
                                        if (!parser.getName().equals("Package")) break;
                                        packagelist.add(pstatus);
                                        break block1;
                                    }
                                    case 1: {
                                        throw new Exception("Parsing failed at Package");
                                    }
                                }
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (parser.getName().equals("Packages")) {
                            break block23;
                        }
                        break;
                    }
                    case 1: {
                        throw new Exception("Parsing failed at Packages");
                    }
                }
            }
        }
        report.report_data = new PackageInfoStatus[packagelist.size()];
        report.report_data = packagelist.toArray(report.report_data);
    }

    public void updatePackageStatus(PackageInfo p, PACKAGESTATUS status, String ... message) {
        for (PackageInfoStatus inpackagestatus : this.report_data) {
            if (!inpackagestatus.get_package().getName().equalsIgnoreCase(p.getName()) || !inpackagestatus.get_package().getVersion().equalsIgnoreCase(p.getVersion()) || !inpackagestatus.get_package().getServiceClass().equalsIgnoreCase(p.getServiceClass()) || !inpackagestatus.get_package().getServiceName().equalsIgnoreCase(p.getServiceName()) || !inpackagestatus.get_package().getServiceVersion().equalsIgnoreCase(p.getServiceVersion())) continue;
            inpackagestatus.setStatus(status.name());
            if (message != null && message.length > 0) {
                inpackagestatus.setMessage(message[0]);
            }
            if (status == PACKAGESTATUS.RUNNING) {
                try {
                    this.addRI(GHNContext.getContext().getServiceContext(p.getServiceClass(), p.getServiceName()).getInstance().getID(), p);
                }
                catch (Exception e) {
                    this.logger.error((Object)"Unable to add the instance information", (Throwable)e);
                    this.logger.warn((Object)("Unable to add the instance information for " + p.getServiceName()));
                }
            }
            this.lastUpdate = new GregorianCalendar().getTime();
            this.logger.debug((Object)"package updated");
        }
    }

    public static class ReportNotValidException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    public static class ReportNotFoundException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    public static enum REPORTSTATUS {
        OPEN,
        CLOSED;

    }

    public static enum TYPE {
        DEPLOY,
        UNDEPLOY,
        PATCH,
        UPDATE;

    }

    public static enum PACKAGESTATUS {
        FAILED,
        DEPLOYED,
        STARTED,
        WAITING,
        ALREADYDEPLOYED,
        NOTVERIFIED,
        REFERRED,
        UPDATED,
        SKIPPED,
        PATCHED,
        RUNNING,
        ACTIVATED,
        UNDEPLOYED,
        NOTUNDEPLOYABLE,
        REMOVEDFROMSCOPE,
        REGISTERED,
        ALREADYREGISTERED;

    }
}

