/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.resources.undeployment;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.Set;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.plugins.GCUBEPluginManager;
import org.gcube.common.core.resources.GCUBEService;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.vremanagement.deployer.impl.operators.common.DeployException;
import org.gcube.common.vremanagement.deployer.impl.operators.common.InvalidPackageArchiveException;
import org.gcube.common.vremanagement.deployer.impl.resources.BaseTypedPackage;
import org.gcube.common.vremanagement.deployer.impl.resources.undeployment.UndeployablePackage;

public class UndeployablePluginPackage
extends UndeployablePackage {
    private static final long serialVersionUID = 5969025339248385732L;

    public UndeployablePluginPackage(BaseTypedPackage base) {
        super(base);
    }

    @Override
    protected void packageUndeploy(Set<GCUBEScope> scopes, boolean cleanState) throws DeployException, InvalidPackageArchiveException {
        this.logger.debug((Object)("Undeploy operation called on a " + this.getType().name() + " package"));
        this.printFiles();
        for (File file : this.getPackageFileList()) {
            this.logger.debug((Object)("Removing file " + file.getAbsolutePath()));
            file.delete();
        }
        try {
            GCUBEServiceContext service = GHNContext.getContext().getServiceContext(this.getProperty("Class"), this.getProperty("Name"));
            GCUBEService pluginProfile = (GCUBEService)GHNContext.getImplementation(GCUBEService.class);
            pluginProfile.load((Reader)new StringReader(this.getProperty("SerializedProfile")));
            GCUBEPluginManager manager = service.getPluginManager();
            if (manager.getPlugins().get(pluginProfile.getServiceName()) != null) {
                manager.deregisterPlugin(pluginProfile.getServiceName());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to unregister the plugin");
            throw new DeployException(e);
        }
    }

    @Override
    public boolean requireRestart() {
        return true;
    }

    @Override
    public boolean verify() throws InvalidPackageArchiveException {
        for (File file : this.getPackageFileList()) {
            this.logger.trace((Object)("Verifying file " + file.getAbsolutePath()));
            if (!file.exists()) continue;
            return false;
        }
        return true;
    }
}

