package org.gcube.common.vremanagement.deployer.impl.operators;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vremanagement.deployer.impl.operators.common.Report;
import org.gcube.common.vremanagement.deployer.impl.operators.common.Report.PACKAGESTATUS;
import org.gcube.common.vremanagement.deployer.impl.operators.common.Report.TYPE;
import org.gcube.common.vremanagement.deployer.impl.operators.deployment.Downloader;
import org.gcube.common.vremanagement.deployer.impl.operators.deployment.ExternalPackageExtractor;
import org.gcube.common.vremanagement.deployer.impl.operators.deployment.PackageExtractor;
import org.gcube.common.vremanagement.deployer.impl.operators.deployment.Downloader.PackageType;
import org.gcube.common.vremanagement.deployer.impl.resources.deployment.Deployable;
import org.gcube.common.vremanagement.deployer.impl.state.DeployerResource;
import org.gcube.common.vremanagement.deployer.stubs.common.PackageInfo;
import org.gcube.common.vremanagement.deployer.stubs.deployer.UpdateParameters;

public class UpdateOperator extends  GCUBEHandler<GCUBEHandler<?>> {

	protected final GCUBELog  logger = new GCUBELog(UpdateOperator.class);
	
	private UpdateParameters params;
	
	private boolean rollback = false;
	
	private GCUBEScope callerScope = null;
	
	private DeployerResource resource = null;
	/**
	 * Creates a new update operator
	 * @param params
	 */
	public UpdateOperator(DeployerResource deployerResource, UpdateParameters params, GCUBEScope callerScope) {
		this.params = params;
		this.resource = deployerResource;
	}
		
	@Override 
	public void run() throws Exception {
		PackageInfo[] packages = this.params.get_package();
		
		//block until condition holds
		DeployerOperator.deployLock.lock();
		
		//prepare the report to send back to the DLManagement service
		Report finalreport = new Report(params.getEndpointReference(), params.getCallbackID(), packages.length, TYPE.DEPLOY, this.callerScope);
		this.resource.setLastDeployment(params.getCallbackID());
		//initialise the report: this is needed since the report is periodically sent back to the requester and it must be always complete
		//here we put all the input packages in a waiting status
		for (int i = 0; i < packages.length; i++) {
			PackageInfo deployable_package = packages[i];
			finalreport.addPackage(deployable_package, PACKAGESTATUS.WAITING, i);
		}
		
		//loop on the input list and do the deploy
		//List<String> riids = new ArrayList<String>();
		boolean restart = false;		
		for (int i = 0; i < packages.length; i++) {									
			PackageInfo deployable_package = packages[i];
			logger.info("updating the package " + deployable_package.getName() + "... ");
						
			// if a rollback will be performed, all the remaining packages are discarded
			if (this.rollback) {
				finalreport.addPackage(deployable_package, PACKAGESTATUS.SKIPPED, i);
				logger.warn("the package " + deployable_package.getName() + " could not be updated due to a previous error in another package");
				continue;
			}
			try {
				//download the package
				logger.debug("initialising the downloader for package " + deployable_package.getName() + "... ");
				Downloader manager = new Downloader(deployable_package, true);				
				manager.downloadPackage();
				//get the package
				Deployable pack = null;
				if (manager.getPackagetype() == PackageType.SERVICEARCHIVE) {
					pack = new PackageExtractor(manager).getPackage();;
				} else if (manager.getPackagetype() == PackageType.JAR) {
					pack = new ExternalPackageExtractor(manager).getPackage();;
				} 
				
				//... and try to deploy it
				if (pack != null) {
					pack.deploy(null);
					finalreport.addPackage(deployable_package, PACKAGESTATUS.UPDATED, i);
					logger.info("the package " + deployable_package.getName() + " has been successfully updated");
					//check if the package requires a container restart later
					if (pack.requireRestart())
						restart = true;
				} else {
					finalreport.addPackage(deployable_package, PACKAGESTATUS.FAILED, i);
					logger.warn("the package " + deployable_package.getName() + " has NOT been successfully updated");
					this.rollback = true;			
					continue;
				}
			} catch (Exception e) {
				logger.warn("the package " + deployable_package.getName() + " has NOT been successfully updated" ,e);
				finalreport.addPackage(deployable_package, PACKAGESTATUS.FAILED, i);
				this.rollback = true;							
			}
		}
		if (this.rollback)
			this.rollback();
						
		//send back the report
		if (restart) {
			finalreport.send();		
			finalreport.save();
			GHNContext.getContext().restart();
		} else {
			finalreport.close();
			finalreport.send();		
			finalreport.save();
		}
		//unlockin for other operations
		DeployerOperator.deployLock.unlock();
	}

	/**
	 * Tries to undeploy the installed packages
	 */
	private void rollback() {
		
	}
}
