/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.stubs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.executor.stubs.AnyMap;
import org.gcube.vremanagement.executor.stubs.TaskDescription;
import org.gcube.vremanagement.executor.stubs.TaskPortType;
import org.gcube.vremanagement.executor.stubs.Utils;
import org.gcube.vremanagement.executor.stubs.service.TaskServiceAddressingLocator;
import org.oasis.wsrf.properties.GetMultipleResourcePropertiesResponse;
import org.oasis.wsrf.properties.GetMultipleResourceProperties_Element;

public class TaskProxy {
    static GCUBELog logger = new GCUBEClientLog(TaskProxy.class, new Properties[0]);
    List<QName> staticRPs = Arrays.asList(Utils.TASK_TYPE_RP, Utils.TASK_STARTED_RP, Utils.TASK_INPUT_RP);
    List<QName> dynamicRPs = Arrays.asList(Utils.TASK_STATE_RP, Utils.TASK_OUTPUT_RP, Utils.TASK_LOG_RP, Utils.TASK_ERROR_RP);
    private EndpointReferenceType epr;
    private String state;
    private String log;
    private String error;
    private Calendar startTime;
    private Map<String, Object> inputs = new HashMap<String, Object>();
    private Map<String, Object> outputs = new HashMap<String, Object>();
    private TaskDescription type;

    public TaskProxy(EndpointReferenceType epr) throws Exception {
        this.epr = epr;
        this.synchronize();
    }

    public String getState() {
        return this.state;
    }

    public String getLog() {
        return this.log;
    }

    public String getError() {
        return this.error;
    }

    public Calendar getStartTime() {
        return this.startTime;
    }

    public Map<String, Object> getOutput() {
        return this.outputs;
    }

    public Map<String, Object> getInput() {
        return this.inputs;
    }

    public TaskDescription getType() {
        return this.type;
    }

    public void synchronize() throws Exception {
        MessageElement[] elements;
        TaskPortType task = new TaskServiceAddressingLocator().getTaskPortTypePort(this.epr);
        List<QName> RPs = this.dynamicRPs;
        if (this.startTime == null) {
            RPs = new ArrayList<QName>(RPs);
            RPs.addAll(this.staticRPs);
        }
        GetMultipleResourcePropertiesResponse response = task.getMultipleResourceProperties(new GetMultipleResourceProperties_Element(RPs.toArray(new QName[0])));
        for (MessageElement e : elements = response.get_any()) {
            if (e.getQName().equals(Utils.TASK_STATE_RP)) {
                this.state = e.getValue();
                continue;
            }
            if (e.getQName().equals(Utils.TASK_OUTPUT_RP)) {
                Map<String, Object> outputs = Utils.intern((AnyMap)e.getObjectValue(AnyMap.class));
                if (outputs == null) continue;
                this.outputs = outputs;
                continue;
            }
            if (e.getQName().equals(Utils.TASK_LOG_RP)) {
                this.log = e.getValue();
                continue;
            }
            if (e.getQName().equals(Utils.TASK_ERROR_RP)) {
                this.error = e.getValue();
                continue;
            }
            if (e.getQName().equals(Utils.TASK_STARTED_RP)) {
                this.startTime = (Calendar)e.getObjectValue(Calendar.class);
                continue;
            }
            if (e.getQName().equals(Utils.TASK_INPUT_RP)) {
                Map<String, Object> inputs = Utils.intern((AnyMap)e.getObjectValue(AnyMap.class));
                if (inputs == null) continue;
                this.inputs = inputs;
                continue;
            }
            if (!e.getQName().equals(Utils.TASK_TYPE_RP)) continue;
            this.type = (TaskDescription)e.getObjectValue(TaskDescription.class);
        }
    }

    public String toString() {
        try {
            return "Type:" + this.getType() + "\nState:" + this.getState() + "\nInputs:" + this.getInput() + "\nLog:" + this.getLog() + "\nOutputs:" + this.getOutput() + "\nError:" + this.getError() + "\nStarted:" + this.getStartTime().getTime();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

