package org.gcube.vremanagement.executor.contexts;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;

/**
 * The context of the <code>Task</code> port-type of the service.
 * @author Fabio Simeoni (University of Strathclyde).
 **/
public class TaskPTContext extends GCUBEStatefulPortTypeContext{
	
	/** Port-type JNDI name. */
	static public final String PORTTYPE_NAME = "gcube/vremanagement/executor/task";
	
	/**  Port-type namespace. */
	static public final String PORTTYPE_NAMESPACE = "http://gcube-system.org/namespaces/vremanagement/executor";

	/** Singleton instance. */
	protected static TaskPTContext cache = new TaskPTContext();

	/** Creates an instance . */
	private TaskPTContext(){}
	
	/** Returns a context instance.
	 * @return the context.*/
	public static TaskPTContext getContext() {return cache;}
	
	/**{@inheritDoc}*/
	public String getJNDIName() {return PORTTYPE_NAME ;}

	/** {@inheritDoc}*/
	public String getNamespace() {return PORTTYPE_NAMESPACE;}

	/**{@inheritDoc} */
	public GCUBEServiceContext getServiceContext() {return ServiceContext.getContext();}

}
