package org.gcube.vremanagement.executor.persistence;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import java.util.Map;

import org.gcube.common.core.contexts.GCUBEServiceContext.Status;
import org.gcube.common.core.persistence.GCUBEWSFilePersistenceDelegate;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.vremanagement.executor.contexts.EnginePTContext;
import org.gcube.vremanagement.executor.contexts.ServiceContext;
import org.gcube.vremanagement.executor.plugin.ExecutorPluginContext;
import org.gcube.vremanagement.executor.state.TaskResource;
import org.globus.wsrf.NoSuchResourceException;

/**
 * Extends {@link GCUBEWSFilePersistenceDelegate} to (de)serialise {@link TaskResource TaskResources}.
 * @author fabio
 *
 */
public class TaskPersistenceDelegate extends GCUBEWSFilePersistenceDelegate<TaskResource> {

	/**{@inheritDoc}*/
	@SuppressWarnings({"rawtypes","unchecked"})
	protected void onLoad(TaskResource resource, ObjectInputStream stream) throws Exception {
		super.onLoad(resource, stream);
		//need to make sure engine port-type is up and running, cannot think of better
		while (ServiceContext.getContext().getStatus()!=Status.READIED) {Thread.sleep(100);}
		//restore plugin context associated with task
		ExecutorPluginContext context = EnginePTContext.getContext().getEngine().getContext((String) stream.readObject());
		if (context==null) throw new NoSuchResourceException(); //cancelled meanwhile?
		resource.setContext(context);
		//deserialise the rest.
		resource.setStartTime((Calendar) stream.readObject());
		resource.setInputs((Map)stream.readObject());
		resource.setOutputs((Map)stream.readObject());
		resource.setLog((String) stream.readObject());
		resource.setError((String) stream.readObject());
		resource.setState((String)stream.readObject());
		//restart deserialised task only if is not due to expire 
		if (resource.getTerminationTime()==null) {
			GCUBEScope scope = GCUBEScope.getScope(resource.getResourcePropertySet().getScope().get(0));
			ServiceContext.getContext().setScope(scope);
			resource.launch(scope); //work in the resource's scope  
		}
		
	}
	
	/**{@inheritDoc}*/
	protected void onStore(TaskResource resource, ObjectOutputStream stream) throws Exception {
		super.onStore(resource, stream);
		stream.writeObject(resource.getContext().getDescription().getName()); //name will be used as a key to restore plugin context.
		stream.writeObject(resource.getStartTime());
		stream.writeObject(resource.getInputs());
		stream.writeObject(resource.getOutputs());
		stream.writeObject(resource.getLog());
		stream.writeObject(resource.getError());
		stream.writeObject(resource.getTask().getState().toString());
	}
}
