/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.state;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.gcube.vremanagement.executor.plugin.ExecutorPluginContext;
import org.gcube.vremanagement.executor.state.TaskResource;

public class TaskRuntime {
    TaskResource resource;

    public TaskRuntime() {
    }

    public TaskRuntime(TaskResource resource) {
        this.resource = resource;
    }

    public ExecutorPluginContext getContext() {
        return this.resource.getContext();
    }

    public Calendar getStartTime() {
        return this.resource.getStartTime();
    }

    public Map<String, Object> getInputs() {
        HashMap inputs = this.resource.getInputs();
        return inputs == null ? new HashMap() : inputs;
    }

    public Object getInput(String name) {
        return this.getInputs().get(name);
    }

    private Map<String, Object> getOutputs() {
        HashMap outputs = this.resource.getOutputs();
        return outputs == null ? new HashMap() : outputs;
    }

    public synchronized Object addOutput(String name, Object value) {
        Map<String, Object> outputs = this.getOutputs();
        Object o = outputs.put(name, value);
        this.resource.setOutputs(outputs);
        return o;
    }

    public synchronized void addOutput(Entry ... entries) {
        if (entries == null || entries.length == 0) {
            return;
        }
        Map<String, Object> outputs = this.getOutputs();
        for (Entry entry : entries) {
            outputs.put(entry.name, entry.value);
        }
        this.resource.setOutputs(outputs);
    }

    public synchronized void removeOutput(String ... names) {
        if (names == null) {
            return;
        }
        Map<String, Object> outputs = this.getOutputs();
        for (String name : names) {
            outputs.remove(name);
        }
        this.resource.setOutputs(outputs);
    }

    public synchronized void throwException(Exception e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        this.resource.setError("\n" + writer.getBuffer().toString());
    }

    public static class Entry {
        public String name;
        public Object value;

        public Entry(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }
}

