package org.gcube.vremanagement.executor.porttypes;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.vremanagement.executor.contexts.EnginePTContext;
import org.gcube.vremanagement.executor.contexts.ServiceContext;
import org.gcube.vremanagement.executor.state.EngineResource;
import org.gcube.vremanagement.executor.state.TaskResource;
import org.gcube.vremanagement.executor.stubs.LaunchParameters;

/**
 * Implements the engine port-type of the Executor service.
 * <p>
 * The port-type offers facilities to launch tasks.
 * 
 * @author Fabio Simeoni (University of Strathclyde) 
 * @author Kostantinos Liaskov (University of Strathclyde)
 */
public class EnginePT extends GCUBEPortType {
	
	/**{@inheritDoc} */
	@Override protected GCUBEServiceContext getServiceContext() {return ServiceContext.getContext();}
	
	/**
	 * Launches a task with given parameters.
	 * @param parameters the parameters.
	 * @return the reference to a WS-Resource that models the execution of the task. 
	 * @throws GCUBEFault if the a task with that name did not exist or could not be launched.
	 */
	public EndpointReferenceType launch(LaunchParameters parameters) throws GCUBEFault {
		String errMsg = "could not launch "+parameters.getName()+" task";
		try {
			EngineResource engine = EnginePTContext.getContext().getEngine();
			TaskResource task = engine.launch(parameters.getName(),parameters.getInputs());
			task.store();
			return task.getEPR();
		}
		catch (GCUBEException e) {
			logger.error(errMsg,e);
			throw e.toFault(errMsg);
	    }
		catch (Exception e) {
			logger.error(errMsg,e);
			throw ServiceContext.getContext().getDefaultException(errMsg,e).toFault();
	    }
	}

}
