/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.resources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.vremanagement.deployer.stubs.common.PackageInfo;
import org.gcube.vremanagement.resourcemanager.impl.operators.Operator;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResource;
import org.gcube.vremanagement.resourcemanager.impl.resources.software.Dependency;
import org.gcube.vremanagement.resourcemanager.impl.resources.software.GCUBEPackage;
import org.gcube.vremanagement.resourcemanager.impl.resources.software.SoftwareGatewayRequest;
import org.gcube.vremanagement.resourcemanager.impl.state.VirtualNode;

public class ScopedDeployedSoftware
extends ScopedResource {
    public static final String TYPE = "Service";
    private List<Dependency> resolved = new ArrayList<Dependency>();
    private List<Dependency> missing = new ArrayList<Dependency>();
    private Map<String, List<Dependency>> node2packages = new HashMap<String, List<Dependency>>();
    private Map<String, List<Dependency>> node2missing = new HashMap<String, List<Dependency>>();
    private GCUBEPackage sourcePackage;
    private String RIID;
    private String virtualNodeName;
    private String lastActivityOnGHN;
    private transient VirtualNode targetVirtualNode;

    protected ScopedDeployedSoftware(String id, GCUBEScope scope) {
        super(id, TYPE, scope);
    }

    public void setSourcePackage(GCUBEPackage sourcePackage) {
        this.sourcePackage = sourcePackage;
    }

    public GCUBEPackage getSourcePackage() {
        return this.sourcePackage;
    }

    public List<Dependency> getResolvedDependencies(String ghnName) {
        if (this.node2packages.get(ghnName) == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.node2packages.get(ghnName));
    }

    public List<Dependency> getLastResolvedDependencies() {
        return Collections.unmodifiableList(this.resolved);
    }

    public void setResolvedDependencies(List<Dependency> dependencies) {
        this.resolved = dependencies;
    }

    public List<Dependency> getMissingDependencies(String ghnName) {
        if (this.node2missing.get(ghnName) == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.node2missing.get(ghnName));
    }

    public List<Dependency> getLastMissingDependencies() {
        return this.missing;
    }

    public void setMissingDependencies(List<Dependency> dependencies) {
        this.missing = dependencies;
    }

    @Override
    protected void find() throws Exception {
        SoftwareGatewayRequest request = new SoftwareGatewayRequest();
        request.addSoftware(this);
        this.setErrorMessage("");
        try {
            request.send(GCUBEScope.getScope((String)this.scope));
            if (this.resolved.size() == 0) {
                this.success = false;
                this.setErrorMessage("Invalid list of dependecies retrieved from the Software Repository");
            } else if (this.missing.size() > 0) {
                this.success = false;
                this.setErrorMessage("The service cannot be deployed due to one or more missing dependencies: " + this.missing);
            } else {
                this.success = true;
            }
        }
        catch (Exception e) {
            this.success = false;
            this.setErrorMessage("Unable to resolve the list of dependencies for this service " + e.getMessage());
            this.getLogger().error((Object)("Unable to resolve the list of deps for " + this.sourcePackage), (Throwable)e);
            throw new Exception("Unable to resolve the list of dependencies for " + this.sourcePackage, e);
        }
    }

    @Override
    protected void addToScope() throws ScopedResource.ResourceNotFound, Exception {
        this.logger.trace((Object)("This service belongs to " + this.scope));
        if (!this.isSuccess()) {
            this.noHopeForMe(this.getErrorMessage(), new Exception());
        }
        if (this.targetVirtualNode == null) {
            this.noHopeForMe("Unable to find a suitable target Node where to deploy the service", new Exception());
        }
        this.action = Operator.ACTION.ADD;
        this.setErrorMessage("");
        try {
            this.targetVirtualNode.setWorkingScope(GCUBEScope.getScope((String)this.scope));
            this.targetVirtualNode.deploy();
            ArrayList<Dependency> resolvedPackages = new ArrayList<Dependency>();
            for (Dependency dep : this.resolved) {
                resolvedPackages.add(dep);
            }
            ArrayList<Dependency> missingPackages = new ArrayList<Dependency>();
            for (Dependency dep : this.missing) {
                missingPackages.add(dep);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Failed to deploy on " + this.targetVirtualNode.getName()), (Throwable)e);
            this.noHopeForMe("Unable to contact the target gHN (" + this.targetVirtualNode.getName() + ") where to deploy the service", e);
        }
    }

    @Override
    protected void removeFromScope() throws ScopedResource.ResourceNotFound, Exception {
        this.logger.trace((Object)("Removing the software from " + this.virtualNodeName));
        if (!this.isSuccess()) {
            this.noHopeForMe(this.getErrorMessage(), new Exception());
        }
        this.action = Operator.ACTION.REMOVE;
        try {
            this.targetVirtualNode.setWorkingScope(GCUBEScope.getScope((String)this.scope));
            this.targetVirtualNode.undeploy();
        }
        catch (Exception e) {
            this.noHopeForMe("Unable to find the gHN with id " + this.lastActivityOnGHN + " to undeploy the instance of " + this.sourcePackage, new VirtualNode.NoGHNFoundException(""));
        }
    }

    public void scheduleUndeploy(VirtualNode node) throws VirtualNode.NoGHNFoundException {
        this.getLogger().info((Object)("Scheduling undeployment of service " + this.sourcePackage + " from GHN " + this.lastActivityOnGHN));
        if (!this.virtualNodeName.equals(node.getName())) {
            throw new VirtualNode.NoGHNFoundException("Invalid Virtual Node for undeployment: " + node.getName());
        }
        this.targetVirtualNode = node;
        this.removePackagesFromTargetNode();
        this.lastActivityOnGHN = node.getID();
    }

    public void scheduleDeploy(VirtualNode node) {
        this.getLogger().info((Object)("Using GHN " + node.getID() + " for " + this));
        this.id = this.id + "-NODE-" + node.getName();
        this.targetVirtualNode = node;
        this.virtualNodeName = node.getName();
        this.lastActivityOnGHN = node.getID();
        this.sourcePackage.setGHNName(this.getTargetNodeName());
        this.id = this.sourcePackage.getID();
        this.addPackagesToTargetNode();
    }

    public String getTargetNodeID() {
        return this.lastActivityOnGHN;
    }

    public void setRI(String ri) {
        this.RIID = ri;
    }

    public String getRI() {
        return this.RIID;
    }

    public void setCallbackID(String id) throws VirtualNode.NoGHNFoundException {
        if (this.targetVirtualNode == null) {
            throw new VirtualNode.NoGHNFoundException("No virtual node has been set for this software");
        }
        this.targetVirtualNode.setCallbackID(id);
    }

    public String getTargetNodeName() {
        return this.virtualNodeName;
    }

    @Override
    protected int getMaxFindAttempts() {
        return 1;
    }

    private void addPackagesToTargetNode() {
        HashSet<PackageInfo> packages = new HashSet<PackageInfo>();
        List<Dependency> deps = this.resolved;
        for (int i = 0; i < deps.size(); ++i) {
            PackageInfo p = new PackageInfo();
            p.setServiceName(deps.get(i).getService().getName());
            p.setServiceClass(deps.get(i).getService().getClazz());
            p.setServiceVersion(deps.get(i).getService().getVersion());
            p.setVersion(deps.get(i).getVersion());
            p.setName(deps.get(i).getName());
            this.getLogger().trace((Object)("Adding Package to target Node: " + deps.get(i)));
            packages.add(p);
        }
        this.targetVirtualNode.setPackagesToAdd(packages);
    }

    private void removePackagesFromTargetNode() {
        HashSet<PackageInfo> packages = new HashSet<PackageInfo>();
        List<Dependency> deps = this.resolved;
        for (int i = 0; i < deps.size(); ++i) {
            PackageInfo p = new PackageInfo();
            p.setServiceName(deps.get(i).getService().getName());
            p.setServiceClass(deps.get(i).getService().getClazz());
            p.setServiceVersion(deps.get(i).getService().getVersion());
            p.setVersion(deps.get(i).getVersion());
            p.setName(deps.get(i).getName());
            this.getLogger().trace((Object)("Remove Package from target Node: " + deps.get(i)));
            packages.add(p);
        }
        this.targetVirtualNode.setPackagesToRemove(packages);
    }
}

