package org.gcube.vremanagement.resourcemanager.impl.resources;

import java.util.List;

import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGHNQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.resources.GCUBEHostingNode;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.vremanagement.ghnmanager.stubs.AddScopeInputParams;
import org.gcube.common.vremanagement.ghnmanager.stubs.GHNManagerPortType;
import org.gcube.common.vremanagement.ghnmanager.stubs.service.GHNManagerServiceAddressingLocator;
import org.gcube.vremanagement.resourcemanager.impl.contexts.ServiceContext;

/**
 * Models a scoped {@link GCUBEHostingNode}
 * 
 * @author Manuele Simi (ISTI-CNR)
 *
 */
public class ScopedGHN extends ScopedResource {
	
	public static final String TYPE = GCUBEHostingNode.TYPE;
	
	private String nodename = "";
	
	private transient EndpointReferenceType ghnEpr;	
	
	protected ScopedGHN(String id, GCUBEScope scope) {
		super(id, TYPE, scope);
	}

	
	@Override
	protected void addToScope() throws ResourceNotFound, Exception {
		if (this.ghnEpr == null)
			this.findResource();
		//contact the GHNManager to add the GHN to the given scope
		EndpointReferenceType endpoint = new EndpointReferenceType();
		try {			
			endpoint.setAddress(new Address("http://"+ this.nodename +"/wsrf/services/gcube/common/vremanagement/GHNManager"));			
			GHNManagerServiceAddressingLocator locator = new GHNManagerServiceAddressingLocator();
			GHNManagerPortType pt = GCUBERemotePortTypeContext.getProxy(locator.getGHNManagerPortTypePort(endpoint), 
					ServiceContext.getContext().getScope().getEnclosingScope(), ServiceContext.getContext());		 
			AddScopeInputParams params = new AddScopeInputParams();
			params.setScope(this.scope.toString());
			params.setMap(""); //eventually, set here the new Service Map
			pt.addScope(params);	
							
		} catch (Exception e) {
			this.noHopeForMe("Failed to add GHN to scope " + scope.toString(), e);			
		}

	}

	@Override
	protected void find() throws Exception {
		ISClient client = null;
		GCUBEGHNQuery query = null;
		try {
			client =  GHNContext.getImplementation(ISClient.class);			
			query = client.getQuery(GCUBEGHNQuery.class);
			query.addAtomicConditions(new AtomicCondition("/ID/text()", this.id));
		} catch (Exception e) {					
			throw new Exception("unable to query of the target GHN (ID=" + this.id + ")", e);			
		}
		try {			 
			 List<GCUBEHostingNode> hostingNodes =  client.execute(query, ServiceContext.getContext().getScope());
			 this.nodename = hostingNodes.get(0).getNodeDescription().getName();
			 this.hostedOn = nodename;
			 this.ghnEpr = this.loadGHNmanager(hostingNodes.get(0).getID(), client, ServiceContext.getContext().getScope());
		} catch (Exception e) {
			//try in the enclosing scope
			try {
				 List<GCUBEHostingNode> hostingNodes = client.execute(query, ServiceContext.getContext().getScope().getEnclosingScope());
				 this.nodename = hostingNodes.get(0).getNodeDescription().getName();
				 this.hostedOn = nodename;
				 this.ghnEpr = this.loadGHNmanager(hostingNodes.get(0).getID(), client,ServiceContext.getContext().getScope().getEnclosingScope());
			} catch (Exception ei) {
				throw new Exception("unable to find the target GHN (ID=" + this.id + ")", e);
			}
		}

	}

	@Override
	protected void removeFromScope() throws ResourceNotFound, Exception {
		if (this.ghnEpr == null)
			this.findResource();
		//EndpointReferenceType endpoint = new EndpointReferenceType();
		try {			
			//endpoint.setAddress(new Address("http://"+ this.nodename +"/wsrf/services/gcube/common/vremanagement/GHNManager"));			
			GHNManagerServiceAddressingLocator locator = new GHNManagerServiceAddressingLocator();
			GHNManagerPortType pt = GCUBERemotePortTypeContext.getProxy(locator.getGHNManagerPortTypePort(this.ghnEpr), 
					ServiceContext.getContext().getScope().getEnclosingScope(), ServiceContext.getContext());			
			pt.removeScope(this.scope.toString());	
		} catch (Exception e) {
			this.noHopeForMe("Failed to remove GHN from scope " + scope.toString(), e);			
		}

	}

	/**
	 * Looks for the GHN manager's endpoint to contact
	 * @param id the identifier of the gHN
	 * @param client the ISClient instance to use
	 * @param scope 
	 * @return the endpoint reference of gHNManager's portType to contact
	 * @throws Exception if the search fails
	 */
	private EndpointReferenceType loadGHNmanager(String id, ISClient client, GCUBEScope scope) throws Exception {
		//looks for the GHN manager's endpoint to contact
		 GCUBERIQuery riquery = client.getQuery(GCUBERIQuery.class);
		 riquery.addAtomicConditions(new AtomicCondition("//GHN/@UniqueID", id), 
					new AtomicCondition("//ServiceClass", "VREManagement"),
					new AtomicCondition("//ServiceName", "GHNManager"));
		 List<GCUBERunningInstance> results = client.execute(riquery,scope);
		 return results.get(0).getAccessPoint().getEndpoint("gcube/common/vremanagement/GHNManager");	
	}


}
