/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.reporting;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.gcube.common.core.contexts.GCUBEContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcemanager.impl.contexts.ServiceContext;
import org.gcube.vremanagement.resourcemanager.impl.reporting.DeployerReport;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedDeployedSoftware;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResource;
import org.gcube.vremanagement.resourcemanager.impl.resources.software.Dependency;
import org.gcube.vremanagement.resourcemanager.impl.resources.software.DeployedDependency;
import org.gcube.vremanagement.resourcemanager.impl.state.ProfileDate;
import org.kxml2.io.KXmlSerializer;

public class Session
implements Serializable {
    protected final GCUBELog logger = new GCUBELog((Object)this, (GCUBEContext)ServiceContext.getContext());
    static final String NS = "";
    private static final long serialVersionUID = 1180822699138069365L;
    private static final String reportDir = "reports";
    private Calendar lastUpdate = new GregorianCalendar();
    private String id = "";
    private OPERATION operation;
    private GCUBEScope scope = null;
    private boolean brokerWasSuccessful;
    private boolean brokerReportAvailable = false;
    private String brokerMessage = "";
    private Map<String, DeployerReport> node2report = Collections.synchronizedMap(new HashMap());
    private Set<ScopedDeployedSoftware> services = Collections.synchronizedSet(new HashSet());
    private Set<ScopedResource> resources = Collections.synchronizedSet(new HashSet());
    private Set<DeployerReport.DeployedRunningInstance> instances = new HashSet<DeployerReport.DeployedRunningInstance>();
    private String deploymentPlan;
    private Timer timer;
    boolean forcedToBeClosed = false;
    String sessionErrorMessage = "";

    private Session() {
    }

    public Session(String id, OPERATION operation, GCUBEScope ... scope) {
        this.id = id;
        this.operation = operation;
        this.scope = scope == null || scope[0] == null ? (GCUBEScope)ServiceContext.getContext().getInstance().getScopes().values().iterator().next() : scope[0];
        this.timer = new Timer("SessionTimer" + id);
    }

    public synchronized void addGHNReport(DeployerReport report) throws Exception {
        this.node2report.put(report.getGHNName(), report);
        this.lastUpdate = new GregorianCalendar();
    }

    public synchronized void addResource(ScopedResource resource) {
        this.resources.add(resource);
        this.lastUpdate = new GregorianCalendar();
    }

    public synchronized void addService(ScopedDeployedSoftware service) {
        this.services.add(service);
        this.lastUpdate = new GregorianCalendar();
    }

    public String toXML() throws IOException {
        StringWriter report = new StringWriter();
        KXmlSerializer serializer = new KXmlSerializer();
        serializer.setOutput((Writer)report);
        try {
            serializer.startDocument("UTF-8", Boolean.valueOf(true));
            serializer.startTag(NS, "ResourceReport");
            serializer.startTag(NS, "ID").text(this.id).endTag(NS, "ID");
            if (this.forcedToBeClosed) {
                serializer.startTag(NS, "Status").text("CLOSED").endTag(NS, "Status");
                serializer.startTag(NS, "SessionExitStatus").text("FAILED").endTag(NS, "SessionExitStatus");
                serializer.startTag(NS, "SessionErrorMessage").text(this.sessionErrorMessage).endTag(NS, "SessionErrorMessage");
            } else if (this.isSessionClosed()) {
                serializer.startTag(NS, "Status").text("CLOSED").endTag(NS, "Status");
                serializer.startTag(NS, "SessionExitStatus").text("SUCCESS").endTag(NS, "SessionExitStatus");
            } else {
                serializer.startTag(NS, "Status").text("OPEN").endTag(NS, "Status");
            }
            serializer.startTag(NS, "Operation").text(this.operation.toString()).endTag(NS, "Operation");
            serializer.startTag(NS, "LastUpdate").text(ProfileDate.toXMLDateAndTime(this.lastUpdate.getTime())).endTag(NS, "LastUpdate");
            serializer.startTag(NS, "TargetScope").text(this.scope.toString()).endTag(NS, "TargetScope");
            serializer.startTag(NS, "Resources");
            for (ScopedResource resource : this.resources) {
                serializer.startTag(NS, "Resource");
                serializer.startTag(NS, "ID").text(resource.getId()).endTag(NS, "ID");
                serializer.startTag(NS, "Type").text(resource.getType()).endTag(NS, "Type");
                if (resource.isSuccess()) {
                    if (this.operation == OPERATION.AddResources) {
                        serializer.startTag(NS, "Status").text("ADDED").endTag(NS, "Status");
                    } else {
                        serializer.startTag(NS, "Status").text("REMOVED").endTag(NS, "Status");
                    }
                } else {
                    serializer.startTag(NS, "Status").text("FAILED").endTag(NS, "Status");
                    serializer.startTag(NS, "ErrorDescription").text(resource.getErrorMessage()).endTag(NS, "ErrorDescription");
                }
                serializer.endTag(NS, "Resource");
            }
            serializer.endTag(NS, "Resources");
            if (this.brokerReportAvailable) {
                serializer.startTag(NS, "DeploymentPlanCreation");
                serializer.startTag(NS, "Status").text(this.brokerWasSuccessful ? "SUCCESS" : "FAILED").endTag(NS, "Status");
                serializer.startTag(NS, "Message").text(this.brokerMessage).endTag(NS, "Message");
                serializer.endTag(NS, "DeploymentPlanCreation");
            }
            serializer.startTag(NS, "Software");
            for (ScopedDeployedSoftware service : this.services) {
                serializer.startTag(NS, "Service");
                serializer.startTag(NS, "ID").text(service.getId()).endTag(NS, "ID");
                serializer.startTag(NS, "Class").text(service.getSourcePackage().getClazz()).endTag(NS, "Class");
                serializer.startTag(NS, "Name").text(service.getSourcePackage().getName()).endTag(NS, "Name");
                serializer.startTag(NS, "Version").text(service.getSourcePackage().getVersion()).endTag(NS, "Version");
                if (service.getSourcePackage().getPackageName() != null) {
                    serializer.startTag(NS, "PackageName").text(service.getSourcePackage().getPackageName()).endTag(NS, "PackageName");
                }
                if (service.getSourcePackage().getPackageVersion() != null) {
                    serializer.startTag(NS, "PackageVersion").text(service.getSourcePackage().getPackageVersion()).endTag(NS, "PackageVersion");
                }
                if ((this.operation == OPERATION.AddResources || this.operation == OPERATION.Create) && service.getStatus() != ScopedResource.STATUS.LOST && this.brokerWasSuccessful) {
                    if (service.getMissingDependencies(service.getTargetNodeName()).size() > 0 || service.getErrorMessage().length() > 0) {
                        serializer.startTag(NS, "DependenciesResolutionStatus").text(DEPSTATUS.FAILED.name()).endTag(NS, "DependenciesResolutionStatus");
                        serializer.startTag(NS, "DeployedOn").text("not deployed").endTag(NS, "DeployedOn");
                        serializer.startTag(NS, "ErrorDescription").text(service.getErrorMessage()).endTag(NS, "ErrorDescription");
                    } else {
                        serializer.startTag(NS, "DependenciesResolutionStatus").text(DEPSTATUS.SUCCESS.name()).endTag(NS, "DependenciesResolutionStatus");
                        serializer.startTag(NS, "DeployedOn").text(service.getTargetNodeName()).endTag(NS, "DeployedOn");
                        serializer.startTag(NS, "ErrorDescription").text("-").endTag(NS, "ErrorDescription");
                    }
                    serializer.startTag(NS, "DependenciesResolution");
                    serializer.startTag(NS, "ResolvedDependencies");
                    for (Dependency dep : service.getLastResolvedDependencies()) {
                        serializer.startTag(NS, "Dependency");
                        serializer.startTag(NS, "ServiceClass").text(dep.getService().getClazz()).endTag(NS, "ServiceClass");
                        serializer.startTag(NS, "ServiceName").text(dep.getService().getName()).endTag(NS, "ServiceName");
                        serializer.startTag(NS, "ServiceVersion").text(dep.getService().getVersion()).endTag(NS, "ServiceVersion");
                        serializer.startTag(NS, "PackageName").text(dep.getName()).endTag(NS, "PackageName");
                        serializer.startTag(NS, "PackageVersion").text(dep.getVersion()).endTag(NS, "PackageVersion");
                        serializer.endTag(NS, "Dependency");
                    }
                    serializer.endTag(NS, "ResolvedDependencies");
                    serializer.startTag(NS, "MissingDependencies");
                    for (Dependency dep : service.getLastMissingDependencies()) {
                        serializer.startTag(NS, "Dependency");
                        serializer.startTag(NS, "ServiceClass").text(dep.getService().getClazz()).endTag(NS, "ServiceClass");
                        serializer.startTag(NS, "ServiceName").text(dep.getService().getName()).endTag(NS, "ServiceName");
                        serializer.startTag(NS, "ServiceVersion").text(dep.getService().getVersion()).endTag(NS, "ServiceVersion");
                        serializer.startTag(NS, "PackageName").text(dep.getName()).endTag(NS, "PackageName");
                        serializer.startTag(NS, "PackageVersion").text(dep.getVersion()).endTag(NS, "PackageVersion");
                        serializer.endTag(NS, "Dependency");
                    }
                    serializer.endTag(NS, "MissingDependencies");
                    serializer.endTag(NS, "DependenciesResolution");
                }
                String targetNodeName = service.getTargetNodeName();
                if (this.operation == OPERATION.AddResources) {
                    serializer.startTag(NS, "DeploymentActivity");
                } else {
                    serializer.startTag(NS, "UndeploymentActivity");
                }
                if (this.node2report.keySet().contains(targetNodeName)) {
                    serializer.startTag(NS, "GHN");
                    serializer.startTag(NS, "Host").text(this.node2report.get(targetNodeName).getHost()).endTag(NS, "Host");
                    serializer.startTag(NS, "LastReportReceivedOn").text(ProfileDate.toXMLDateAndTime(this.node2report.get(targetNodeName).getLastUpdate())).endTag(NS, "LastReportReceivedOn");
                    serializer.startTag(NS, "LastReportReceived");
                    serializer.startTag(NS, "Status").text(this.node2report.get(targetNodeName).getStatus()).endTag(NS, "Status");
                    this.addGHNReport(serializer, this.node2report.get(targetNodeName), service);
                    serializer.endTag(NS, "LastReportReceived");
                    serializer.endTag(NS, "GHN");
                    DeployerReport.DeployedRunningInstance instance = this.getInstanceForService(service);
                    if (this.operation == OPERATION.AddResources || this.operation == OPERATION.Create) {
                        if (instance != null) {
                            serializer.startTag(NS, "RelatedRunningInstance");
                            if (instance.isAlive()) {
                                serializer.startTag(NS, "ID").text(instance.getRIID()).endTag(NS, "ID");
                            }
                            serializer.startTag(NS, "Status").text(instance.isAlive() ? "SUCCESS" : "FAILED").endTag(NS, "Status");
                            serializer.startTag(NS, "Message").text(instance.getMessage()).endTag(NS, "Message");
                            serializer.endTag(NS, "RelatedRunningInstance");
                        } else if (this.node2report.get(targetNodeName).getStatus().compareToIgnoreCase("CLOSED") == 0) {
                            serializer.startTag(NS, "RelatedRunningInstance");
                            serializer.startTag(NS, "Status").text("FAILED").endTag(NS, "Status");
                            serializer.startTag(NS, "Message").text("The Deployer service did not detect any new instance of this service on the target gHN").endTag(NS, "Message");
                            serializer.endTag(NS, "RelatedRunningInstance");
                        }
                    }
                } else if (service.isSuccess() && this.brokerReportAvailable) {
                    serializer.text("The report is still not available for this service");
                } else {
                    serializer.text("No report");
                }
                if (this.operation == OPERATION.AddResources) {
                    serializer.endTag(NS, "DeploymentActivity");
                } else {
                    serializer.endTag(NS, "UndeploymentActivity");
                }
                serializer.endTag(NS, "Service");
            }
            serializer.endTag(NS, "Software");
            serializer.endTag(NS, "ResourceReport");
            serializer.endDocument();
        }
        catch (Exception e) {
            this.logger.error((Object)"The Resource Report does not have a valid serialisation", (Throwable)e);
            throw new IOException("The Resource Report does not have a valid serialisation " + e.getMessage());
        }
        finally {
            report.close();
        }
        return report.toString();
    }

    private DeployerReport.DeployedRunningInstance getInstanceForService(ScopedDeployedSoftware service) {
        for (DeployerReport.DeployedRunningInstance instance : this.instances) {
            if (instance.getServiceClass().compareToIgnoreCase(service.getSourcePackage().getClazz()) != 0 || instance.getServiceName().compareToIgnoreCase(service.getSourcePackage().getName()) != 0) continue;
            return instance;
        }
        return null;
    }

    public Calendar getLastUpdate() {
        return this.lastUpdate;
    }

    public String getId() {
        return this.id;
    }

    public GCUBEScope getScope() {
        return this.scope;
    }

    public synchronized void save() throws IOException {
        FileWriter file = new FileWriter(Session.getReportFile(this.id));
        file.write(this.toXML());
        file.close();
    }

    public static Session load(String id) throws IOException {
        Session report = new Session();
        return report;
    }

    public static String loadAsString(String id) throws IOException {
        String s;
        File f = Session.getReportFile(id);
        if (!f.exists()) {
            throw new IOException("Unable to find a serialized report with ID=" + id);
        }
        BufferedReader br = new BufferedReader(new FileReader(f));
        StringBuilder report = new StringBuilder();
        while ((s = br.readLine()) != null) {
            report.append(s);
        }
        br.close();
        return report.toString();
    }

    private static File getReportFile(String id) throws IOException {
        return new File(ServiceContext.getContext().getConfigurationFileAbsolutePath(reportDir) + File.separator + id + ".xml");
    }

    private void addGHNReport(KXmlSerializer serializer, DeployerReport report, ScopedDeployedSoftware service) throws Exception {
        serializer.startTag(NS, "Packages");
        for (DeployedDependency dep : report.getDependencies()) {
            if (!this.isDepOfService(dep, service)) continue;
            serializer.startTag(NS, "Package");
            serializer.startTag(NS, "ServiceClass").text(dep.getService().getClazz()).endTag(NS, "ServiceClass");
            serializer.startTag(NS, "ServiceName").text(dep.getService().getName()).endTag(NS, "ServiceName");
            serializer.startTag(NS, "ServiceVersion").text(dep.getService().getVersion()).endTag(NS, "ServiceVersion");
            serializer.startTag(NS, "PackageName").text(dep.getName()).endTag(NS, "PackageName");
            serializer.startTag(NS, "PackageVersion").text(dep.getVersion()).endTag(NS, "PackageVersion");
            serializer.startTag(NS, "Status").text(dep.getStatus()).endTag(NS, "Status");
            serializer.startTag(NS, "Message").text(dep.getMessage()).endTag(NS, "Message");
            serializer.endTag(NS, "Package");
        }
        serializer.endTag(NS, "Packages");
    }

    public synchronized void reportBrokerWork(boolean wasSuccessful, String brokerMessage) {
        this.brokerReportAvailable = true;
        this.brokerWasSuccessful = wasSuccessful;
        this.brokerMessage = brokerMessage;
    }

    public void addDeployedInstances(Set<DeployerReport.DeployedRunningInstance> instances) {
        if (instances == null || instances.size() == 0) {
            return;
        }
        this.instances.addAll(instances);
    }

    private boolean isDepOfService(DeployedDependency dep, ScopedDeployedSoftware service) {
        for (Dependency resolvedDependency : service.getLastResolvedDependencies()) {
            if (!dep.equals(resolvedDependency)) continue;
            return true;
        }
        return false;
    }

    public boolean isSessionClosed() {
        for (ScopedResource resource : this.resources) {
            if (resource.getStatus() != ScopedResource.STATUS.ADDREQUESTED && resource.getStatus() != ScopedResource.STATUS.REMOVEREQUESTED) continue;
            return false;
        }
        for (ScopedDeployedSoftware service : this.services) {
            String reportHostName = service.getTargetNodeName();
            if (!service.isSuccess() || !this.brokerWasSuccessful) continue;
            if (!this.node2report.keySet().contains(reportHostName)) {
                return false;
            }
            if (this.node2report.get(reportHostName).getStatus().compareToIgnoreCase("CLOSED") == 0) continue;
            return false;
        }
        return true;
    }

    public Set<ScopedDeployedSoftware> getServices() {
        return this.services;
    }

    public Map<String, DeployerReport> getAllGHNReports() {
        return this.node2report;
    }

    public OPERATION getOperation() {
        return this.operation;
    }

    public void setDeploymentPlan(String plan) {
        this.deploymentPlan = plan;
    }

    public String getDeploymentPlan() throws IOException {
        if (this.deploymentPlan == null) {
            throw new IOException("No Deployment Plan is available");
        }
        return this.deploymentPlan;
    }

    public void startChecker() {
        this.logger.debug((Object)"Starting the Session Checker");
        try {
            this.timer.schedule((TimerTask)new SessionChecker(), 600000L);
        }
        catch (Exception e) {
            this.logger.warn((Object)"Session Checker was not started (timer already cancelled)");
        }
    }

    class SessionChecker
    extends TimerTask {
        SessionChecker() {
        }

        @Override
        public void run() {
            Session.this.logger.debug((Object)"Session Checker woke up");
            if (Session.this.isSessionClosed() || Session.this.forcedToBeClosed) {
                try {
                    this.cancel();
                    return;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            for (ScopedResource resource : Session.this.resources) {
                if (resource.getStatus() != ScopedResource.STATUS.ADDREQUESTED && resource.getStatus() != ScopedResource.STATUS.REMOVEREQUESTED) continue;
                resource.setStatus(ScopedResource.STATUS.LOST);
                resource.setErrorMessage("The resource was not managed properly in a reasonable time (10 mins)");
            }
            for (ScopedDeployedSoftware service : Session.this.services) {
                String reportHostName = service.getTargetNodeName();
                if (!service.isSuccess() || !Session.this.brokerWasSuccessful) continue;
                if (!Session.this.node2report.keySet().contains(reportHostName)) {
                    Session.this.forcedToBeClosed = true;
                    Session.this.sessionErrorMessage = "Node " + reportHostName + " did not send any report on time";
                    Session.this.logger.debug((Object)("Session Checker forced the session to close:" + Session.this.sessionErrorMessage));
                    continue;
                }
                if (((DeployerReport)Session.this.node2report.get(reportHostName)).getStatus().compareToIgnoreCase("CLOSED") == 0) continue;
                Session.this.forcedToBeClosed = true;
                Session.this.sessionErrorMessage = "Report from node " + reportHostName + " was not closed on time";
                Session.this.logger.debug((Object)("Session Checker forced the session to close:" + Session.this.sessionErrorMessage));
            }
            try {
                Session.this.save();
                Session.this.logger.debug((Object)"Cancelling the Session Checker");
                this.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static enum OPERATION {
        Create,
        AddResources,
        UpdateResources,
        RemoveResources,
        Dispose;

    }

    public static enum DEPSTATUS {
        SUCCESS,
        FAILED;

    }
}

