/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.utils.serialization.types;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.List;
import java.util.Vector;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PackageGroup;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PlanBuilderIdentifier;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.ResponseStatus;

public class PlanResponse {
    public static final String NODE_TAG = "PlanResponse";
    @XStreamAlias(value="deployID")
    @XStreamAsAttribute
    private String key = null;
    @XStreamAlias(value="Scope")
    private String scope = null;
    private List<PackageGroup> packageGroups = new Vector<PackageGroup>();
    @XStreamAlias(value="Status")
    private ResponseStatus status = null;

    public PlanResponse() {
        this.key = new BigInteger(130, new SecureRandom()).toString(32);
    }

    public PlanResponse(PlanBuilderIdentifier workflowSession) {
        this.key = workflowSession.getID();
    }

    public PlanResponse(PlanBuilderIdentifier workflowSession, String scope) {
        this(workflowSession);
        this.scope = scope;
    }

    public final String getScope() {
        return this.scope;
    }

    public final void setScope(String scope) {
        this.scope = scope;
    }

    public final List<PackageGroup> getPackageGroups() {
        return this.packageGroups;
    }

    public final String getKey() {
        return this.key;
    }

    public final void setKey(String key) {
        this.key = key;
    }

    public final PackageGroup createPackageGroup(String serviceName) {
        PackageGroup retval = new PackageGroup();
        this.packageGroups.add(retval);
        retval.setID(String.valueOf(this.packageGroups.size()));
        retval.setServiceName(serviceName);
        return retval;
    }

    public void setStatus(ResponseStatus status) {
        this.status = status;
    }

    public ResponseStatus getStatus() {
        return this.status;
    }

    public boolean hasFailed() {
        return this.status.getStatus() == "SUCCESS" && this.getStatus().getMsg() == null;
    }
}

