/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.impl.support.notifications;

import java.util.Vector;
import javax.xml.namespace.QName;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.GCUBESecurityManagerImpl;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcebroker.impl.configuration.BrokerConfiguration;
import org.gcube.vremanagement.resourcebroker.impl.services.GHNReservationHandler;
import org.gcube.vremanagement.resourcebroker.impl.services.ISClientRequester;
import org.gcube.vremanagement.resourcebroker.impl.support.types.GHNDescriptor;
import org.gcube.vremanagement.resourcebroker.impl.support.types.Tuple;

public class RICreationSubscriber
extends ISNotifier.BaseNotificationConsumer {
    private GCUBELog logger = new GCUBELog((Object)this, BrokerConfiguration.getProperty("LOGGING_PREFIX"));
    private GCUBEScope scope = null;
    private long sleepDelay = 0L;

    public RICreationSubscriber(GCUBEScope scope, long sleepDelay) {
        this.logger.debug((Object)("[TTHREADS] Starting " + ((Object)((Object)this)).getClass().getSimpleName() + " delay: " + sleepDelay));
        this.scope = scope;
        this.sleepDelay = sleepDelay;
        this.init();
    }

    private void init() {
        try {
            ISNotifier notifier = (ISNotifier)GHNContext.getImplementation(ISNotifier.class);
            Vector<ISNotifier.GCUBENotificationTopic> qnames = new Vector<ISNotifier.GCUBENotificationTopic>();
            qnames.add(new ISNotifier.GCUBENotificationTopic(new QName(BrokerConfiguration.getProperty("NS_REGISTRY"), "RunningInstance")));
            GCUBESecurityManagerImpl secMan = new GCUBESecurityManagerImpl(){

                public boolean isSecurityEnabled() {
                    return false;
                }
            };
            notifier.registerToISNotification((ISNotifier.BaseNotificationConsumer)this, qnames, (GCUBESecurityManager)secMan, new GCUBEScope[]{this.scope});
        }
        catch (Exception e) {
            this.logger.error((Object)"*** [ERROR] During NotificationHandler instantiation", (Throwable)e);
            e.printStackTrace();
        }
    }

    protected final void onNotificationReceived(ISNotifier.NotificationEvent event) {
        super.onNotificationReceived(event);
        String riID = ((ISNotifier.NotificationMessage)event.getPayload()).getMessage()[0].getChildNodes().item(0).getChildNodes().item(0).getNodeValue();
        String operation = ((ISNotifier.NotificationMessage)event.getPayload()).getMessage()[0].getChildNodes().item(1).getChildNodes().item(0).getNodeValue();
        for (int i = 0; i < ((ISNotifier.NotificationMessage)event.getPayload()).getMessage()[0].getChildNodes().getLength(); ++i) {
            this.logger.debug((Object)("*** [NOTIFICATION #" + i + "]" + ((ISNotifier.NotificationMessage)event.getPayload()).getMessage()[0].getChildNodes().item(i)));
        }
        this.logger.debug((Object)("*** Operation [" + operation + "]"));
        try {
            if (operation.compareTo("create") == 0) {
                Tuple<String> retval = ISClientRequester.getRIAndGHN(this.scope, riID);
                String ghnToUpdate = null;
                if (retval != null && retval.size() == 2) {
                    ghnToUpdate = retval.get(1);
                }
                this.logger.debug((Object)("*** The RI: " + riID + " is running on: " + ghnToUpdate));
                if (ghnToUpdate != null) {
                    this.logger.debug((Object)"*** Increasing the GHN running instance number");
                    GHNDescriptor ghnDescr = GHNReservationHandler.getInstance().getGHNByID(null, this.scope, ghnToUpdate);
                    if (ghnDescr != null) {
                        ghnDescr.increaseRICount();
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            return;
        }
        if (this.sleepDelay > 0L) {
            try {
                Thread.sleep(this.sleepDelay);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    public final GCUBEScope getScope() {
        return this.scope;
    }
}

