/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.local.testsuite;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Vector;
import org.apache.xerces.parsers.DOMParser;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.requirements.Requirement;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.requirements.RequirementElemPath;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.requirements.RequirementRelationType;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ReqConverter {
    private static List<Requirement> doJob() {
        String rawRequirements = "<GHNRequirements>\n<Requirement category=\"MEM_RAM_AVAILABLE\" operator=\"le\" requirement=\"\" value=\"1000\"/>\n<Requirement category=\"INVALIDFIELD\" operator=\"le\" requirement=\"\" value=\"1000\"/>\n<Requirement category=\"INVALIDFIELD\" operator=\"\" requirement=\"\" value=\"1000\"/>\n<Requirement category=\"INVALIDFIELD\" requirement=\"\" value=\"1000\"/>\n<Requirement category=\"\" requirement=\"\" value=\"1000\"/>\n<Requirement category=\"\" operator=\"le\" requirement=\"\" value=\"1000\"/>\n<Requirement />\n<Requirement category=\"INVALIDFIELD\" requirement=\"\" />\n<Requirement category=\"INVALIDFIELD\" requirement=\"\" value=\"\"/>\n<Requirement category=\"PLATFORM\" operator=\"eq\" requirement=\"\" value=\"i368\"/>\n<Requirement category=\"OS\" operator=\"exist\" requirement=\"\" value=\"Linux\"/>\n</GHNRequirements>\n";
        if (rawRequirements == null || rawRequirements.trim().length() == 0) {
            return null;
        }
        Vector<Requirement> retval = new Vector<Requirement>();
        try {
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(new StringReader(rawRequirements)));
            Document doc = parser.getDocument();
            NodeList ns = doc.getElementsByTagName("Requirement");
            for (int i = 0; i < ns.getLength(); ++i) {
                try {
                    String key;
                    Node node = ns.item(i);
                    NamedNodeMap attrs = node.getAttributes();
                    String operator = attrs.getNamedItem("operator").getNodeValue();
                    RequirementRelationType convertedOperator = null;
                    if (operator != null && operator.trim().length() > 0) {
                        if (operator.trim().compareToIgnoreCase("le") == 0) {
                            convertedOperator = RequirementRelationType.LESS_OR_EQUAL;
                        }
                        if (operator.trim().compareToIgnoreCase("eq") == 0) {
                            convertedOperator = RequirementRelationType.EQUAL;
                        }
                        if (operator.trim().compareToIgnoreCase("exist") == 0) {
                            convertedOperator = RequirementRelationType.CONTAINS;
                        }
                        if (operator.trim().compareToIgnoreCase("gt") == 0) {
                            convertedOperator = RequirementRelationType.GREATER;
                        }
                        if (operator.trim().compareToIgnoreCase("ge") == 0) {
                            convertedOperator = RequirementRelationType.GREATER_OR_EQUAL;
                        }
                        if (operator.trim().compareToIgnoreCase("ne") == 0) {
                            convertedOperator = RequirementRelationType.NOT_EQUAL;
                        }
                        if (operator.trim().compareToIgnoreCase("lt") == 0) {
                            convertedOperator = RequirementRelationType.LESS;
                        }
                    }
                    if ((key = attrs.getNamedItem("requirement").getNodeValue()) != null && key.trim().length() > 0) {
                        try {
                            retval.add(new Requirement(RequirementElemPath.valueOf((String)attrs.getNamedItem("category").getNodeValue()), attrs.getNamedItem("requirement").getNodeValue(), convertedOperator, attrs.getNamedItem("value").getNodeValue()));
                        }
                        catch (IllegalArgumentException e) {}
                        continue;
                    }
                    try {
                        retval.add(new Requirement(RequirementElemPath.valueOf((String)attrs.getNamedItem("category").getNodeValue()), convertedOperator, attrs.getNamedItem("value").getNodeValue()));
                    }
                    catch (IllegalArgumentException e) {}
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
            return retval;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        List<Requirement> vls = ReqConverter.doJob();
        System.out.println("Valid requirements: " + vls.size());
    }
}

