/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.impl.support.types;

import java.util.List;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.informationsystem.client.XMLResult;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcebroker.impl.configuration.BrokerConfiguration;
import org.gcube.vremanagement.resourcebroker.impl.resources.GHNProfileBindings;
import org.gcube.vremanagement.resourcebroker.impl.resources.ResourceStorageManager;
import org.gcube.vremanagement.resourcebroker.impl.support.types.GHNScoreTable;
import org.gcube.vremanagement.resourcebroker.impl.support.types.SortableElement;
import org.gcube.vremanagement.resourcebroker.utils.assertions.Assertion;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PlanBuilderIdentifier;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.requirements.Requirement;

public class GHNDescriptor
extends SortableElement<Float, String> {
    private GCUBELog logger = new GCUBELog((Object)this, BrokerConfiguration.getProperty("LOGGING_PREFIX"));
    private int reservations = 0;
    private GCUBEScope scope = null;
    private XMLResult profile = null;
    private float score = 1.0f;
    private int hits = 1;
    private int numberOfRI = 0;
    private PlanBuilderIdentifier owner = null;

    public GHNDescriptor(int allocatedResources, String elem, GCUBEScope scope, XMLResult profile) {
        super(Float.valueOf(allocatedResources), elem.trim());
        this.scope = scope;
        this.numberOfRI = allocatedResources;
        this.setProfile(profile);
        try {
            ResourceStorageManager.INSTANCE.loadScores();
            GHNScoreTable table = (GHNScoreTable)ResourceStorageManager.INSTANCE.getResource().getElem(BrokerConfiguration.getProperty("GHN_SCORE_KEY"));
            if (table != null) {
                int newhits;
                float newscore = table.getScoreFor(elem);
                if (newscore > 0.0f) {
                    this.score = newscore;
                }
                if ((newhits = table.getHitsFor(elem)) > 0) {
                    this.hits = newhits;
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    public final synchronized void reserve(PlanBuilderIdentifier wfID) {
        this.logger.debug((Object)("[GHN-DESCR] reserving GHN " + this.getID() + " for plan " + wfID));
        if (!this.isReservableBy(wfID)) {
            return;
        }
        ++this.reservations;
        this.owner = wfID;
    }

    public final synchronized boolean isReservableBy(PlanBuilderIdentifier wfID) {
        if (wfID == null) {
            return false;
        }
        if (this.owner == null) {
            return true;
        }
        return this.owner.equals((Object)wfID);
    }

    public final PlanBuilderIdentifier getOwner() {
        return this.owner;
    }

    public final boolean isReserved() {
        return this.owner != null;
    }

    public final synchronized void revokeReservation(PlanBuilderIdentifier wfID) {
        this.logger.debug((Object)("[GHN-DESCR] releasing reservation of GHN " + this.getID() + " for plan " + wfID));
        if (this.owner != null && wfID != null && this.owner.equals((Object)wfID)) {
            --this.reservations;
            if (this.reservations <= 0) {
                this.owner = null;
            }
        }
    }

    public final synchronized void revokeAllReservations(PlanBuilderIdentifier wfID) {
        this.logger.debug((Object)("[GHN-DESCR] revoking all reservations of GHN " + this.getID() + " for plan " + wfID));
        if (this.owner != null && wfID != null && this.owner.equals((Object)wfID)) {
            this.reservations = 0;
            this.owner = null;
        }
    }

    public final String getID() {
        return (String)this.elem;
    }

    public final synchronized void setRICount(int allocatedResources) {
        this.numberOfRI = allocatedResources;
    }

    public final synchronized int getRICount() {
        return this.numberOfRI;
    }

    public final synchronized void increaseRICount() {
        ++this.numberOfRI;
    }

    public final GCUBEScope getScope() {
        return this.scope;
    }

    @Override
    public final Float getSortIndex() {
        return this.getScore();
    }

    public final synchronized Float getScore() {
        return Float.valueOf((float)this.numberOfRI * Float.parseFloat(BrokerConfiguration.getProperty("GHN_RI_COUNT_WEIGHT")) + (float)this.reservations * Float.parseFloat(BrokerConfiguration.getProperty("GHN_RESERVATION_WEIGHT")) + (this.getLoadLast1M() + this.getLoadLast5M() + this.getLoadLast15M()) / 3.0f * Float.parseFloat(BrokerConfiguration.getProperty("GHN_LOAD_WEIGHT")) + (1.0f - this.getAccuracy()) * (float)BrokerConfiguration.getIntProperty("GHN_ACCURACY_WEIGHT"));
    }

    public final boolean equals(Object obj) {
        if (obj instanceof GHNDescriptor) {
            GHNDescriptor trg = (GHNDescriptor)obj;
            return ((String)this.getElement()).equals(trg.getElement()) && this.getScope().equals((Object)((GHNDescriptor)obj).getScope());
        }
        return super.equals(obj);
    }

    public final int hashCode() {
        return this.getScope().toString().hashCode() + ((String)this.getElement()).hashCode();
    }

    public final void registerScore(int score) {
        float newscore = (float)score / 100.0f;
        this.score = (this.score * (float)this.hits + newscore) / ((float)this.hits + 1.0f);
        ++this.hits;
    }

    public final float getAccuracy() {
        return this.score;
    }

    public final int getHits() {
        return this.hits;
    }

    public final void setProfile(XMLResult profile) {
        this.profile = profile;
    }

    public final boolean hasProfile() {
        return this.profile != null;
    }

    public final boolean satisfies(Requirement[] requirements) throws GCUBEFault {
        Assertion<GCUBEFault> checker = new Assertion<GCUBEFault>();
        checker.validate(this.profile != null, new GCUBEFault(new String[]{"No profile description attached to this GHN descriptor"}));
        if (requirements == null || requirements.length == 0) {
            return true;
        }
        for (Requirement req : requirements) {
            try {
                List results = this.profile.evaluate(req.getEvalString());
                if (results != null && results.size() != 0) continue;
                return false;
            }
            catch (XMLResult.ISResultEvaluationException e) {
                return false;
            }
        }
        return true;
    }

    protected final Object getXMLProfileElem(String relativePath) {
        if (this.profile == null) {
            return null;
        }
        try {
            List results = this.profile.evaluate(relativePath);
            if (results != null && results.size() > 0) {
                return results.get(0);
            }
        }
        catch (XMLResult.ISResultEvaluationException e) {
            this.logger.error((Object)e);
            return null;
        }
        return null;
    }

    private float loadFloatXPath(String path, float defaultVal) {
        Object retrievedVal = this.getXMLProfileElem(path);
        if (retrievedVal == null) {
            return defaultVal;
        }
        try {
            return Float.parseFloat(retrievedVal.toString());
        }
        catch (NumberFormatException e) {
            return defaultVal;
        }
    }

    public final float getLoadLast1M() {
        return this.loadFloatXPath(GHNProfileBindings.LOAD1MIN.getValue(), 1.0f);
    }

    public final float getLoadLast5M() {
        return this.loadFloatXPath(GHNProfileBindings.LOAD5MIN.getValue(), 1.0f);
    }

    public final float getLoadLast15M() {
        return this.loadFloatXPath(GHNProfileBindings.LOAD15MIN.getValue(), 1.0f);
    }
}

