/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.impl.planbuilders.generictasks;

import java.util.List;
import java.util.Vector;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.PlanBuilderElem;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.PlanBuilderException;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.PlanBuilderTask;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.PlanExceptionMessages;
import org.gcube.vremanagement.resourcebroker.impl.services.GHNReservationHandler;
import org.gcube.vremanagement.resourcebroker.impl.support.types.GHNDescriptor;
import org.gcube.vremanagement.resourcebroker.utils.assertions.Assertion;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PackageElem;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PackageGroup;

public class AssignGHNTask
extends PlanBuilderTask {
    @Override
    public final PlanBuilderElem makeDecision(PlanBuilderElem input) throws PlanBuilderException {
        Assertion<PlanBuilderException> checker = new Assertion<PlanBuilderException>();
        checker.validate(input != null, new PlanBuilderException(PlanExceptionMessages.INVALID_REQUEST));
        checker.validate(input.getRequest() != null, new PlanBuilderException(PlanExceptionMessages.INVALID_REQUEST));
        checker.validate(input.getRequest().getScope() != null, new PlanBuilderException(PlanExceptionMessages.INVALID_REQUEST_SCOPE));
        if (input.getRequest().getPackageGroups() == null || input.getRequest().getPackageGroups().size() == 0) {
            this.logger.debug((Object)"[PLAN] No other PackageGroups to allocated. exiting...");
            return input;
        }
        if (input.getRequest().getGHNList() != null && input.getRequest().getGHNList().getGHNs() != null && input.getRequest().getGHNList().getGHNs().size() > 0) {
            this.logger.debug((Object)"[PLAN] There are suggested GHNs so this step must be skipped...");
            return input;
        }
        GCUBEScope scope = GCUBEScope.getScope((String)input.getRequest().getScope());
        List remainingNodes = input.getRequest().getPackageGroups();
        GHNReservationHandler reserver = GHNReservationHandler.getInstance();
        GHNDescriptor ghnToUse = null;
        PackageGroup pkgGroupToUse = null;
        this.logger.debug((Object)("[PLAN] Nodes to be assigned #" + remainingNodes.size()));
        int loopNum = remainingNodes.size();
        Vector<PackageGroup> pkgToRemove = new Vector<PackageGroup>();
        for (int i = 0; i < loopNum && (pkgGroupToUse = (PackageGroup)remainingNodes.get(i)) != null; ++i) {
            try {
                if (scope.getType() == GCUBEScope.Type.VRE) {
                    this.logger.info((Object)("[PLAN-ASSING-NEXT] Using enclosing scope (emanuele reduce) " + scope.getEnclosingScope().toString()));
                    ghnToUse = reserver.getNextGHN(scope.getEnclosingScope(), this.identifier, true);
                } else {
                    this.logger.info((Object)("[PLAN-ASSING-NEXT] Using required scope " + scope.toString()));
                    ghnToUse = reserver.getNextGHN(scope, this.identifier, true);
                }
                if (ghnToUse == null) {
                    throw new PlanBuilderException(PlanExceptionMessages.NO_GHNS_AVAILABLE, pkgGroupToUse);
                }
            }
            catch (GCUBEFault e) {
                throw new PlanBuilderException(PlanExceptionMessages.NO_GHNS_AVAILABLE, pkgGroupToUse);
            }
            this.logger.debug((Object)("[PLAN] Assigning to: " + ghnToUse));
            PackageGroup pckGrpToInsert = input.getResponse().createPackageGroup(pkgGroupToUse.getServiceName());
            pckGrpToInsert.setGHN(ghnToUse.getID());
            this.logger.debug((Object)("[PLAN] reassigning package " + pkgGroupToUse.getID()));
            pckGrpToInsert.setID(pkgGroupToUse.getID());
            if (pkgGroupToUse.getPackages() == null) {
                this.logger.error((Object)("[PLAN-ERR] the packageGroup has no children Package " + pkgGroupToUse.getID()));
            }
            for (PackageElem p : pkgGroupToUse.getPackages()) {
                pckGrpToInsert.addPackage(new PackageElem(p));
            }
            pkgToRemove.add(pkgGroupToUse);
        }
        if (pkgToRemove != null && pkgToRemove.size() > 0) {
            for (PackageGroup toRemove : pkgToRemove) {
                remainingNodes.remove(toRemove);
            }
        }
        return input;
    }
}

