/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.impl.services;

import java.util.List;
import java.util.Vector;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.QueryParameter;
import org.gcube.common.core.informationsystem.client.XMLResult;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericQuery;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcebroker.impl.configuration.BrokerConfiguration;
import org.gcube.vremanagement.resourcebroker.impl.support.queries.QueryLoader;
import org.gcube.vremanagement.resourcebroker.impl.support.queries.QueryPath;
import org.gcube.vremanagement.resourcebroker.impl.support.types.GHNDescriptor;
import org.gcube.vremanagement.resourcebroker.impl.support.types.Tuple;
import org.gcube.vremanagement.resourcebroker.utils.assertions.Assertion;

public class ISClientRequester {
    private static GCUBELog logger = new GCUBELog(ISClientRequester.class, BrokerConfiguration.getProperty("LOGGING_PREFIX") + "::[IS-REQ]");

    public static final List<GHNDescriptor> getRIOnGHNs(GCUBEScope queryScope) throws Exception {
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBEGenericQuery isQuery = null;
        isQuery = (GCUBEGenericQuery)client.getQuery(GCUBEGenericQuery.class);
        isQuery.setExpression(QueryLoader.getQuery(QueryPath.COUNT_RI_ON_DYNAMIC_ALIVE_GHN));
        isQuery.addParameters(new QueryParameter[]{new QueryParameter("MAXWAIT", BrokerConfiguration.getProperty("LIVE_GHN_MAX_MINUTES"))});
        List results = client.execute((ISQuery)isQuery, queryScope);
        Vector<GHNDescriptor> newGHNList = new Vector<GHNDescriptor>();
        if (results == null || results.size() == 0) {
            logger.warn((Object)("no GHNDescriptor found for scope: " + queryScope.toString()));
            return null;
        }
        logger.debug((Object)("found *(" + results.size() + ")* GHN in scope: " + queryScope.toString()));
        for (XMLResult elem : results) {
            try {
                List riNums = elem.evaluate("/RIONGHN/AllocatedRI/text()");
                List ghnIDs = elem.evaluate("/RIONGHN/ID/text()");
                if (riNums == null || riNums.size() <= 0 || ghnIDs == null || ghnIDs.size() <= 0) continue;
                newGHNList.add(new GHNDescriptor(Integer.parseInt((String)riNums.get(0)), (String)ghnIDs.get(0), queryScope, elem));
            }
            catch (NumberFormatException e) {}
        }
        return newGHNList;
    }

    public static final Tuple<String> getRIAndGHN(GCUBEScope queryScope, String riID) throws Exception {
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBEGenericQuery isQuery = null;
        isQuery = (GCUBEGenericQuery)client.getQuery(GCUBEGenericQuery.class);
        isQuery.setExpression(QueryLoader.getQuery(QueryPath.GET_GHN_FOR_RI));
        isQuery.addParameters(new QueryParameter[]{new QueryParameter("RI_ID", riID)});
        List results = client.execute((ISQuery)isQuery, queryScope);
        if (results == null || results.size() == 0) {
            logger.warn((Object)("no GHNDescriptor found for scope: " + queryScope.toString()));
            return null;
        }
        logger.debug((Object)("found *(" + results.size() + ")* GHN in scope: " + queryScope.toString()));
        for (XMLResult elem : results) {
            try {
                return new Tuple<String>((String)elem.evaluate("/RunningInstance/RiID/text()").get(0), (String)elem.evaluate("/RunningInstance/GHNID/text()").get(0));
            }
            catch (XMLResult.ISResultEvaluationException e) {
                logger.error((Object)e);
            }
        }
        return null;
    }

    public static final GHNDescriptor getRIOnGHNByID(GCUBEScope queryScope, String ghnID) throws Exception {
        Assertion<GCUBEFault> checker = new Assertion<GCUBEFault>();
        checker.validate(queryScope != null, new GCUBEFault(new String[]{"Invalid scope parameter. null not allowed."}));
        checker.validate(ghnID != null && ghnID.trim().length() > 0, new GCUBEFault(new String[]{"Invalid ghnID parameter received."}));
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBEGenericQuery isQuery = null;
        isQuery = (GCUBEGenericQuery)client.getQuery(GCUBEGenericQuery.class);
        isQuery.setExpression(QueryLoader.getQuery(QueryPath.COUNT_RI_ON_DYNAMIC_ALIVE_GHN_BY_ID));
        isQuery.addParameters(new QueryParameter[]{new QueryParameter("MAXWAIT", BrokerConfiguration.getProperty("LIVE_GHN_MAX_MINUTES")), new QueryParameter("PARAM_GHNID", ghnID)});
        List results = client.execute((ISQuery)isQuery, queryScope);
        if (results == null || results.size() == 0) {
            logger.warn((Object)("no GHNDescriptor found for scope: " + queryScope.toString()));
            return null;
        }
        logger.debug((Object)("found *(" + results.size() + ")* GHN in scope: " + queryScope.toString()));
        for (XMLResult elem : results) {
            try {
                return new GHNDescriptor(Integer.parseInt((String)elem.evaluate("/RIONGHN/AllocatedRI/text()").get(0)), (String)elem.evaluate("/RIONGHN/ID/text()").get(0), queryScope, elem);
            }
            catch (XMLResult.ISResultEvaluationException e) {
                logger.error((Object)e);
            }
        }
        return null;
    }
}

