/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.impl.resources;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcebroker.impl.configuration.BrokerConfiguration;
import org.gcube.vremanagement.resourcebroker.impl.contexts.ServiceContext;
import org.gcube.vremanagement.resourcebroker.impl.contexts.StatefulBrokerContext;
import org.gcube.vremanagement.resourcebroker.impl.resources.SingletonResourceStorage;
import org.gcube.vremanagement.resourcebroker.impl.support.types.GHNDescriptor;
import org.gcube.vremanagement.resourcebroker.impl.support.types.GHNScoreTable;
import org.gcube.vremanagement.resourcebroker.utils.console.PrettyFormatter;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceKey;

public class ResourceStorageManager {
    public static final ResourceStorageManager INSTANCE = new ResourceStorageManager();
    private final GCUBELog logger = new GCUBELog((Object)this, BrokerConfiguration.getProperty("LOGGING_PREFIX") + "::[RES-STORAGE]");

    public final SingletonResourceStorage getResource() throws GCUBEFault {
        try {
            GCUBEWSResource resource = StatefulBrokerContext.getContext().getWSHome().find((ResourceKey)StatefulBrokerContext.getResPlanKey());
            return (SingletonResourceStorage)resource;
        }
        catch (ResourceException e) {
            throw new GCUBEFault((Throwable)e, new String[]{"During getResource"});
        }
    }

    public final void loadScores() throws Exception {
        SingletonResourceStorage resource = this.getResource();
        if (resource != null && !resource.containsKey(BrokerConfiguration.getProperty("GHN_SCORE_KEY"))) {
            File file = ServiceContext.getContext().getPersistentFile("GHN.scores", new boolean[]{true});
            if (!file.exists()) {
                this.logger.warn((Object)"[LOAD] no persistent storage found");
                resource.addElement(BrokerConfiguration.getProperty("GHN_SCORE_KEY"), null);
                return;
            }
            this.logger.debug((Object)PrettyFormatter.bold("[LOAD] Loading scores from : " + file.getPath()));
            ObjectInputStream mine = new ObjectInputStream(new FileInputStream(file));
            Object o = null;
            try {
                o = mine.readObject();
            }
            catch (Exception e) {
                this.logger.warn((Object)("[LOAD-ERR] The file " + file.getAbsolutePath() + " is inconsistent it will be removed"));
                this.logger.warn((Object)("[STORE] file deleted: [" + file.delete() + "]"));
                return;
            }
            if (o == null || !(o instanceof GHNScoreTable) || ((GHNScoreTable)o).size() == 0) {
                this.logger.warn((Object)"[LOAD] no persistent storage found");
                resource.addElement(BrokerConfiguration.getProperty("GHN_SCORE_KEY"), new GHNScoreTable());
                return;
            }
            GHNScoreTable elem = (GHNScoreTable)o;
            resource.addElement(BrokerConfiguration.getProperty("GHN_SCORE_KEY"), elem);
            this.logger.info((Object)PrettyFormatter.bold("[STORE-LOAD] restored (" + elem.size() + ") elements"));
        }
    }

    public final void storeScores() {
        Closeable mine;
        GHNScoreTable tblToStore;
        File file;
        block21: {
            this.logger.debug((Object)"[STORE] Storing GHN score table.");
            file = ServiceContext.getContext().getPersistentFile("GHN.scores", new boolean[]{true});
            this.logger.debug((Object)("Writing scores in : " + file.getPath()));
            tblToStore = new GHNScoreTable();
            try {
                if (!file.exists()) {
                    this.logger.warn((Object)("[STORE] created new file: [" + file.createNewFile() + "]"));
                    break block21;
                }
                try {
                    mine = new ObjectInputStream(new FileInputStream(file));
                    Object o = ((ObjectInputStream)mine).readObject();
                    if (o != null && o instanceof GHNScoreTable && ((GHNScoreTable)o).size() > 0) {
                        tblToStore = (GHNScoreTable)o;
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)e);
                }
                this.logger.warn((Object)("[STORE] file deleted: [" + file.delete() + "]"));
                this.logger.warn((Object)("[STORE] created new file: [" + file.createNewFile() + "]"));
            }
            catch (IOException e) {
                this.logger.error((Object)e);
            }
        }
        mine = null;
        try {
            mine = new ObjectOutputStream(new FileOutputStream(file));
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            return;
        }
        SingletonResourceStorage resource = null;
        try {
            resource = this.getResource();
        }
        catch (GCUBEFault e) {
            this.logger.error((Object)e);
            return;
        }
        if (resource == null || resource.getState() == null) {
            this.logger.error((Object)"[STORE-ERR] Invalid resource of the state of resource is not valid");
            return;
        }
        HashMap<String, Object> map = resource.getState();
        String key = null;
        Object value = null;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (value == null) {
                this.logger.warn((Object)("Found a null entry for key: " + key + " in the storage"));
                continue;
            }
            this.logger.info((Object)("KEY: " + key + " type: " + value.getClass().getSimpleName()));
            if (key.startsWith("GLOBAL_GHN_KEY")) {
                if (value == null || !(value instanceof List)) continue;
                this.logger.info((Object)("STORING global GHN profiles of: " + key));
                List descriptors = (List)value;
                for (GHNDescriptor desc : descriptors) {
                    if (desc.getAccuracy() == 1.0f && desc.getHits() == 1) continue;
                    tblToStore.registerGHNScore(desc.getID(), desc.getAccuracy(), desc.getHits());
                }
                continue;
            }
            this.logger.info((Object)("Skipping key: " + key));
        }
        this.logger.debug((Object)(PrettyFormatter.bold("[STORE] ") + PrettyFormatter.underlined("storing **(" + tblToStore.size() + ")** elements")));
        if (tblToStore.size() > 0) {
            try {
                ((ObjectOutputStream)mine).reset();
                ((ObjectOutputStream)mine).writeObject(tblToStore);
                ((ObjectOutputStream)mine).flush();
                ((ObjectOutputStream)mine).close();
            }
            catch (IOException e) {
                this.logger.error((Object)e);
            }
            this.logger.debug((Object)PrettyFormatter.bold("[STORE] Successfully stored: " + tblToStore.size() + " elements"));
        } else {
            try {
                this.logger.warn((Object)"[STORE] No persistent file will be created.");
                ((ObjectOutputStream)mine).close();
                this.logger.warn((Object)("[STORE] file deleted: [" + file.delete() + "]"));
            }
            catch (IOException e) {
                this.logger.error((Object)e);
            }
        }
    }
}

