/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.impl.services;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcebroker.impl.configuration.BrokerConfiguration;
import org.gcube.vremanagement.resourcebroker.impl.contexts.ServiceContext;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.PlanBuilderElem;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.PlanBuilderException;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.PlanBuilderWorkflow;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.generictasks.AddRequirements;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.generictasks.AssignGHNTask;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.generictasks.HandleRequirementsTask;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.generictasks.InitializeScopeTask;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.generictasks.PreselectedGHNTask;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.generictasks.SuggestedGHNTask;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.generictasks.ValidateResponseTask;
import org.gcube.vremanagement.resourcebroker.impl.resources.ResourceStorageManager;
import org.gcube.vremanagement.resourcebroker.impl.services.GHNReservationHandler;
import org.gcube.vremanagement.resourcebroker.impl.support.types.GHNDescriptor;
import org.gcube.vremanagement.resourcebroker.impl.support.types.GHNReservation;
import org.gcube.vremanagement.resourcebroker.utils.assertions.Assertion;
import org.gcube.vremanagement.resourcebroker.utils.console.PrettyFormatter;
import org.gcube.vremanagement.resourcebroker.utils.performance.PerformanceMonitor;
import org.gcube.vremanagement.resourcebroker.utils.serialization.parser.xstream.XStreamTransformer;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PlanBuilderIdentifier;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PlanRequest;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PlanResponse;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.ResponseStatus;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.feedback.DeployNode;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.feedback.Feedback;

public class BrokerService
extends GCUBEPortType {
    private GCUBELog logger = new GCUBELog((Object)this, BrokerConfiguration.getProperty("LOGGING_PREFIX"));

    protected final GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    public final String getPlan(String planRequest) throws GCUBEFault {
        PerformanceMonitor timer = new PerformanceMonitor();
        timer.start();
        Assertion<GCUBEFault> checker = new Assertion<GCUBEFault>();
        checker.validate(planRequest != null && planRequest.trim().length() > 0, new GCUBEFault(new String[]{"Invalid parameter"}));
        this.logger.debug((Object)"[PLAN-XML] Building the XStreamTransformer");
        XStreamTransformer transformer = new XStreamTransformer();
        PlanRequest req = transformer.getRequestFromXML(planRequest, true);
        this.logger.debug((Object)"[PLAN] Applying decision making chain");
        PlanBuilderException failure = null;
        PlanBuilderElem result = null;
        PlanBuilderWorkflow builderFlow = null;
        try {
            builderFlow = new PlanBuilderWorkflow(new PlanBuilderElem(req, null));
            builderFlow.addPlanBuilderTask(new InitializeScopeTask());
            builderFlow.addPlanBuilderTask(new PreselectedGHNTask());
            builderFlow.addPlanBuilderTask(new AddRequirements());
            builderFlow.addPlanBuilderTask(new HandleRequirementsTask());
            builderFlow.addPlanBuilderTask(new SuggestedGHNTask());
            builderFlow.addPlanBuilderTask(new AssignGHNTask());
            builderFlow.addPlanBuilderTask(new ValidateResponseTask());
            result = builderFlow.run();
            builderFlow.getPartialResult().getResponse().setStatus(new ResponseStatus("SUCCESS"));
        }
        catch (PlanBuilderException e) {
            this.logger.error((Object)(PrettyFormatter.bold("[PLAN] ERROR: ") + PrettyFormatter.underlined(e.getMessage())));
            failure = e;
            this.logger.debug((Object)(PrettyFormatter.bold("[PLAN] Releasing reservations for failed plan ") + PrettyFormatter.underlined(builderFlow.getPartialResult().getID().toString())));
            if (builderFlow != null && builderFlow.getPartialResult() != null) {
                GHNReservationHandler.getInstance().revokeFailedReservation(builderFlow.getPartialResult().getID());
                if (builderFlow.getPartialResult().getResponse() != null) {
                    PlanResponse response = builderFlow.getPartialResult().getResponse();
                    response.setStatus(new ResponseStatus("FAILED", failure.getMessage(), failure.getPosition()));
                }
            }
            String retval = transformer.toXML(builderFlow.getPartialResult().getResponse());
            this.checkResponse(retval);
            timer.stop();
            this.logger.debug((Object)("[PLAN] The access to the service internally takes [" + timer.getLastIntervalSecs() + "s]"));
            return retval;
        }
        String retval = null;
        retval = transformer.toXML(result.getResponse());
        this.checkResponse(retval);
        timer.stop();
        this.logger.debug((Object)("[PLAN] The access to the service internally takes [" + timer.getLastIntervalSecs() + "s]"));
        return retval;
    }

    public final VOID handleFeedback(String feedback) throws GCUBEFault {
        Assertion<GCUBEFault> checker = new Assertion<GCUBEFault>();
        checker.validate(feedback != null && feedback.trim().length() > 0, new GCUBEFault(new String[]{"Invalid feedback parameter received."}));
        XStreamTransformer transformer = new XStreamTransformer();
        Feedback fb = transformer.getFeedbackFromXML(feedback, true);
        checker.validate(fb != null && fb.getPlanID() != null, new GCUBEFault(new String[]{"Invalid feedback value"}));
        this.logger.debug((Object)("[FB-ENTER] received a feedback for plan: " + fb.getPlanID()));
        GHNReservationHandler reserver = GHNReservationHandler.getInstance();
        PlanBuilderIdentifier wfID = new PlanBuilderIdentifier(fb.getPlanID());
        int globalScoreTreshold = BrokerConfiguration.getIntProperty("FEEDBACK_GLOBAL_TRESHOLD");
        int globalScore = fb.getScore();
        this.logger.debug((Object)("[FB] received a feedback for plan: " + fb.getPlanID() + " having global score: " + globalScore + "/" + globalScoreTreshold));
        this.logger.debug((Object)("[FB-FAILURE] removing all reservations for plan: " + fb.getPlanID()));
        GHNReservation reservation = null;
        if (reserver.containsReservationFor(wfID)) {
            reservation = reserver.getReservationFor(wfID);
        }
        if (reservation == null) {
            this.logger.error((Object)("[FB] cannot find reservation for given plan id " + wfID));
            return null;
        }
        this.logger.debug((Object)("[FB-LOCK] acquiring lock on reservation: " + wfID));
        try {
            reservation.lock();
        }
        catch (InterruptedException e) {
            this.logger.error((Object)("[FB-LOCK] error while acquiring lock on reservation: " + wfID));
            return null;
        }
        reserver.revokeFailedReservation(wfID);
        for (DeployNode dn : fb.getDeployNodes()) {
            int score = dn.getScore();
            String ghn = dn.getPackageGroup().getGHN();
            GHNDescriptor ghnToUpdate = GHNReservationHandler.getInstance().getGHNByID(wfID, GCUBEScope.getScope((String)fb.getScope()), ghn);
            if (ghnToUpdate != null) {
                this.logger.debug((Object)("[FB-SCORE] assigning score: " + score + "% to GHN: " + ghn + " having actual accurancy " + ghnToUpdate.getAccuracy() + " [DONE]"));
                ghnToUpdate.registerScore(score);
                this.logger.debug((Object)("[FB-SCORE] GHN: " + ghn + " has reached accurancy: " + ghnToUpdate.getAccuracy()));
            } else {
                this.logger.error((Object)("[FB-SCORE] assigning score: " + score + " to GHN: " + ghn + " [ERR]"));
            }
            this.logger.debug((Object)("[FB-UNLOCK] releasing lock on reservation: " + wfID));
            reservation.unlock();
        }
        this.logger.debug((Object)"[FB-EXIT] feedback stored");
        if (ResourceStorageManager.INSTANCE != null) {
            ResourceStorageManager.INSTANCE.storeScores();
        }
        return null;
    }

    private void checkResponse(String responseXML) {
        XStreamTransformer transformer = new XStreamTransformer();
        String xmlValidationStatus = null;
        try {
            transformer.getResponseFromXML(responseXML, true);
            xmlValidationStatus = "SUCCESS";
        }
        catch (GCUBEFault e) {
            xmlValidationStatus = "FAILED";
        }
        this.logger.debug((Object)("[PLAN-XML] Validating response XML... [" + xmlValidationStatus + "]"));
    }
}

