/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.impl.support.types;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.vremanagement.resourcebroker.impl.configuration.BrokerConfiguration;
import org.gcube.vremanagement.resourcebroker.impl.support.types.GHNDescriptor;
import org.gcube.vremanagement.resourcebroker.impl.support.types.SortableElement;
import org.gcube.vremanagement.resourcebroker.utils.assertions.Assertion;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PlanBuilderIdentifier;

public class GHNReservation
extends SortableElement<Long, PlanBuilderIdentifier> {
    private long TTL = 0L;
    private Map<GCUBEScope, List<GHNDescriptor>> reservedGHNs = new HashMap<GCUBEScope, List<GHNDescriptor>>();
    private Semaphore sem = new Semaphore(1);

    public GHNReservation(PlanBuilderIdentifier wfID, long ttl) {
        super(System.currentTimeMillis(), wfID);
        this.TTL = ttl;
    }

    public final boolean isExpired() {
        return System.currentTimeMillis() - (Long)this.getSortIndex() > this.TTL;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof GHNReservation) {
            return ((PlanBuilderIdentifier)this.getElement()).equals(((GHNReservation)obj).getElement());
        }
        return super.equals(obj);
    }

    public final int hashCode() {
        return ((PlanBuilderIdentifier)this.getElement()).hashCode();
    }

    public final synchronized void addGHN(GHNDescriptor ghn) throws GCUBEFault {
        List<GHNDescriptor> ghns;
        Assertion<GCUBEFault> checker = new Assertion<GCUBEFault>();
        checker.validate(ghn != null, new GCUBEFault(new String[]{this.getClass().getSimpleName() + ": Reservation required for a null ghn."}));
        checker.validate(ghn.getScope() != null, new GCUBEFault(new String[]{this.getClass().getSimpleName() + ": the scope of reserved ghn is null."}));
        checker.validate(ghn.getID() != null, new GCUBEFault(new String[]{this.getClass().getSimpleName() + ": invalid ID for reserved ghn."}));
        if (!this.reservedGHNs.containsKey(ghn.getScope())) {
            this.reservedGHNs.put(ghn.getScope(), new Vector());
        }
        if (!(ghns = this.reservedGHNs.get(ghn.getScope())).contains(ghn)) {
            ghns.add(ghn);
        }
    }

    public final synchronized void revoke() {
        if (this.reservedGHNs == null || this.reservedGHNs.values() == null) {
            return;
        }
        Iterator<List<GHNDescriptor>> allGHNs = this.reservedGHNs.values().iterator();
        List<GHNDescriptor> ghns = null;
        while (allGHNs.hasNext()) {
            ghns = allGHNs.next();
            for (GHNDescriptor ghn : ghns) {
                ghn.revokeAllReservations((PlanBuilderIdentifier)this.elem);
            }
        }
    }

    public final synchronized List<GHNDescriptor> getGHNsForScope(GCUBEScope scope) throws GCUBEFault {
        Assertion<GCUBEFault> checker = new Assertion<GCUBEFault>();
        checker.validate(scope != null, new GCUBEFault(new String[]{"Invalid parameter scope. Null not allowed"}));
        return this.reservedGHNs.get(scope);
    }

    public final void lock() throws InterruptedException {
        this.sem.acquire();
        this.TTL += (long)BrokerConfiguration.getIntProperty("GHN_RESERVATION_TTL_MINUTES") * 60000L;
    }

    public final void unlock() {
        this.sem.release();
    }
}

