/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.utils.performance;

public class PerformanceMonitor {
    private long startMills = 0L;
    private long stopMills = 0L;
    private long intermediateMills = 0L;
    private long lastInterval = 0L;
    private StackTraceElement owner = this.getCaller(1);

    private StackTraceElement getCaller(int depth) {
        StackTraceElement[] ste = new Throwable().getStackTrace();
        StackTraceElement position = ste[ste.length - 1 - depth];
        return position;
    }

    public final void start() {
        this.startMills = System.currentTimeMillis();
    }

    public final void stop() {
        this.stopMills = System.currentTimeMillis();
        this.lastInterval = this.stopMills - this.startMills;
    }

    public final void pause() {
        long tmp = System.currentTimeMillis();
        if (this.intermediateMills == 0L) {
            this.intermediateMills = tmp;
            this.lastInterval = tmp - this.startMills;
        } else {
            long retval = tmp - this.intermediateMills;
            this.intermediateMills = tmp;
            this.lastInterval = retval;
        }
    }

    public final float getLastIntervalSecs() {
        if (this.lastInterval == 0L) {
            return 0.0f;
        }
        return (float)this.lastInterval / 1000.0f;
    }

    public final StackTraceElement getOwner() {
        return this.owner;
    }
}

