/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.impl.support.types;

import java.io.Serializable;
import java.util.HashMap;

public class GHNScoreTable
implements Serializable {
    private static final long serialVersionUID = 6082885557663057230L;
    private static final int IDX_SCORE = 0;
    private static final int IDX_HITS = 1;
    private static final float DEFAULT_SCORE = -1.0f;
    private static final float DEFAULT_HITS = -1.0f;
    private HashMap<String, float[]> table = new HashMap();

    public final void registerGHNScore(String ghnID, float score, int hits) {
        this.table.put(ghnID, new float[]{score, hits});
    }

    public final float getScoreFor(String ghnID) {
        if (!this.table.containsKey(ghnID)) {
            return -1.0f;
        }
        return this.table.get(ghnID)[0];
    }

    public final int getHitsFor(String ghnID) {
        if (!this.table.containsKey(ghnID)) {
            return Math.round(-1.0f);
        }
        return Math.round(this.table.get(ghnID)[1]);
    }

    public final int size() {
        return this.table.size();
    }

    public final String toString() {
        StringBuilder retval = new StringBuilder();
        for (String key : this.table.keySet()) {
            float[] vals = this.table.get(key);
            retval.append(key + "(" + vals[0] + "," + vals[1] + ")" + System.getProperty("line.separator"));
        }
        return retval.toString();
    }
}

