/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.client;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.vremanagement.resourcemanager.client.exceptions.InvalidScopeException;
import org.gcube.vremanagement.resourcemanager.client.exceptions.ResourcesCreationException;
import org.gcube.vremanagement.resourcemanager.client.exceptions.ResourcesRemovalException;
import org.gcube.vremanagement.resourcemanager.client.fws.RMBinderServiceJAXWSStubs;
import org.gcube.vremanagement.resourcemanager.client.fws.Types;
import org.gcube.vremanagement.resourcemanager.client.interfaces.RMBinderInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMBinderLibrary
implements RMBinderInterface {
    private final ProxyDelegate<RMBinderServiceJAXWSStubs> delegate;
    Logger logger = LoggerFactory.getLogger((String)this.getClass().toString());

    public RMBinderLibrary(ProxyDelegate<RMBinderServiceJAXWSStubs> delegate) {
        this.delegate = delegate;
    }

    @Override
    public String addResources(final Types.AddResourcesParameters params) throws ResourcesCreationException, InvalidScopeException {
        Call<RMBinderServiceJAXWSStubs, String> call = new Call<RMBinderServiceJAXWSStubs, String>(){

            public String call(RMBinderServiceJAXWSStubs endpoint) throws Exception {
                return endpoint.AddResources(params);
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).as(ResourcesCreationException.class, InvalidScopeException.class);
        }
    }

    @Override
    public String removeResources(final Types.RemoveResourcesParameters params) throws ResourcesRemovalException, InvalidScopeException {
        Call<RMBinderServiceJAXWSStubs, String> call = new Call<RMBinderServiceJAXWSStubs, String>(){

            public String call(RMBinderServiceJAXWSStubs endpoint) throws Exception {
                return endpoint.RemoveResources(params);
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).as(ResourcesRemovalException.class, InvalidScopeException.class);
        }
    }
}

