/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.client;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.common.clients.stubs.jaxws.JAXWSUtils;
import org.gcube.vremanagement.resourcemanager.client.exceptions.InvalidScopeException;
import org.gcube.vremanagement.resourcemanager.client.exceptions.NoSuchReportException;
import org.gcube.vremanagement.resourcemanager.client.fws.RMReportingServiceJAXWSStubs;
import org.gcube.vremanagement.resourcemanager.client.fws.Types;
import org.gcube.vremanagement.resourcemanager.client.interfaces.RMReportingInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMReportingLibrary
implements RMReportingInterface {
    private final ProxyDelegate<RMReportingServiceJAXWSStubs> delegate;
    Logger logger = LoggerFactory.getLogger((String)this.getClass().toString());

    public RMReportingLibrary(ProxyDelegate<RMReportingServiceJAXWSStubs> delegate) {
        this.delegate = delegate;
    }

    @Override
    public JAXWSUtils.Empty sendReport(final Types.SendReportParameters params) throws InvalidScopeException {
        Call<RMReportingServiceJAXWSStubs, JAXWSUtils.Empty> call = new Call<RMReportingServiceJAXWSStubs, JAXWSUtils.Empty>(){

            public JAXWSUtils.Empty call(RMReportingServiceJAXWSStubs endpoint) throws Exception {
                return endpoint.SendReport(params);
            }
        };
        try {
            return (JAXWSUtils.Empty)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).as(InvalidScopeException.class);
        }
    }

    @Override
    public String getReport(final String reportId) throws InvalidScopeException, NoSuchReportException {
        Call<RMReportingServiceJAXWSStubs, String> call = new Call<RMReportingServiceJAXWSStubs, String>(){

            public String call(RMReportingServiceJAXWSStubs endpoint) throws Exception {
                return endpoint.GetReport(reportId);
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).as(InvalidScopeException.class, NoSuchReportException.class);
        }
    }
}

