/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.impl.is;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.CacheEventListenerAdapter;
import org.gcube.common.core.informationsystem.ISException;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.Coordinates;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.GCubeCoordinates;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.MavenCoordinates;
import org.gcube.vremanagement.softwaregateway.impl.is.ISManager;
import org.gcube.vremanagement.softwaregateway.impl.packages.GCubePackage;
import org.gcube.vremanagement.softwaregateway.impl.packages.MavenPackage;
import org.gcube.vremanagement.softwaregateway.impl.porttypes.ServiceContext;

public class ISCache
extends ISManager {
    private CacheManager cacheManager = this.getDefaultCacheManagerConfiguration();
    private Cache cache;
    private static final int MAXIMUM_SIZE = 1000;
    private static final boolean OVERFLOW_TO_DISK = false;
    private static final String CACHE_NAME = "softwaregateway-iscache";
    private static ISCache singleton;
    public static final String CACHE_STRING_SEPARATOR = "-_-";

    private ISCache() {
        super(null);
        String[] cacheNames = this.cacheManager.getCacheNames();
        this.logger.debug((Object)"ISCACHE FOUNDED IN CONFIGURATION FILE: ");
        for (String s : cacheNames) {
            this.logger.debug((Object)("ISCaChE " + s));
        }
        this.cache = this.cacheManager.getCache(CACHE_NAME);
        if (this.cache == null) {
            this.logger.info((Object)"Added the cache: softwaregateway-iscache");
            this.cacheManager.addCache(CACHE_NAME);
            this.cache = this.cacheManager.getCache(CACHE_NAME);
        }
        this.cache.getCacheEventNotificationService().registerListener((CacheEventListener)new CacheEventListenerAdapter(){

            public void notifyRemoveAll(Ehcache cache) {
                ISCache.this.logger.info((Object)(" notifyRemoveAll in cache " + cache.getName()));
            }

            public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
                ISCache.this.logger.info((Object)(" notifyElementUpdated in cache " + cache.getName() + " element: " + element.getKey()));
            }

            public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
                ISCache.this.logger.info((Object)(" notifyElementRemoved in cache " + cache.getName() + " element: " + element.getKey()));
            }

            public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
                ISCache.this.logger.info((Object)(" notifyElementPut in cache " + cache.getName() + " element: " + element.getKey()));
            }

            public void notifyElementExpired(Ehcache cache, Element element) {
                ISCache.this.logger.info((Object)(" notifyElementExpired in cache " + cache.getName() + " element: " + element.getKey()));
            }

            public void notifyElementEvicted(Ehcache cache, Element element) {
                ISCache.this.logger.info((Object)(" notifyElementEvicted in cache " + cache.getName() + " element: " + element.getKey()));
            }

            public void dispose() {
            }
        });
        this.logger.debug((Object)"cache instantiated");
    }

    public static ISCache getInstance() {
        if (singleton == null) {
            singleton = new ISCache();
        }
        return singleton;
    }

    @Override
    public void updateProfile(String xml) {
    }

    @Override
    public List<URL> getMavenConfiguration() {
        List<URL> list = null;
        return list;
    }

    protected void put(Coordinates key, Object value) {
        this.cache.put(new Element((Object)key, value));
    }

    private MavenCoordinates get(GCubeCoordinates key) {
        Element element = this.cache.get((Serializable)key);
        if (element != null) {
            return (MavenCoordinates)element.getValue();
        }
        return null;
    }

    @Override
    public MavenCoordinates getMavenCoordinates(Coordinates gcubeC) throws ISException {
        Element element = this.cache.get((Serializable)gcubeC);
        if (element != null) {
            return (MavenCoordinates)element.getValue();
        }
        return null;
    }

    public GCubeCoordinates getGcubeCoordinates(MavenCoordinates mavenC) {
        Element element = this.cache.get((Serializable)mavenC);
        if (element != null) {
            this.logger.info((Object)"CACHE ELEMENT EXTRACTED");
            return (GCubeCoordinates)element.getValue();
        }
        return null;
    }

    @Override
    public List<MavenPackage> getMavenPackagesCoordinates(GCubeCoordinates gcubeC) {
        Element element = this.cache.get((Serializable)gcubeC);
        if (element != null) {
            return (List)((Object)element.getValue());
        }
        return null;
    }

    @Override
    public List<GCubePackage> getPluginCoordinates(Coordinates gcubeC) {
        Element element = this.cache.get((Serializable)gcubeC);
        if (element != null) {
            return (List)((Object)element.getValue());
        }
        return null;
    }

    public List<GCubePackage> getGCubePackagesCoordinates(Coordinates coordinates) {
        Element element = this.cache.get((Serializable)coordinates);
        if (element != null) {
            return (List)((Object)element.getValue());
        }
        return null;
    }

    private CacheManager getDefaultCacheManagerConfiguration() {
        String cfgDir = (String)ServiceContext.getContext().getProperty("configDir", new boolean[]{false});
        this.logger.debug((Object)("ConfigDir for cache: " + cfgDir));
        this.logger.debug((Object)("path to file: " + cfgDir + File.separator + "ehcache.xml"));
        return CacheManager.create((String)(cfgDir + File.separator + "ehcache.xml"));
    }

    public void remove(Coordinates coordinates) {
        this.logger.info((Object)("remove from is cache element: " + coordinates.getServiceClass() + " " + coordinates.getServiceName() + " " + coordinates.getServiceVersion() + " " + coordinates.getPackageName() + " " + coordinates.getPackageVersion()));
        this.cache.remove((Serializable)coordinates);
    }

    public String buildGCubeCoordinatesCacheInputString(Coordinates coordinates) {
        return coordinates.getServiceClass() + CACHE_STRING_SEPARATOR + coordinates.getServiceName() + CACHE_STRING_SEPARATOR + coordinates.getServiceVersion() + CACHE_STRING_SEPARATOR + coordinates.getPackageName() + CACHE_STRING_SEPARATOR + coordinates.getPackageVersion();
    }

    public String buildMavenCoordinatesCacheInputString(Coordinates coordinates) {
        return coordinates.getGroupId() + CACHE_STRING_SEPARATOR + coordinates.getArtifactId() + CACHE_STRING_SEPARATOR + coordinates.getVersion();
    }
}

