/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.impl.repositorymanager.util;

import java.util.ArrayList;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.util.ArtifactCoordinates;

public class ArtifactTreeNode {
    protected static final GCUBELog logger = new GCUBELog(ArtifactTreeNode.class);
    private ArtifactCoordinates item;
    private ArtifactTreeNode parent;
    private int deep;
    private List<ArtifactTreeNode> sons = new ArrayList<ArtifactTreeNode>();

    public ArtifactTreeNode(ArtifactTreeNode parent, ArtifactCoordinates item, int deep) throws Exception {
        if (item == null) {
            IllegalArgumentException e = new IllegalArgumentException();
            logger.debug((Object)e);
            throw e;
        }
        this.item = item;
        this.parent = parent;
        this.deep = deep;
    }

    public void addSon(ArtifactTreeNode son) throws Exception {
        if (!this.sons.add(son)) {
            Exception e = new Exception("Unable to add the son " + son.toString() + " to the list");
            logger.error((Object)e);
            throw e;
        }
    }

    public void removeSon(ArtifactTreeNode son) throws Exception {
        if (!this.sons.remove(son)) {
            Exception e = new Exception("Unable to remove the son " + son.toString() + " from list");
            logger.error((Object)e);
            throw e;
        }
    }

    public ArtifactCoordinates getItem() {
        return this.item;
    }

    public int getDeep() {
        return this.deep;
    }

    public ArtifactTreeNode getParent() {
        return this.parent;
    }

    public String toString() {
        return (this.parent == null ? "ROOT Node\n" : "") + "Value=" + this.item.toString() + "\nDeep = " + this.deep + "\nNumber of child = " + this.sons.size();
    }

    public String printTree() {
        String indent = "\t";
        StringBuilder deepIndent = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        if (this.parent == null) {
            sb.append("<Root>\n");
            for (ArtifactTreeNode item : this.sons) {
                sb.append(item.printTree());
            }
        } else {
            for (int i = 1; i < this.deep * 2 - 1; ++i) {
                deepIndent.append("\t");
            }
            sb.append((CharSequence)deepIndent).append("<Node>\n");
            sb.append((CharSequence)deepIndent).append("\t").append("<Value>").append(this.item.toString()).append("</Value>\n");
            if (this.sons.size() > 0) {
                sb.append((CharSequence)deepIndent).append("\t").append("<Children>\n");
                for (ArtifactTreeNode item : this.sons) {
                    sb.append(item.printTree());
                }
                sb.append((CharSequence)deepIndent).append("\t").append("</Children>\n");
            } else {
                sb.append((CharSequence)deepIndent).append("\t").append("<Children/>\n");
            }
        }
        if (this.parent == null) {
            sb.append("</Root>\n");
        } else {
            sb.append((CharSequence)deepIndent).append("</Node>\n");
        }
        return sb.toString();
    }

    public void listDependency(List<String> dep) throws Exception {
        if (this.parent != null) {
            String xml = this.item.toXML("Dependency");
            dep.add(xml);
            logger.debug((Object)("Dependency xml specification\n" + xml + "\n\n"));
        }
        for (ArtifactTreeNode treeNode : this.sons) {
            treeNode.listDependency(dep);
        }
    }
}

