/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.impl.repositorymanager.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.util.ArtifactCoordinates;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.util.ArtifactTreeNode;

public class MavenResultTreeParser {
    public static final String MORE_ON_THIS_LEVEL = "+-";
    public static final String MORE_ON_THIS_LEVEL_REGEX = "\\+-";
    public static final String LAST_OF_THIS_LEVEL = "\\-";
    public static final String CONTINUE = "|";
    public static final String INDENT = "   ";
    private static final GCUBELog logger = new GCUBELog(MavenResultTreeParser.class);
    private File resultTree;
    private ArtifactTreeNode root;
    private boolean filter = false;
    private String scopeFilter;
    private boolean filtered = false;
    private static final String RESOLVED_DEPENDECIES = "ResolvedDependencies";

    public MavenResultTreeParser(File treeFile) throws Exception {
        if (!treeFile.exists()) {
            Exception e = new Exception("Textual file with tree specification does not exist");
            logger.error((Object)e);
            throw e;
        }
        this.resultTree = treeFile;
    }

    private void buildTree() throws Exception {
        logger.debug((Object)("Parsing " + this.resultTree.getAbsolutePath() + " file"));
        String nextStr = null;
        BufferedReader filebuf = new BufferedReader(new FileReader(this.resultTree));
        nextStr = filebuf.readLine();
        System.out.println("firstLine: " + nextStr);
        ArtifactTreeNode node = null;
        if (nextStr == null) {
            Exception e = new Exception("File to parse differs from template");
            logger.error((Object)e);
            throw e;
        }
        String firstStr = "mygroup:myartifact:tar.gz:" + (this.filter ? this.scopeFilter : "GHN") + ":1.000.00:runtime";
        ArtifactCoordinates artifact = MavenResultTreeParser.getArtifactInfo(firstStr);
        this.root = new ArtifactTreeNode(null, artifact, 0);
        logger.debug((Object)this.root.toString());
        node = this.root;
        nextStr = "+- " + nextStr + ":runtime";
        while (nextStr != null) {
            node = this.parseLines(node, nextStr);
            nextStr = filebuf.readLine();
        }
        filebuf.close();
    }

    public String getScopedDependecy(String scope) throws Exception {
        if (scope != null) {
            this.filter = true;
            this.scopeFilter = scope;
        } else {
            this.filter = false;
        }
        this.buildTree();
        return "";
    }

    private ArtifactTreeNode parseLines(ArtifactTreeNode node, String nextStr) throws Exception {
        logger.debug((Object)("Parsing line : " + nextStr));
        String token = "";
        if (nextStr.contains(LAST_OF_THIS_LEVEL)) {
            token = "\\- ";
        } else if (nextStr.contains(MORE_ON_THIS_LEVEL)) {
            token = "\\+- ";
        }
        logger.debug((Object)("token =" + token));
        nextStr = nextStr.replace(CONTINUE, " ");
        int deep = 1;
        StringBuilder concatIndent = new StringBuilder();
        concatIndent.append(INDENT);
        while (nextStr.startsWith(concatIndent.toString())) {
            ++deep;
            concatIndent.append(INDENT);
        }
        logger.debug((Object)("deep = " + deep));
        String artifactCoordinates = nextStr.split(token)[1];
        this.filtered = false;
        ArtifactCoordinates artifact = MavenResultTreeParser.getArtifactInfo(artifactCoordinates);
        String scopesToFilter = "";
        scopesToFilter = this.scopeFilter.equalsIgnoreCase("compile") ? "test, provided" : (this.scopeFilter.equalsIgnoreCase("runtime") ? "test, provided, compile" : "test");
        if (this.filter && artifact.getScope() != null && scopesToFilter.contains(artifact.getScope())) {
            this.filtered = true;
        }
        ArtifactTreeNode parent = node;
        for (int auxDeep = node.getDeep(); auxDeep >= deep; --auxDeep) {
            parent = parent.getParent();
        }
        ArtifactTreeNode thisNode = new ArtifactTreeNode(parent, artifact, deep);
        logger.debug((Object)thisNode.toString());
        if (!this.filtered) {
            parent.addSon(thisNode);
        }
        return thisNode;
    }

    public static ArtifactCoordinates getArtifactInfo(String artifactCoordinates) throws Exception {
        logger.debug((Object)("Creating Artifact with coordinates = " + artifactCoordinates));
        String[] coordinates = artifactCoordinates.split(":");
        String groupId = coordinates[0];
        String artifactId = coordinates[1];
        String classifier = coordinates[2];
        String artifactVersion = "";
        String scope = "";
        if (coordinates[3].contains(".")) {
            artifactVersion = coordinates[3];
            scope = coordinates.length > 4 ? coordinates[4] : "runtime";
        } else {
            artifactVersion = coordinates[4];
            artifactId = artifactId + "#" + coordinates[3];
            scope = coordinates.length > 5 ? coordinates[5] : "runtime";
        }
        ArtifactCoordinates ret = new ArtifactCoordinates(groupId, artifactId, artifactVersion, scope, classifier);
        if (classifier != null) {
            ret.setClassifier(classifier);
        }
        return ret;
    }

    public String printTree() {
        return this.root.printTree();
    }

    public String[] listDependencyArray() throws Exception {
        ArrayList<String> dep = new ArrayList<String>();
        this.root.listDependency(dep);
        String[] ret = new String[dep.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (String)dep.get(i);
        }
        return ret;
    }

    public String listDependency() throws Exception {
        ArrayList<String> dep = new ArrayList<String>();
        this.root.listDependency(dep);
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(RESOLVED_DEPENDECIES).append(">\n");
        for (int i = 0; i < dep.size(); ++i) {
            sb.append((String)dep.get(i));
        }
        sb.append("</").append(RESOLVED_DEPENDECIES).append(">\n");
        return sb.toString();
    }
}

