package org.gcube.vremanagement.softwaregateway.impl.porttypes;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.io.FileUtils;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.ISException;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.resources.GCUBEService;
import org.gcube.common.core.resources.service.Package;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.vremanagement.softwaregateway.answer.AnswerBuild;
import org.gcube.vremanagement.softwaregateway.answer.ReportObject;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.Coordinates;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.GCubeCoordinates;
import org.gcube.vremanagement.softwaregateway.impl.exceptions.BadCoordinatesException;
import org.gcube.vremanagement.softwaregateway.impl.exceptions.ServiceNotAvaiableFault;
import org.gcube.vremanagement.softwaregateway.impl.is.ISCache;
import org.gcube.vremanagement.softwaregateway.impl.is.ISManager;
import org.gcube.vremanagement.softwaregateway.impl.is.ISProxy;
import org.gcube.vremanagement.softwaregateway.impl.packages.GCubePackage;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.NexusRepositoryManager;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.cache.NexusCache;
import org.gcube.vremanagement.softwaregateway.stubs.LocationCoordinates;


public class Registration  extends GCUBEPortType {

	/**
	 * Register a profile in the InformationSystem
	 * @param profile
	 * @return
	 * @throws ServiceNotAvaiableFault
	 */
	public String register(String profile) throws ServiceNotAvaiableFault{
	// retrieve scopes
		logger.debug("register method ");
//		GCUBEScope[] list=ServiceContext.getContext().getStartScopes();
		Map<String, GCUBEScope> list=ServiceContext.getContext().getInstance().getScopes();
		logger.debug("Register resource with following start scopes:");
		Set<String> setScopes=list.keySet();
		for(String scope : setScopes){
			logger.debug("scope: "+scope);
		}
		List<ReportObject> listReport=new ArrayList();
		GCUBEService resource=null;
		String id=null;
		try {
			resource = GHNContext.getImplementation(GCUBEService.class);
			logger.debug("load resource: "+profile);
			resource.load(new StringReader(profile.trim()));
		}catch(Exception e){
			throw new ServiceNotAvaiableFault("load resource exception "+e.getMessage());
		}
		if(resource!=null){
			id=resource.getID();
			removeAllPAckagesFromCache(resource);
			checkResourceCoordinates(resource);
			for(String scope : setScopes){
				logger.debug(" added scope: "+scope+" to resource "+resource.getID()+" with description:"+resource.getDescription());
				resource.addScope(list.get(scope));
			}
			Set<String> s=resource.getScopes().keySet();
			String idNewResource=null;
			if(s.size() == 0)
				logger.debug("The scope set is empty! The resource not will be pubblicated");
			else{
				for(String scopeName : s){
					GCUBEScope scope=GCUBEScope.getScope(scopeName);
					ISProxy is=new ISProxy(scope, false);
					try{
						logger.debug("public resource in scope: "+scopeName);
						id=is.publicResourceIS(resource, scope);
					} catch (Exception e) {
						throw new ServiceNotAvaiableFault("problem to public resource in IS");
					}

				}
			}
			if(idNewResource == null)
				listReport=buildResourceReport(resource, listReport, list, "UPDATE");
			else
				listReport=buildResourceReport(resource, listReport, list, "NEW");
			AnswerBuild answer= new AnswerBuild();
			String report=answer.constructReportAnswer(listReport);
			logger.info("Report:");
			logger.info(report);
			return report;

		}else return null;
	}

	private void checkResourceCoordinates(GCUBEService resource) throws ServiceNotAvaiableFault {
		List<Package> listP=resource.getPackages();
		for(Package  p : listP){
			String v=p.getMavenCoordinate(org.gcube.common.core.resources.service.Package.MavenCoordinate.version);
			if(!p.getVersion().equals(v))
				throw new ServiceNotAvaiableFault("The package version not corresponds to maven coordinate version");
		}
	}

	/**
	 * @param resource
	 */
	private List<ReportObject> buildResourceReport(GCUBEService resource, List<ReportObject> listReport, Map<String, GCUBEScope> listScopes, String operation) {
		logger.debug("buildResourceReport method");
		List<org.gcube.common.core.resources.service.Package> listPackage= resource.getPackages();
		if(listPackage!=null)
			logger.debug("packages founded: "+listPackage.size());
		boolean isPresent=checkResource(resource, listScopes);
		String groupID=null;
		String artifactId=null;
		String version=null;
		for(org.gcube.common.core.resources.service.Package p : listPackage){
			groupID=p.getMavenCoordinate(org.gcube.common.core.resources.service.Package.MavenCoordinate.groupId);
			artifactId=p.getMavenCoordinate(org.gcube.common.core.resources.service.Package.MavenCoordinate.artifactId);
			version=p.getMavenCoordinate(org.gcube.common.core.resources.service.Package.MavenCoordinate.version);
			logger.debug("buildReport:package:"+p.getName()+" v "+p.getVersion()+" maven coordinate founded: g"+groupID+"  a: "+artifactId+" v: "+version);
			String artifactUrl=null;
			String javadocUrl=null;
			ReportObject report =null;
			GCubePackage gcubePackage=null;
			boolean jarUrl=true;
			try{
				Coordinates coordinates= new GCubeCoordinates(resource.getServiceName(), resource.getServiceClass(), resource.getVersion(), p.getName(), p.getVersion());
				coordinates.setGroupId(groupID);
				coordinates.setArtifactId(artifactId);
				coordinates.setVersion(version);
				gcubePackage=new GCubePackage(coordinates);
			
				artifactUrl=gcubePackage.getLocation();
				
			}catch(ServiceNotAvaiableFault e){
				jarUrl=false;
			}
			try {
				javadocUrl=gcubePackage.getDocLocation();
			} catch (ServiceNotAvaiableFault e) {
				logger.error("javadoc not found ");
				if(jarUrl)
					report = new ReportObject(groupID, artifactId, version, Long.toString(System.currentTimeMillis()), artifactUrl, javadocUrl, "WARN", operation, resource.getID());
				else
					report = new ReportObject(groupID, artifactId, version, Long.toString(System.currentTimeMillis()), artifactUrl, javadocUrl, "ERROR", operation, resource.getID());
				listReport.add(report);
			} 
			if(report== null){
				if(artifactUrl != null && javadocUrl!=null)
					report = new ReportObject(groupID, artifactId, version, Long.toString(System.currentTimeMillis()), artifactUrl, javadocUrl, "SUCCESS", operation, resource.getID());
				else if(artifactUrl == null)
					report = new ReportObject(groupID, artifactId, version, Long.toString(System.currentTimeMillis()), artifactUrl, javadocUrl, "ERROR", operation, resource.getID());
				else
					report = new ReportObject(groupID, artifactId, version, Long.toString(System.currentTimeMillis()), artifactUrl, javadocUrl, "WARN", operation, resource.getID());
				listReport.add(report);
			}
			report=null;
			groupID=null;
			artifactId=null;
			version=null;
		}
		return listReport;
	}

	private boolean checkResource(GCUBEService resource, Map<String, GCUBEScope> listScopes) {
		logger.debug("checkResource method ");
		Set<String> setScopes=listScopes.keySet();
		String isPresent=null;
		for(String scope : setScopes){
			logger.debug("check in scope: "+scope);
			ISProxy is =new ISProxy(listScopes.get(scope), false);
			try {
				isPresent=is.checkResourceOnIS(resource);
			} catch (ISException e) {
				logger.warn("resource not found in IS or is exception");
				return false;
			}
			if(isPresent!=null)
				return true;
		}
		return false;
	}

	/**
	 * @param resource
	 * @throws BadCoordinatesException
	 */
	private void removeAllPAckagesFromCache(GCUBEService resource)
			throws BadCoordinatesException {
		List<org.gcube.common.core.resources.service.Package> packageList=resource.getPackages();
		NexusCache cacheNExus=NexusCache.getInstance(null);
		ISCache cacheIS=ISCache.getInstance();
		for(org.gcube.common.core.resources.service.Package p: packageList){
			String pn=p.getName();
			String pv=p.getVersion();
			logger.info("CHECK PACKAGE FROM RESOURCE: "+resource.getID()+" pn "+pn+" pv: "+pv);
			Coordinates coordinates=new GCubeCoordinates(resource.getServiceName(), resource.getServiceClass(), resource.getVersion(), pn, pv);
			GCubeCoordinates gcubeC=new GCubeCoordinates(resource.getServiceName(), resource.getServiceClass(), resource.getVersion(), pn, pv);
			cacheIS.remove(gcubeC);
			String cacheString=cacheNExus.buildGCubeCoordinatesCacheInputString(coordinates, "jar", null);
			cacheNExus.remove(cacheString);
			cacheString=cacheNExus.buildGCubeCoordinatesCacheInputString(coordinates, "pom", null);
			cacheNExus.remove(cacheString);
			cacheString=cacheNExus.buildGCubeCoordinatesCacheInputString(coordinates, "tar.gz", "servicearchive");
			cacheNExus.remove(cacheString);
			removeLocalSAURL(coordinates);
		}
	}

	/**
	 * Unregister a package in the Information System
	 * @param serviceName
	 * @param serviceClass
	 * @param serviceVersion
	 * @param packageName
	 * @param packageVersion
	 * @throws ServiceNotAvaiableFault
	 */
	public void unregister(LocationCoordinates coord) throws ServiceNotAvaiableFault{
		logger.debug("unregister() invoked with coordinates: "+coord.getServiceClass()+" "+coord.getServiceName()+"  "+coord.getServiceVersion()+"  "+coord.getPackageName()+"  "+coord.getPackageVersion());
		try{
			GCubeCoordinates coordinates= new GCubeCoordinates(coord.getServiceName(), coord.getServiceClass(), coord.getServiceVersion(), coord.getPackageName(), coord.getPackageVersion());
			GCubePackage p=new GCubePackage(coordinates);
			p.unregister();
		}catch(Exception e){
			e.printStackTrace();
			throw new ServiceNotAvaiableFault(e.getMessage());
		}
	}

	/**
	 * Return the current context
	 */
	@Override
	protected GCUBEServiceContext getServiceContext() {
		return ServiceContext.getContext();
	}
	
	/**
	 * remove a local SA archive ,
	 * @param coordinates coordinates that identifies  the SA
	 * 
	 */
	public void removeLocalSAURL(Coordinates coordinates) {		
		String relativePath=File.separator+coordinates.getServiceClass()+File.separator+coordinates.getServiceName()+File.separator+coordinates.getPackageName()+File.separator+coordinates.getPackageVersion();
		File urlDirectory = new File(ServiceContext.getContext().getHttpServerBasePath().getAbsolutePath() +File.separator+ ServiceContext.getContext().getMavenRelativeDir()+relativePath);
		if(urlDirectory.exists()){
			try {
				FileUtils.deleteDirectory(urlDirectory);
			} catch (IOException e) {
				logger.info(" Impossible delete directory : "+urlDirectory.getAbsolutePath());
			}
		}
	}

	
}
