/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.impl.packages;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.core.informationsystem.ISException;
import org.gcube.common.core.resources.service.Package;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.Coordinates;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.MavenCoordinates;
import org.gcube.vremanagement.softwaregateway.impl.exceptions.BadCoordinatesException;
import org.gcube.vremanagement.softwaregateway.impl.exceptions.ServiceNotAvaiableFault;
import org.gcube.vremanagement.softwaregateway.impl.packages.Package;
import org.gcube.vremanagement.softwaregateway.impl.porttypes.ServiceContext;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.RepositoryManagerFactory;

public class GCubePackage
extends Package {
    Coordinates coordinates;
    protected final GCUBELog logger = new GCUBELog(GCubePackage.class);

    public GCubePackage(Coordinates coordinates) throws BadCoordinatesException {
        this.setCoordinates(coordinates);
    }

    @Override
    public String getLocation() throws ServiceNotAvaiableFault {
        this.logger.trace((Object)"GCubePackage, getLocation method");
        String url = null;
        this.initialize();
        try {
            MavenCoordinates mavenC = this.getMavenCoordinates();
            RepositoryManagerFactory rmf = new RepositoryManagerFactory();
            this.rm = rmf.getRepositoryManager(this.is.getMavenServerList(this.scope), true);
            url = this.rm.get(mavenC, "jar", "servicearchive");
            this.logger.debug((Object)(" url of jar founded: " + url));
        }
        catch (Exception e) {
            throw new ServiceNotAvaiableFault(e.getMessage());
        }
        finally {
            if (url == null) {
                throw new ServiceNotAvaiableFault("url is null ");
            }
        }
        return url;
    }

    public String getDocLocation() throws ServiceNotAvaiableFault {
        this.logger.trace((Object)"GCubePackage, getDocLocation method");
        String url = null;
        this.initialize();
        try {
            MavenCoordinates mavenC = this.getMavenCoordinates();
            RepositoryManagerFactory rmf = new RepositoryManagerFactory();
            this.rm = rmf.getRepositoryManager(this.is.getMavenServerList(this.scope), true);
            url = this.rm.get(mavenC, "jar", "javadoc");
            this.logger.debug((Object)(" url of javadoc founded: " + url));
        }
        catch (Exception e) {
            throw new ServiceNotAvaiableFault(e.getMessage());
        }
        finally {
            if (url == null) {
                throw new ServiceNotAvaiableFault("url is null ");
            }
        }
        return url;
    }

    @Override
    public String getSALocation() throws ServiceNotAvaiableFault {
        this.logger.trace((Object)" getSALocation method");
        String url = null;
        this.initialize();
        this.logger.debug((Object)("Create a temporary directory: " + this.coordinates.getServiceClass() + " in directory: " + ServiceContext.getContext().getTmp()));
        File tmpParentDirectory = new File(ServiceContext.getContext().getTmp(), this.coordinates.getServiceClass());
        if (!tmpParentDirectory.exists()) {
            tmpParentDirectory.mkdir();
        }
        File tmpTargetDirectory = new File(tmpParentDirectory, this.coordinates.getServiceName() + "_" + this.coordinates.getServiceVersion());
        try {
            MavenCoordinates mavenC = this.getSAMavenCoordinates();
            ArrayList<MavenCoordinates> mcList = new ArrayList<MavenCoordinates>();
            mcList.add(mavenC);
            RepositoryManagerFactory rmf = new RepositoryManagerFactory();
            this.rm = rmf.getRepositoryManager(this.is.getMavenServerList(this.scope), true);
            url = this.rm.getSALocation(tmpTargetDirectory, mcList, this.coordinates);
        }
        catch (Exception e) {
            throw new ServiceNotAvaiableFault(e.getMessage());
        }
        finally {
            if (url == null) {
                throw new ServiceNotAvaiableFault("url is null ");
            }
        }
        return url;
    }

    @Override
    public String getDependencies() throws ServiceNotAvaiableFault {
        this.logger.trace((Object)"GCubePackage, getDependencies method");
        this.initialize();
        String result = null;
        try {
            result = this.findDeps();
        }
        catch (Exception e) {
            this.logger.error((Object)("Failed to retrive software deps for " + this.coordinates.getServiceName()), (Throwable)e);
            throw new ServiceNotAvaiableFault();
        }
        if (result == null) {
            this.logger.error((Object)("Failed to retrive software deps for " + this.coordinates.getServiceName() + ": repository returned null results"));
            throw new ServiceNotAvaiableFault("Failed to retrive software deps for " + this.coordinates.getServiceName() + ": repository returned null results");
        }
        return result;
    }

    @Override
    public List<GCubePackage> getPackages() throws ServiceNotAvaiableFault {
        this.logger.trace((Object)"GCubePackage, getPackages method");
        this.initialize();
        List<GCubePackage> coordList = null;
        try {
            coordList = this.is.getGCubePackagesCoordinates(this.coordinates);
        }
        catch (ISException e) {
            throw new ServiceNotAvaiableFault("Coordinates not found");
        }
        finally {
            if (coordList == null) {
                throw new ServiceNotAvaiableFault("Coordinates not found");
            }
        }
        return coordList;
    }

    @Override
    public List<GCubePackage> getPlugins() throws ServiceNotAvaiableFault {
        this.logger.trace((Object)" getPlugins method ");
        this.initialize();
        List<GCubePackage> coordList = null;
        try {
            coordList = this.is.getPluginCoordinates(this.coordinates);
        }
        catch (ISException e) {
            throw new ServiceNotAvaiableFault();
        }
        return coordList;
    }

    @Override
    public String register() {
        return null;
    }

    @Override
    public void unregister() throws ServiceNotAvaiableFault {
        this.logger.trace((Object)"GCubePackage unregister method");
        this.initialize();
        try {
            this.is.updatePackageResource(this.coordinates.getServiceName(), this.coordinates.getServiceClass(), this.coordinates.getServiceVersion(), this.coordinates.getPackageName(), this.coordinates.getPackageVersion());
        }
        catch (ISException e) {
            throw new ServiceNotAvaiableFault();
        }
    }

    @Override
    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    private void setCoordinates(Coordinates coordinates) throws BadCoordinatesException {
        this.logger.trace((Object)"GCubePackage setCoordinates method");
        this.coordinates = coordinates;
        this.logger.debug((Object)"GCubePackage Coordinates ok");
    }

    private MavenCoordinates getMavenCoordinates() throws BadCoordinatesException {
        this.logger.trace((Object)("getMavenCoordinates method: with maven Coordinates: g " + this.coordinates.getGroupId() + " a " + this.coordinates.getArtifactId() + " v " + this.coordinates.getVersion()));
        MavenCoordinates mavenC = null;
        if (this.coordinates.getGroupId() == null || this.coordinates.getArtifactId() == null || this.coordinates.getVersion() == null) {
            try {
                mavenC = this.is.getMavenCoordinates(this.coordinates);
            }
            catch (ISException e) {
                this.logger.error((Object)"IS EXCEPTION CATCHED");
            }
            if (mavenC == null) {
                this.logger.debug((Object)" no maven coordinates founded in profile. Try to convert from gCube to Maven");
                try {
                    mavenC = (MavenCoordinates)this.coordinates.convert();
                }
                catch (BadCoordinatesException e) {
                    throw new BadCoordinatesException(" convert from gcube to maven");
                }
            } else {
                this.logger.debug((Object)("founded maven Coordinates in profile: gid: " + mavenC.getGroupId() + " aid: " + mavenC.getArtifactId() + " v: " + mavenC.getVersion()));
            }
        } else {
            this.logger.debug((Object)"maven coordinates already setted ");
            mavenC = new MavenCoordinates(this.coordinates.getGroupId(), this.coordinates.getArtifactId(), this.coordinates.getVersion());
        }
        return mavenC;
    }

    private MavenCoordinates getSAMavenCoordinates() throws BadCoordinatesException {
        this.logger.trace((Object)("getMavenCoordinates method: with maven Coordinates: g " + this.coordinates.getGroupId() + " a " + this.coordinates.getArtifactId() + " v " + this.coordinates.getVersion()));
        MavenCoordinates mavenC = null;
        if (this.coordinates.getGroupId() == null || this.coordinates.getArtifactId() == null || this.coordinates.getVersion() == null) {
            try {
                mavenC = this.is.getSAMavenCoordinates(this.coordinates);
            }
            catch (ISException e) {
                this.logger.error((Object)"IS EXCEPTION CATCHED");
            }
            if (mavenC == null) {
                this.logger.debug((Object)" no maven coordinates founded in profile. Try to convert from gCube to Maven");
                try {
                    mavenC = (MavenCoordinates)this.coordinates.convert();
                }
                catch (BadCoordinatesException e) {
                    throw new BadCoordinatesException(" convert from gcube to maven");
                }
            } else {
                this.logger.debug((Object)("founded maven Coordinates in profile: gid: " + mavenC.getGroupId() + " aid: " + mavenC.getArtifactId() + " v: " + mavenC.getVersion()));
            }
        } else {
            this.logger.debug((Object)"maven coordinates already setted ");
            mavenC = new MavenCoordinates(this.coordinates.getGroupId(), this.coordinates.getArtifactId(), this.coordinates.getVersion());
        }
        return mavenC;
    }

    private String findDeps() throws ServiceNotAvaiableFault {
        this.logger.trace((Object)"findDeps method");
        String url = null;
        List<MavenCoordinates> mavenList = this.convertGcubeToMaven();
        this.logger.info((Object)("founded " + mavenList.size() + " packages "));
        this.logger.debug((Object)"try to retrieve Repository Manager server list");
        RepositoryManagerFactory rmf = new RepositoryManagerFactory();
        try {
            this.rm = rmf.getRepositoryManager(this.is.getMavenServerList(this.scope), true);
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to retrieve Repository Manager server list for " + this.coordinates.getServiceName()), (Throwable)e);
            throw new ServiceNotAvaiableFault("Unable to retrieve Repository Manager server list for " + this.coordinates.getServiceName());
        }
        String result = null;
        String resultMerged = null;
        ArrayList<String> resultList = new ArrayList<String>();
        for (MavenCoordinates mavenC : mavenList) {
            try {
                this.logger.debug((Object)(" try to retrieve pom's url for coordinates gid= " + mavenC.getGroupId() + " aid: " + mavenC.getArtifactId() + " v: " + mavenC.getVersion()));
                url = this.rm.get(mavenC, "pom", null);
                this.logger.debug((Object)(" pom url is : " + url));
            }
            catch (Exception e) {
                this.logger.info((Object)("url is null for package " + mavenC.getGroupId() + " " + mavenC.getArtifactId() + " " + mavenC.getVersion()));
                break;
            }
            this.logger.debug((Object)"pom file founded, try to extract Dependencies...");
            result = this.rm.extractDepsFromMavenEmb(url.toString());
            resultList.add(result);
        }
        resultMerged = this.mergeResult(resultList);
        return resultMerged.toString();
    }

    private String mergeResult(ArrayList<String> resultList) {
        this.logger.trace((Object)"mergeResult method");
        StringBuffer resolvedDep = new StringBuffer();
        StringBuffer missingDep = new StringBuffer();
        for (String result : resultList) {
            try {
                this.logger.debug((Object)("process: \n" + result));
                if (result.contains("<ResolvedDependencies>") && result.contains("</ResolvedDependencies>")) {
                    String temp = result.substring(result.lastIndexOf("<ResolvedDependencies>"), result.lastIndexOf("</ResolvedDependencies>"));
                    temp = temp.substring(22);
                    this.logger.debug((Object)("resolved deps:\n" + temp));
                    resolvedDep.append(temp);
                }
                if (!result.contains("<MissingDependencies>") || !result.contains("</MissingDependencies>")) continue;
                String temp2 = result.substring(result.lastIndexOf("<MissingDependencies>"), result.lastIndexOf("</MissingDependencies>"));
                temp2 = temp2.substring(21);
                this.logger.debug((Object)("missing deps:\n" + temp2));
                missingDep.append(temp2);
            }
            catch (Exception e) {
                this.logger.error((Object)("exception: " + e.getMessage()));
                e.printStackTrace();
            }
        }
        String result = "<DependencyResolutionReport>\n\t<ResolvedDependencies>\n" + resolvedDep.toString() + "</ResolvedDependencies>\n" + "<MissingDependencies>\n" + missingDep.toString() + "</MissingDependencies>\n</DependencyResolutionReport>";
        return result;
    }

    private List<MavenCoordinates> convertGcubeToMaven() throws BadCoordinatesException {
        this.logger.trace((Object)"convertGcubeToMaven method");
        ArrayList<MavenCoordinates> mavenList = new ArrayList<MavenCoordinates>();
        if (this.coordinates.getPackageName() == null && this.coordinates.getPackageVersion() == null) {
            this.logger.debug((Object)"Package coordinates are null. Try to extract all package coordinates");
            List<org.gcube.common.core.resources.service.Package> packs = null;
            try {
                packs = this.is.queryPackagesCoordinates(this.coordinates.getServiceName(), this.coordinates.getServiceClass(), this.coordinates.getServiceVersion());
            }
            catch (ISException e) {
                e.printStackTrace();
            }
            for (org.gcube.common.core.resources.service.Package p : packs) {
                this.logger.debug((Object)("processing pack: " + p.getName() + " " + p.getVersion()));
                try {
                    String gId = p.getMavenCoordinate(Package.MavenCoordinate.groupId);
                    String aId = p.getMavenCoordinate(Package.MavenCoordinate.artifactId);
                    String v = p.getMavenCoordinate(Package.MavenCoordinate.version);
                    MavenCoordinates mc = new MavenCoordinates(gId, aId, v);
                    this.logger.debug((Object)("package added: " + gId + " " + aId + " " + v));
                    mavenList.add(mc);
                }
                catch (BadCoordinatesException e) {
                    this.logger.warn((Object)"package  not added, bad coordinate founded ");
                }
            }
        } else {
            MavenCoordinates mavenC = this.getMavenCoordinates();
            this.logger.info((Object)("Maven Coordinates founded are: gid: " + mavenC.getGroupId() + " aid " + mavenC.getArtifactId() + " v " + mavenC.getVersion()));
            mavenList.add(mavenC);
        }
        return mavenList;
    }
}

