/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.impl.porttypes;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.resources.GCUBEService;
import org.gcube.common.core.resources.service.Package;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.vremanagement.softwaregateway.answer.AnswerBuild;
import org.gcube.vremanagement.softwaregateway.answer.ReportObject;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.Coordinates;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.GCubeCoordinates;
import org.gcube.vremanagement.softwaregateway.impl.exceptions.BadCoordinatesException;
import org.gcube.vremanagement.softwaregateway.impl.exceptions.ServiceNotAvaiableFault;
import org.gcube.vremanagement.softwaregateway.impl.is.ISCache;
import org.gcube.vremanagement.softwaregateway.impl.is.ISProxy;
import org.gcube.vremanagement.softwaregateway.impl.packages.GCubePackage;
import org.gcube.vremanagement.softwaregateway.impl.porttypes.ServiceContext;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.cache.NexusCache;
import org.gcube.vremanagement.softwaregateway.stubs.LocationCoordinates;

public class Registration
extends GCUBEPortType {
    public String register(String profile) throws ServiceNotAvaiableFault {
        this.logger.trace((Object)"register method ");
        Map list = ServiceContext.getContext().getInstance().getScopes();
        this.logger.debug((Object)"Register resource with following start scopes:");
        Set setScopes = list.keySet();
        for (String scope : setScopes) {
            this.logger.debug((Object)("scope: " + scope));
        }
        List<ReportObject> listReport = new ArrayList<ReportObject>();
        GCUBEService resource = null;
        try {
            resource = (GCUBEService)GHNContext.getImplementation(GCUBEService.class);
            this.logger.debug((Object)("load resource: " + profile));
            resource.load((Reader)new StringReader(profile.trim()));
        }
        catch (Exception e) {
            throw new ServiceNotAvaiableFault("load resource exception " + e.getMessage());
        }
        this.checkResourceCoordinates(resource);
        for (String scope : setScopes) {
            this.logger.debug((Object)(" added scope: " + scope + " to resource " + resource.getID() + " with description:" + resource.getDescription()));
            resource.addScope(new GCUBEScope[]{(GCUBEScope)list.get(scope)});
        }
        Set<String> s = resource.getScopes().keySet();
        String idNewResource = null;
        if (s.size() == 0) {
            this.logger.debug((Object)"The scope set is empty! The resource not will be pubblicated");
        } else {
            idNewResource = this.checkOnAllScopes(resource, s);
        }
        listReport = idNewResource != null ? this.buildResourceReport(resource, listReport, list, "UPDATE") : this.buildResourceReport(resource, listReport, list, "NEW");
        boolean errorFound = false;
        for (ReportObject r : listReport) {
            if (!r.status.equalsIgnoreCase("ERROR")) continue;
            errorFound = true;
            break;
        }
        if (!errorFound) {
            this.publicOnAllScopes(resource, s);
        }
        AnswerBuild answer = new AnswerBuild();
        String report = answer.constructReportAnswer(listReport);
        this.logger.info((Object)"Report:");
        this.logger.info((Object)report);
        return report;
    }

    private void publicOnAllScopes(GCUBEService resource, Set<String> s) throws ServiceNotAvaiableFault {
        for (String scopeName : s) {
            GCUBEScope scope = GCUBEScope.getScope((String)scopeName);
            ISProxy is = new ISProxy(scope, false);
            try {
                this.logger.debug((Object)("public resource in scope: " + scopeName));
                is.publicResourceIS(resource, scope);
            }
            catch (Exception e) {
                throw new ServiceNotAvaiableFault("problem to public resource in IS");
            }
        }
    }

    private String checkOnAllScopes(GCUBEService resource, Set<String> s) throws ServiceNotAvaiableFault {
        String idNewResource = null;
        for (String scopeName : s) {
            GCUBEScope scope = GCUBEScope.getScope((String)scopeName);
            ISProxy is = new ISProxy(scope, false);
            try {
                this.logger.debug((Object)("public resource in scope: " + scopeName));
                idNewResource = is.checkResourceOnIS(resource);
            }
            catch (Exception e) {
                throw new ServiceNotAvaiableFault("problem to public resource in IS");
            }
        }
        return idNewResource;
    }

    private void checkResourceCoordinates(GCUBEService resource) throws ServiceNotAvaiableFault {
        List listP = resource.getPackages();
        for (Package p : listP) {
            String v = p.getMavenCoordinate(Package.MavenCoordinate.version);
            if (p.getVersion().equals(v)) continue;
            throw new ServiceNotAvaiableFault("The package version not corresponds to maven coordinate version");
        }
    }

    private List<ReportObject> buildResourceReport(GCUBEService resource, List<ReportObject> listReport, Map<String, GCUBEScope> listScopes, String operation) {
        this.logger.trace((Object)"buildResourceReport method");
        List listPackage = resource.getPackages();
        if (listPackage != null) {
            this.logger.debug((Object)("packages founded: " + listPackage.size()));
        }
        String groupID = null;
        String artifactId = null;
        String version = null;
        for (Package p : listPackage) {
            groupID = p.getMavenCoordinate(Package.MavenCoordinate.groupId);
            artifactId = p.getMavenCoordinate(Package.MavenCoordinate.artifactId);
            version = p.getMavenCoordinate(Package.MavenCoordinate.version);
            this.logger.debug((Object)("buildReport:package:" + p.getName() + " v " + p.getVersion() + " maven coordinate founded: g" + groupID + "  a: " + artifactId + " v: " + version));
            String artifactUrl = null;
            String javadocUrl = null;
            ReportObject report = null;
            GCubePackage gcubePackage = null;
            boolean jarUrl = true;
            try {
                GCubeCoordinates coordinates = new GCubeCoordinates(resource.getServiceName(), resource.getServiceClass(), resource.getVersion(), p.getName(), p.getVersion());
                coordinates.setGroupId(groupID);
                coordinates.setArtifactId(artifactId);
                coordinates.setVersion(version);
                gcubePackage = new GCubePackage(coordinates);
                artifactUrl = gcubePackage.getLocation();
            }
            catch (ServiceNotAvaiableFault e) {
                jarUrl = false;
            }
            try {
                javadocUrl = gcubePackage.getDocLocation();
            }
            catch (ServiceNotAvaiableFault e) {
                this.logger.error((Object)"javadoc not found ");
                report = jarUrl ? new ReportObject(groupID, artifactId, version, Long.toString(System.currentTimeMillis()), artifactUrl, javadocUrl, "WARN", operation, resource.getID()) : new ReportObject(groupID, artifactId, version, Long.toString(System.currentTimeMillis()), artifactUrl, javadocUrl, "ERROR", operation, resource.getID());
                listReport.add(report);
            }
            if (report == null) {
                report = artifactUrl != null && javadocUrl != null ? new ReportObject(groupID, artifactId, version, Long.toString(System.currentTimeMillis()), artifactUrl, javadocUrl, "SUCCESS", operation, resource.getID()) : (artifactUrl == null ? new ReportObject(groupID, artifactId, version, Long.toString(System.currentTimeMillis()), artifactUrl, javadocUrl, "ERROR", operation, resource.getID()) : new ReportObject(groupID, artifactId, version, Long.toString(System.currentTimeMillis()), artifactUrl, javadocUrl, "WARN", operation, resource.getID()));
                listReport.add(report);
            }
            report = null;
            groupID = null;
            artifactId = null;
            version = null;
        }
        return listReport;
    }

    private void removeAllPAckagesFromCache(GCUBEService resource) throws BadCoordinatesException {
        List packageList = resource.getPackages();
        NexusCache cacheNExus = NexusCache.getInstance(null);
        ISCache cacheIS = ISCache.getInstance();
        for (Package p : packageList) {
            String pn = p.getName();
            String pv = p.getVersion();
            this.logger.debug((Object)("CHECK PACKAGE FROM RESOURCE: " + resource.getID() + " pn " + pn + " pv: " + pv));
            GCubeCoordinates coordinates = new GCubeCoordinates(resource.getServiceName(), resource.getServiceClass(), resource.getVersion(), pn, pv);
            GCubeCoordinates gcubeC = new GCubeCoordinates(resource.getServiceName(), resource.getServiceClass(), resource.getVersion(), pn, pv);
            cacheIS.remove(gcubeC);
            String cacheString = cacheNExus.buildGCubeCoordinatesCacheInputString(coordinates, "jar", null);
            cacheNExus.remove(cacheString);
            cacheString = cacheNExus.buildGCubeCoordinatesCacheInputString(coordinates, "pom", null);
            cacheNExus.remove(cacheString);
            cacheString = cacheNExus.buildGCubeCoordinatesCacheInputString(coordinates, "tar.gz", "servicearchive");
            cacheNExus.remove(cacheString);
            this.removeLocalSAURL(coordinates);
        }
    }

    public void unregister(LocationCoordinates coord) throws ServiceNotAvaiableFault {
        this.logger.trace((Object)("unregister() invoked with coordinates: " + coord.getServiceClass() + " " + coord.getServiceName() + "  " + coord.getServiceVersion() + "  " + coord.getPackageName() + "  " + coord.getPackageVersion()));
        try {
            GCubeCoordinates coordinates = new GCubeCoordinates(coord.getServiceName(), coord.getServiceClass(), coord.getServiceVersion(), coord.getPackageName(), coord.getPackageVersion());
            GCubePackage p = new GCubePackage(coordinates);
            p.unregister();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceNotAvaiableFault(e.getMessage());
        }
    }

    protected GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    public void removeLocalSAURL(Coordinates coordinates) {
        String relativePath = File.separator + coordinates.getServiceClass() + File.separator + coordinates.getServiceName() + File.separator + coordinates.getPackageName() + File.separator + coordinates.getPackageVersion();
        File urlDirectory = new File(ServiceContext.getContext().getHttpServerBasePath().getAbsolutePath() + File.separator + ServiceContext.getContext().getMavenRelativeDir() + relativePath);
        if (urlDirectory.exists()) {
            try {
                FileUtils.deleteDirectory((File)urlDirectory);
            }
            catch (IOException e) {
                this.logger.info((Object)(" Impossible to delete directory : " + urlDirectory.getAbsolutePath()));
            }
        }
    }
}

