/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.impl.is;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.ISException;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEServiceQuery;
import org.gcube.common.core.informationsystem.publisher.ISPublisher;
import org.gcube.common.core.informationsystem.publisher.ISPublisherException;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.resources.GCUBEService;
import org.gcube.common.core.resources.service.Package;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.Coordinates;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.GCubeCoordinates;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.MavenCoordinates;
import org.gcube.vremanagement.softwaregateway.impl.exceptions.BadCoordinatesException;
import org.gcube.vremanagement.softwaregateway.impl.packages.GCubePackage;
import org.gcube.vremanagement.softwaregateway.impl.packages.MavenPackage;
import org.gcube.vremanagement.softwaregateway.impl.porttypes.ServiceContext;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.maven.FileUtilsExtended;

public abstract class ISManager {
    GCUBEScope scope;
    ISClient isClient;
    ISPublisher isPublisher;
    String[] server;
    protected boolean cacheEnabled = true;
    protected final GCUBELog logger = new GCUBELog(ISManager.class);

    public ISManager(GCUBEScope gCubeScope) {
        this.scope = gCubeScope;
    }

    public abstract MavenCoordinates getMavenCoordinates(Coordinates var1) throws ISException;

    public abstract List<MavenPackage> getMavenPackagesCoordinates(GCubeCoordinates var1) throws ISException;

    public abstract void updateProfile(String var1);

    public abstract List<URL> getMavenConfiguration();

    public abstract List<GCubePackage> getPluginCoordinates(Coordinates var1) throws ISException;

    ISClient getIsClient() throws Exception {
        if (this.isClient == null) {
            this.isClient = (ISClient)GHNContext.getImplementation(ISClient.class);
        }
        return this.isClient;
    }

    ISPublisher getIsPublisher() throws Exception {
        if (this.isPublisher == null) {
            this.isPublisher = (ISPublisher)GHNContext.getImplementation(ISPublisher.class);
        }
        return this.isPublisher;
    }

    protected MavenCoordinates queryMavenCoordinates(String serviceName, String serviceClass, String serviceVersion, String packageName, String packageVersion) throws ISException {
        this.logger.trace((Object)"queryMavenCoordinates method");
        MavenCoordinates mCoordinates = null;
        GCUBEServiceQuery serviceQuery = null;
        List<MavenPackage> listPackages = new ArrayList<MavenPackage>();
        try {
            serviceQuery = (GCUBEServiceQuery)this.getIsClient().getQuery(GCUBEServiceQuery.class);
        }
        catch (Exception e) {
            throw new ISException();
        }
        serviceQuery = this.buildServiceQuery(serviceName, serviceClass, serviceVersion, serviceQuery);
        try {
            this.logger.debug((Object)("execute query in scope: " + this.scope.getName()));
            for (GCUBEService resource : this.isClient.execute((ISQuery)serviceQuery, this.scope)) {
                MavenPackage p;
                this.logger.debug((Object)("founded resource: " + resource.getID()));
                listPackages = this.buildMavenPackage(listPackages, resource, packageName, packageVersion);
                if (listPackages != null && listPackages.size() > 1) {
                    p = listPackages.get(0);
                    mCoordinates = (MavenCoordinates)p.getCoordinates();
                    continue;
                }
                if (listPackages.size() != 1) continue;
                p = listPackages.get(0);
                mCoordinates = (MavenCoordinates)p.getCoordinates();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)("ERROR IN RETRIEVE RESOURCE PROFILE FROM IS " + e.getMessage()));
        }
        return mCoordinates;
    }

    protected MavenCoordinates querySAMavenCoordinates(String serviceName, String serviceClass, String serviceVersion, String packageName, String packageVersion) throws ISException {
        this.logger.trace((Object)("querySAMavenCoordinates method: sc: " + serviceClass + " sn " + serviceName + " sv: " + serviceVersion + " pn: " + packageName + " pv: " + packageVersion));
        MavenCoordinates mCoordinates = null;
        GCUBEServiceQuery serviceQuery = null;
        try {
            serviceQuery = (GCUBEServiceQuery)this.getIsClient().getQuery(GCUBEServiceQuery.class);
        }
        catch (Exception e) {
            throw new ISException();
        }
        serviceQuery = this.buildServiceQuery(serviceName, serviceClass, serviceVersion, serviceQuery);
        try {
            String gId = null;
            String aid = null;
            String v = null;
            this.logger.debug((Object)("execute query in scope: " + this.scope.getName()));
            block6: for (GCUBEService resource : this.isClient.execute((ISQuery)serviceQuery, this.scope)) {
                List listP = resource.getPackages();
                for (Package p : listP) {
                    this.logger.debug((Object)("founded package with pn: " + p.getName() + " pv " + p.getVersion()));
                    try {
                        if (packageName == null || packageName != null && packageName.equalsIgnoreCase(p.getName())) {
                            gId = p.getMavenCoordinate(Package.MavenCoordinate.groupId);
                            aid = p.getMavenCoordinate(Package.MavenCoordinate.artifactId);
                            v = p.getMavenCoordinate(Package.MavenCoordinate.version);
                            this.logger.info((Object)("Maven coordinates found for package: " + p.getName() + " v: " + p.getVersion() + " ==>  g " + gId + " a: " + aid + " v: " + v));
                            if (gId == null || aid == null || v == null) continue;
                            if (packageVersion != null && packageVersion.equalsIgnoreCase(v)) {
                                mCoordinates = new MavenCoordinates(gId, aid, v);
                                continue block6;
                            }
                            if (packageVersion != null) continue;
                            mCoordinates = new MavenCoordinates(gId, aid, v);
                            continue block6;
                        }
                        this.logger.debug((Object)" the package founded not correspond to the package searched ");
                        this.logger.debug((Object)("package founded: " + p.getName() + " pv " + p.getVersion()));
                        this.logger.debug((Object)("package searched: " + packageName + " pv " + packageVersion));
                    }
                    catch (Exception e) {
                        this.logger.warn((Object)("Bad coordinates founded in profile or bad profile. skyp next profile. resource id: " + resource.getID()));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)("ERROR IN RETRIEVE RESOURCE PROFILE FROM IS " + e.getMessage()));
        }
        return mCoordinates;
    }

    protected List<GCubePackage> queryPluginCoordinates(String serviceName, String serviceClass, String serviceVersion, String packageName, String packageVersion) throws ISException {
        this.logger.trace((Object)" queryPluginCoordinates method ");
        List<GCubePackage> listPackages = new ArrayList<GCubePackage>();
        GCUBEServiceQuery serviceQuery = null;
        try {
            serviceQuery = (GCUBEServiceQuery)this.getIsClient().getQuery(GCUBEServiceQuery.class);
        }
        catch (Exception e) {
            throw new ISException();
        }
        serviceQuery = this.buildPluginQuery(serviceName, serviceClass, serviceVersion, packageName, packageVersion, serviceQuery);
        try {
            for (GCUBEService resource : this.isClient.execute((ISQuery)serviceQuery, this.scope)) {
                this.logger.debug((Object)(" Processing resource: " + resource.getID() + " desc: " + resource.getDescription()));
                listPackages = this.buildGCubePackage(serviceName, serviceClass, serviceVersion, listPackages, resource);
            }
        }
        catch (Exception e) {
            throw new ISException();
        }
        return listPackages;
    }

    protected List<MavenPackage> queryMavenPackagesCoordinates(String serviceName, String serviceClass, String serviceVersion, String packageName, String packageVersion) throws ISException {
        this.logger.trace((Object)"queyMavenPackagesCoordinates method");
        GCUBEServiceQuery serviceQuery = null;
        List<MavenPackage> listPackages = new ArrayList<MavenPackage>();
        try {
            serviceQuery = (GCUBEServiceQuery)this.getIsClient().getQuery(GCUBEServiceQuery.class);
        }
        catch (Exception e) {
            throw new ISException();
        }
        serviceQuery = this.buildServiceQuery(serviceName, serviceClass, serviceVersion, serviceQuery);
        try {
            for (GCUBEService resource : this.isClient.execute((ISQuery)serviceQuery, this.scope)) {
                listPackages = this.buildMavenPackage(listPackages, resource);
            }
        }
        catch (Exception e) {
            throw new ISException();
        }
        finally {
            if (listPackages == null) {
                throw new ISException();
            }
        }
        return listPackages;
    }

    protected List<GCubePackage> queryGCubePackagesCoordinates(String serviceName, String serviceClass, String serviceVersion, String packageName, String packageVersion) throws ISException {
        this.logger.trace((Object)"queyGCubePackagesCoordinates method");
        GCUBEServiceQuery serviceQuery = null;
        List<GCubePackage> listPackages = new ArrayList<GCubePackage>();
        try {
            serviceQuery = (GCUBEServiceQuery)this.getIsClient().getQuery(GCUBEServiceQuery.class);
        }
        catch (Exception e) {
            throw new ISException();
        }
        serviceQuery = this.buildServiceQuery(serviceName, serviceClass, serviceVersion, serviceQuery);
        try {
            this.logger.debug((Object)("execute query on scope: " + this.scope.getName()));
            for (GCUBEService resource : this.isClient.execute((ISQuery)serviceQuery, this.scope)) {
                listPackages = this.buildGCubePackage(serviceName, serviceClass, serviceVersion, listPackages, resource);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ISException();
        }
        finally {
            if (listPackages == null) {
                this.logger.error((Object)"listPackage is null ");
                throw new ISException();
            }
        }
        return listPackages;
    }

    public List<Package> queryPackagesCoordinates(String serviceName, String serviceClass, String serviceVersion) throws ISException {
        this.logger.trace((Object)"queyGCubePackagesCoordinates method");
        GCUBEServiceQuery serviceQuery = null;
        ArrayList listPackages = new ArrayList();
        try {
            serviceQuery = (GCUBEServiceQuery)this.getIsClient().getQuery(GCUBEServiceQuery.class);
        }
        catch (Exception e) {
            throw new ISException();
        }
        serviceQuery = this.buildServiceQuery(serviceName, serviceClass, serviceVersion, serviceQuery);
        ArrayList list = null;
        try {
            this.logger.debug((Object)("execute query on scope: " + this.scope.getName()));
            String maxVersion = "0.0.0";
            for (GCUBEService resource : this.isClient.execute((ISQuery)serviceQuery, this.scope)) {
                this.logger.debug((Object)("resource founded: " + resource.getID() + " with pack: "));
                boolean founded = false;
                for (Package p : resource.getPackages()) {
                    this.logger.debug((Object)(" pn:  " + p.getName() + " pv: " + p.getVersion()));
                    boolean newVersion = this.checkVersion(p.getVersion(), maxVersion);
                    this.logger.debug((Object)("founded? " + newVersion));
                    if (!newVersion) continue;
                    this.logger.debug((Object)(" maxVersion updated with package " + p.getName() + " v " + p.getVersion() + " on resource: " + resource.getID()));
                    maxVersion = p.getVersion();
                    founded = true;
                }
                if (!founded) continue;
                list = new ArrayList();
                list.addAll(resource.getPackages());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"package cannot be extracted ");
            throw new ISException();
        }
        finally {
            if (listPackages == null) {
                throw new ISException();
            }
        }
        return list;
    }

    private List<MavenPackage> buildMavenPackage(List<MavenPackage> listPackages, GCUBEService resource) throws BadCoordinatesException {
        this.logger.trace((Object)"buildMavenPackage method");
        List list = resource.getPackages();
        if (list != null && list.size() > 0) {
            this.logger.debug((Object)("founded " + list.size() + " packages"));
            String gId = null;
            String aid = null;
            String v = null;
            for (int i = 0; i < list.size(); ++i) {
                Package p = (Package)list.get(i);
                this.logger.debug((Object)("processing package: " + p.getName() + " v: " + p.getVersion()));
                gId = p.getMavenCoordinate(Package.MavenCoordinate.groupId);
                aid = p.getMavenCoordinate(Package.MavenCoordinate.artifactId);
                v = p.getMavenCoordinate(Package.MavenCoordinate.version);
                this.logger.info((Object)("Maven coordinates found for package: " + p.getName() + " v: " + p.getVersion() + " ==>  g " + gId + " a: " + aid + " v: " + v));
                if (gId != null && aid != null) {
                    MavenCoordinates coordinates = new MavenCoordinates(gId, aid, v);
                    listPackages.add(new MavenPackage(coordinates));
                }
                gId = null;
                aid = null;
                v = null;
            }
        } else {
            this.logger.debug((Object)"No packages founded");
        }
        return listPackages;
    }

    private List<MavenPackage> buildMavenPackage(List<MavenPackage> listPackages, GCUBEService resource, String packageName, String packageVersion) throws BadCoordinatesException {
        this.logger.trace((Object)("buildMavenPackage method with pn: " + packageName + " pv " + packageVersion));
        List list = resource.getPackages();
        if (list != null && list.size() > 0) {
            this.logger.debug((Object)("founded " + list.size() + " packages"));
            String gId = null;
            String aid = null;
            String v = null;
            for (int i = 0; i < list.size(); ++i) {
                Package p = (Package)list.get(i);
                this.logger.debug((Object)("processing package: " + p.getName() + " v: " + p.getVersion()));
                try {
                    MavenCoordinates coordinates;
                    gId = p.getMavenCoordinate(Package.MavenCoordinate.groupId);
                    aid = p.getMavenCoordinate(Package.MavenCoordinate.artifactId);
                    v = p.getMavenCoordinate(Package.MavenCoordinate.version);
                    this.logger.info((Object)("Maven coordinates found for package: " + p.getName() + " v: " + p.getVersion() + " ==>  g " + gId + " a: " + aid + " v: " + v));
                    if (p.getName().equalsIgnoreCase(packageName) && p.getVersion().equalsIgnoreCase(packageVersion)) {
                        this.logger.info((Object)("Maven coordinates found for package: " + p.getName() + " v: " + p.getVersion() + " ==>  g " + gId + " a: " + aid + " v: " + v));
                        if (gId == null || aid == null) continue;
                        if (packageVersion != null && packageVersion.equalsIgnoreCase(v)) {
                            coordinates = new MavenCoordinates(gId, aid, v);
                            listPackages.add(new MavenPackage(coordinates));
                            this.logger.debug((Object)"package added ");
                        } else {
                            if (packageVersion != null) continue;
                            coordinates = new MavenCoordinates(gId, aid, v);
                            listPackages.add(new MavenPackage(coordinates));
                            this.logger.debug((Object)"package added ");
                        }
                        break;
                    }
                    if (packageName != null || packageVersion != null) continue;
                    this.logger.debug((Object)"packageName & package version are null ");
                    coordinates = new MavenCoordinates(gId, aid, v);
                    listPackages.add(new MavenPackage(coordinates));
                    this.logger.debug((Object)"package added");
                    continue;
                }
                catch (Exception e) {
                    this.logger.warn((Object)("BadCoordinate founded " + e.getMessage()));
                }
            }
        } else {
            this.logger.debug((Object)"No packages founded");
        }
        return listPackages;
    }

    private List<GCubePackage> buildGCubePackage(String serviceName, String serviceClass, String serviceVersion, List<GCubePackage> listPackages, GCUBEService resource) throws BadCoordinatesException {
        this.logger.trace((Object)"buildGCubePackage method");
        List list = resource.getPackages();
        if (list != null && list.size() > 0) {
            String pn = null;
            String pv = null;
            this.logger.debug((Object)("Founded " + list.size() + " package"));
            for (int i = 0; i < list.size(); ++i) {
                pn = ((Package)list.get(i)).getName();
                pv = ((Package)list.get(i)).getVersion();
                if (pn != null && pv != null) {
                    GCubeCoordinates coordinates = new GCubeCoordinates(serviceName, serviceClass, serviceVersion, pn, pv);
                    this.logger.debug((Object)("added Package: pn:" + pn + " pv: " + pv + " to the responselist"));
                    listPackages.add(new GCubePackage(coordinates));
                }
                pn = null;
                pv = null;
            }
        }
        return listPackages;
    }

    public List<GCubePackage> updatePackageResource(String serviceName, String serviceClass, String serviceVersion, String packageName, String packageVersion) throws ISException {
        this.logger.trace((Object)"updatePackageResource method");
        GCUBEServiceQuery serviceQuery = null;
        List<GCubePackage> listPackages = null;
        try {
            serviceQuery = (GCUBEServiceQuery)this.getIsClient().getQuery(GCUBEServiceQuery.class);
        }
        catch (Exception e) {
            throw new ISException();
        }
        serviceQuery = this.buildServiceQuery(serviceName, serviceClass, serviceVersion, serviceQuery);
        Object newResource = null;
        this.logger.debug((Object)(" myService: class: " + serviceClass + " name: " + serviceName + " version: " + serviceVersion));
        this.logger.debug((Object)(" myPackage: name: " + packageName + " version: " + packageVersion));
        try {
            for (GCUBEService resource : this.isClient.execute((ISQuery)serviceQuery, this.scope)) {
                List list = resource.getPackages();
                ArrayList<Package> packageToRemove = new ArrayList<Package>();
                if (list == null) continue;
                int i = -1;
                for (i = 0; i < list.size(); ++i) {
                    Package p = (Package)list.get(i);
                    this.logger.debug((Object)("Package found: n: " + p.getName() + " v: " + p.getVersion() + " in scopes: "));
                    if (!p.getName().equalsIgnoreCase(packageName) || !p.getVersion().equalsIgnoreCase(packageVersion)) continue;
                    this.logger.debug((Object)(" remove package: " + p.getName() + " " + p.getVersion() + " from sc " + serviceClass + " sn " + serviceName + " sv: " + serviceVersion));
                    packageToRemove.add(p);
                    break;
                }
                if (packageToRemove == null || packageToRemove.size() <= 0) continue;
                if (list.size() == 1) {
                    resource = this.setInstanceScopeOnResource(resource);
                }
                this.publicResourceIS(resource, packageToRemove);
            }
            this.logger.debug((Object)("new resource for public in IS: " + newResource));
            this.removeLocallyResource(serviceClass, serviceName, packageName, packageVersion);
        }
        catch (Exception e) {
            throw new ISException();
        }
        return listPackages;
    }

    private GCUBEService setInstanceScopeOnResource(GCUBEService resource) {
        this.logger.trace((Object)"setInstanceScopeOnResource method");
        Map origScopeMap = resource.getScopes();
        Set s = origScopeMap.keySet();
        HashMap allScope = new HashMap();
        for (String scopeName : s) {
            allScope.put(scopeName, origScopeMap.get(scopeName));
        }
        Set resourceScopeSet = allScope.keySet();
        for (String scope : resourceScopeSet) {
            resource.removeScope(new GCUBEScope[]{(GCUBEScope)allScope.get(scope)});
        }
        Map serviceScopeMap = ServiceContext.getContext().getInstance().getScopes();
        Set serviceScopeSet = serviceScopeMap.keySet();
        for (String scope : serviceScopeSet) {
            resource.addScope(new GCUBEScope[]{(GCUBEScope)serviceScopeMap.get(scope)});
        }
        return resource;
    }

    private void removeLocallyResource(String serviceClass, String serviceName, String packageName, String packageVersion) {
        this.logger.trace((Object)" removeLocallyResource(String, String, String, String) method");
        String dir = ServiceContext.getContext().getHttpServerBasePath().getAbsolutePath() + File.separator + ServiceContext.getContext().getMavenRelativeDir() + File.separator + serviceClass + File.separator + serviceName + File.separator + packageName + File.separator + packageVersion;
        File localResource = new File(dir);
        if (localResource.isDirectory()) {
            boolean deleted = FileUtilsExtended.recursiveDeleteDirectory(localResource);
            if (deleted) {
                this.logger.debug((Object)("directory: " + localResource.getAbsolutePath() + " deleted"));
            } else {
                this.logger.warn((Object)("directory: " + localResource.getAbsolutePath() + " not deleted"));
            }
        }
    }

    public void publicResourceIS(GCUBEService newResource, List<Package> packageToRemove) throws Exception, ISPublisherException {
        this.logger.trace((Object)"publicResourceIS method ");
        this.logger.debug((Object)("new resource " + newResource));
        this.isPublisher = this.getIsPublisher();
        Map resourceScope = newResource.getScopes();
        Set s = resourceScope.keySet();
        if (s.size() > 0) {
            for (String scopeName : s) {
                this.logger.debug((Object)("scope: " + scopeName));
            }
        } else {
            this.logger.debug((Object)"The set of scopes is empty! ");
        }
        if (newResource.getPackages().size() - packageToRemove.size() > 0) {
            this.logger.debug((Object)("packages founded in new resource: " + newResource.getPackages().size()));
            for (String scopeName : s) {
                GCUBEScope scopeResFound = (GCUBEScope)resourceScope.get(scopeName);
                List list = newResource.getPackages();
                block4: for (Package p : packageToRemove) {
                    this.logger.debug((Object)(" try to remove package " + p.getName() + " v " + p.getVersion()));
                    try {
                        for (int i = 0; i < list.size(); ++i) {
                            Package pRes = (Package)list.get(i);
                            if (!pRes.getName().equalsIgnoreCase(p.getName()) || !pRes.getVersion().equalsIgnoreCase(p.getVersion())) continue;
                            list.remove(i);
                            continue block4;
                        }
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("package not removed: " + e.getMessage()));
                        e.printStackTrace();
                    }
                }
                this.isPublisher.registerGCUBEResource((GCUBEResource)newResource, scopeResFound, (GCUBESecurityManager)ServiceContext.getContext());
                this.logger.debug((Object)("Package register in scope: " + scopeResFound.getName()));
            }
        } else {
            for (String scopeName : s) {
                GCUBEScope scope = (GCUBEScope)resourceScope.get(scopeName);
                this.logger.debug((Object)("... from scope: " + scopeName));
                this.isPublisher.removeGCUBEResource(newResource.getID(), newResource.getType(), scope, (GCUBESecurityManager)ServiceContext.getContext());
                this.logger.info((Object)"Resource Removed succesfully");
            }
        }
    }

    public String publicResourceIS(GCUBEService resource, GCUBEScope scope) throws Exception, ISPublisherException {
        this.logger.trace((Object)" publicResourceIS method");
        String idFound = null;
        String idNew = null;
        if (resource != null) {
            idFound = this.checkResourceOnIS(resource);
            if (idFound != null) {
                resource.setID(idFound);
            }
            this.isPublisher = this.getIsPublisher();
            idNew = this.isPublisher.registerGCUBEResource((GCUBEResource)resource, scope, (GCUBESecurityManager)ServiceContext.getContext());
            this.logger.info((Object)("Published resource: sc " + resource.getServiceClass() + " sn: " + resource.getServiceName() + " v " + resource.getVersion() + " in scope: " + scope.getName()));
        }
        if (idFound != null) {
            return null;
        }
        return idNew;
    }

    public String checkResourceOnIS(GCUBEService resource) throws ISException {
        GCUBEServiceQuery serviceQuery = null;
        this.logger.trace((Object)" checkResourceOnIS method");
        try {
            serviceQuery = (GCUBEServiceQuery)this.getIsClient().getQuery(GCUBEServiceQuery.class);
        }
        catch (Exception e) {
            this.logger.error((Object)"is Exception");
            throw new ISException();
        }
        serviceQuery = this.buildServiceQuery(resource.getServiceName(), resource.getServiceClass(), resource.getVersion(), serviceQuery);
        List list = null;
        try {
            this.logger.debug((Object)("execute query on scope: " + this.scope.getName() + " with coordinates: " + resource.getServiceClass() + " " + resource.getServiceName() + "  " + resource.getVersion()));
            list = this.isClient.execute((ISQuery)serviceQuery, this.scope);
        }
        catch (Exception e) {
            this.logger.error((Object)"is Exception");
            throw new ISException();
        }
        if (list == null || list.isEmpty()) {
            this.logger.info((Object)"resource not present in IS");
            return null;
        }
        String id = ((GCUBEService)list.get(0)).getID();
        this.logger.info((Object)("resource present in IS with id: " + id));
        return id;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GCubeCoordinates queryGCubeCoordinates(String groupId, String artifactId, String version) throws ISException, BadCoordinatesException {
        String pv;
        String pn;
        String sv;
        String sc;
        String sn;
        block9: {
            this.logger.trace((Object)("queryGCubeCoordinates method with m coordinates: " + groupId + " " + artifactId + " " + version));
            GCUBEServiceQuery serviceQuery = null;
            try {
                serviceQuery = (GCUBEServiceQuery)this.getIsClient().getQuery(GCUBEServiceQuery.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ISException();
            }
            serviceQuery = this.buildMavenQuery(groupId, artifactId, version, serviceQuery);
            sn = null;
            sc = null;
            sv = null;
            pn = null;
            pv = null;
            try {
                this.logger.debug((Object)"query to is");
                for (GCUBEService resource : this.isClient.execute((ISQuery)serviceQuery, this.scope)) {
                    this.logger.debug((Object)"query executed");
                    sn = resource.getServiceName();
                    sc = resource.getServiceClass();
                    sv = resource.getVersion();
                    this.logger.debug((Object)("processing: sn " + sn + " sc " + sc + " v " + sv));
                    pn = null;
                    pv = null;
                    List list = resource.getPackages();
                    for (Package p : list) {
                        if (!p.getMavenCoordinate(Package.MavenCoordinate.groupId).equalsIgnoreCase(groupId) || !p.getMavenCoordinate(Package.MavenCoordinate.artifactId).equalsIgnoreCase(artifactId) || !p.getMavenCoordinate(Package.MavenCoordinate.version).equalsIgnoreCase(version)) continue;
                        pn = p.getName();
                        pv = p.getVersion();
                        this.logger.info((Object)("founded package Coordinates: pn: " + pn + " pv " + pv));
                        break;
                    }
                    if (pn == null || pv == null) continue;
                }
                if (pn != null && pv != null && sn != null && sc != null) break block9;
            }
            catch (Exception e) {
                try {
                    this.logger.error((Object)("" + e.getMessage() + " " + sc + sn + sv + pn + pv));
                    e.printStackTrace();
                    throw new ISException();
                }
                catch (Throwable throwable) {
                    if (pn != null && pv != null && sn != null && sc != null) {
                        throw throwable;
                    }
                    this.logger.error((Object)("ISEXCEPTION generated impossible convert from maven to gcube sc: " + sc + " sn " + sn + " sv " + sv + " phn " + pn + " pv " + pv));
                    throw new ISException();
                }
            }
            this.logger.error((Object)("ISEXCEPTION generated impossible convert from maven to gcube sc: " + sc + " sn " + sn + " sv " + sv + " phn " + pn + " pv " + pv));
            throw new ISException();
        }
        this.logger.debug((Object)("queryGCubeCoordinates method end gcube coordinates founded: " + sc + " " + sn + " " + sv + " " + pn + " " + pv));
        return new GCubeCoordinates(sn, sc, sv, pn, pv);
    }

    private GCUBEServiceQuery buildMavenQuery(String groupId, String artifactId, String version, GCUBEServiceQuery serviceQuery) {
        this.logger.trace((Object)("buildMavenQuery method gId: " + groupId + " aid: " + artifactId + " v: " + version));
        serviceQuery.addGenericCondition("count($result//MavenCoordinates[./groupId/string()='" + groupId + "' and ./artifactId/string()='" + artifactId + "' and ./version/string()='" + version + "'])>0");
        return serviceQuery;
    }

    protected GCUBEServiceQuery buildServiceQuery(String serviceName, String serviceClass, String serviceVersion, GCUBEServiceQuery serviceQuery) {
        this.logger.trace((Object)("buildServiceQuery method with sc " + serviceClass + " sn " + serviceName + " sv " + serviceVersion));
        serviceQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Profile/Name", serviceName)});
        serviceQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Profile/Class", serviceClass)});
        serviceQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Profile/Version", serviceVersion)});
        return serviceQuery;
    }

    private GCUBEServiceQuery buildPluginQuery(String serviceName, String serviceClass, String serviceVersion, String packageName, String packageVersion, GCUBEServiceQuery serviceQuery) {
        this.logger.trace((Object)"buildPluginQuery method");
        serviceQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//TargetService/Service/Class", serviceClass)});
        serviceQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//TargetService/Service/Name", serviceName)});
        serviceQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//TargetService/Service/Version", serviceVersion)});
        serviceQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//TargetService/Package", packageName)});
        serviceQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//TargetService/Version", packageVersion)});
        return serviceQuery;
    }

    private boolean checkVersion(String v1, String v2) {
        boolean v1Win = false;
        this.logger.debug((Object)("v1 " + v1 + " v2 " + v2));
        if (v1.contains("-SNAPSHOT")) {
            v1 = v1.substring(0, v1.lastIndexOf("-SNAPSHOT"));
        }
        if (v2.contains("-SNAPSHOT")) {
            v2 = v2.substring(0, v2.lastIndexOf("-SNAPSHOT"));
        }
        this.logger.debug((Object)("v1: " + v1 + " v2: " + v2));
        String[] v1Array = v1.split("\\.");
        String[] v2Array = v2.split("\\.");
        int length = v1Array.length;
        this.logger.debug((Object)("length1: " + v1Array.length + " length2: " + v2Array.length));
        if (v1Array.length > v2Array.length) {
            length = v2Array.length;
        }
        this.logger.debug((Object)("length: " + length));
        for (int i = 0; i < length; ++i) {
            this.logger.debug((Object)("v1 " + v1Array[i] + "   v2 " + v2Array[i]));
            if (Integer.parseInt(v1Array[i]) > Integer.parseInt(v2Array[i])) {
                return true;
            }
            if (Integer.parseInt(v1Array[i]) >= Integer.parseInt(v2Array[i])) continue;
            return false;
        }
        return v1Win;
    }
}

