/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.impl.porttypes;

import java.util.List;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.GCubeCoordinates;
import org.gcube.vremanagement.softwaregateway.impl.exceptions.BadCoordinatesException;
import org.gcube.vremanagement.softwaregateway.impl.exceptions.ServiceNotAvaiableFault;
import org.gcube.vremanagement.softwaregateway.impl.packages.GCubePackage;
import org.gcube.vremanagement.softwaregateway.impl.porttypes.ServiceContext;
import org.gcube.vremanagement.softwaregateway.stubs.DependenciesCoordinates;
import org.gcube.vremanagement.softwaregateway.stubs.GetPackageResponse;
import org.gcube.vremanagement.softwaregateway.stubs.GetPluginResponse;
import org.gcube.vremanagement.softwaregateway.stubs.LocationItem;
import org.gcube.vremanagement.softwaregateway.stubs.PackageCoordinates;
import org.gcube.vremanagement.softwaregateway.stubs.PluginCoordinates;
import org.gcube.vremanagement.softwaregateway.stubs.SACoordinates;
import org.gcube.vremanagement.softwaregateway.stubs.ServiceCoordinates;

public class Access
extends GCUBEPortType {
    protected final GCUBELog logger = new GCUBELog(Access.class);

    public String getLocation(PackageCoordinates pack) throws ServiceNotAvaiableFault {
        this.logger.debug((Object)"getLocation() invoked method");
        String url = null;
        GCubeCoordinates gcubeC = null;
        try {
            try {
                gcubeC = new GCubeCoordinates(pack.getServiceName(), pack.getServiceClass(), pack.getServiceVersion(), pack.getPackageName(), pack.getPackageVersion());
            }
            catch (BadCoordinatesException e) {
                throw new BadCoordinatesException("gcube coordinates");
            }
        }
        catch (Throwable throwable) {
            this.checkPackageCoordinates(gcubeC);
            throw throwable;
        }
        this.checkPackageCoordinates(gcubeC);
        GCubePackage gCubeP = new GCubePackage(gcubeC);
        url = gCubeP.getLocation();
        return url;
    }

    private void checkPackageCoordinates(GCubeCoordinates gcubeC) throws ServiceNotAvaiableFault {
        if (gcubeC.getPackageName() == null || gcubeC.getPackageVersion().isEmpty() || gcubeC.getPackageVersion() == null || gcubeC.getPackageVersion().isEmpty()) {
            throw new ServiceNotAvaiableFault("incorrect packageName or packageVersion for method getLocation ");
        }
    }

    public String getSALocation(SACoordinates pack) throws ServiceNotAvaiableFault {
        this.logger.debug((Object)"getSALocation() invoked");
        GCubeCoordinates gcubeC = null;
        try {
            try {
                gcubeC = new GCubeCoordinates(pack.getServiceName(), pack.getServiceClass(), pack.getServiceVersion(), pack.getPackageName(), pack.getPackageVersion());
            }
            catch (BadCoordinatesException e) {
                throw new BadCoordinatesException("gcube coordinates");
            }
        }
        catch (Throwable throwable) {
            this.checkPackageCoordinates(gcubeC);
            throw throwable;
        }
        this.checkPackageCoordinates(gcubeC);
        GCubePackage gCubeP = new GCubePackage(gcubeC);
        return gCubeP.getSALocation();
    }

    public String getDependencies(DependenciesCoordinates pack) throws ServiceNotAvaiableFault {
        this.logger.debug((Object)"getDependencies() invoked");
        String result = null;
        try {
            GCubeCoordinates coordinates = new GCubeCoordinates(pack.getServiceName(), pack.getServiceClass(), pack.getServiceVersion(), pack.getPackageName(), pack.getPackageVersion());
            GCubePackage gCubeP = new GCubePackage(coordinates);
            result = gCubeP.getDependencies();
        }
        catch (Exception e) {
            this.logger.error((Object)("Failed to retrive software deps for " + pack.getServiceName()), (Throwable)e);
            throw new ServiceNotAvaiableFault(e.getMessage());
        }
        return result;
    }

    public GetPackageResponse getPackages(ServiceCoordinates service) throws ServiceNotAvaiableFault {
        this.logger.debug((Object)"getpackages() invoked");
        GCubeCoordinates coordinates = new GCubeCoordinates(service.getServiceName(), service.getServiceClass(), service.getServiceVersion(), null, null);
        GCubePackage gCubeP = new GCubePackage(coordinates);
        List<GCubePackage> list = gCubeP.getPackages();
        if (list != null) {
            GetPackageResponse result = new GetPackageResponse();
            result = this.fillResult(list, result);
            return result;
        }
        return null;
    }

    public GetPluginResponse getPlugins(PluginCoordinates pack) throws ServiceNotAvaiableFault {
        this.logger.debug((Object)"getPlugins() invoked");
        GCubeCoordinates coordinates = new GCubeCoordinates(pack.getServiceName(), pack.getServiceClass(), pack.getServiceVersion(), pack.getPackageName(), pack.getPackageVersion());
        GCubePackage gCubeP = new GCubePackage(coordinates);
        List<GCubePackage> list = gCubeP.getPlugins();
        GetPluginResponse result = new GetPluginResponse();
        if (list != null) {
            result = this.fillResult(list, result);
        }
        return result;
    }

    protected GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    private GetPackageResponse fillResult(List<GCubePackage> list, GetPackageResponse result) {
        if (result == null) {
            result = new GetPackageResponse();
        }
        if (list != null && list.size() > 0) {
            LocationItem[] items = new LocationItem[list.size()];
            int i = 0;
            while (i < list.size()) {
                LocationItem item;
                this.logger.debug((Object)("add package: pn: " + list.get(i).getCoordinates().getPackageName() + " pv: " + list.get(i).getCoordinates().getPackageVersion() + " to service : " + list.get(i).getCoordinates().getServiceClass() + " " + list.get(i).getCoordinates().getServiceName() + " " + list.get(i).getCoordinates().getServiceVersion()));
                items[i] = item = new LocationItem(list.get(i).getCoordinates().getPackageName(), list.get(i).getCoordinates().getPackageVersion(), list.get(i).getCoordinates().getServiceClass(), list.get(i).getCoordinates().getServiceName(), list.get(i).getCoordinates().getServiceVersion());
                ++i;
            }
            result.setItems(items);
        }
        return result;
    }

    private GetPluginResponse fillResult(List<GCubePackage> list, GetPluginResponse result) {
        if (result == null) {
            result = new GetPluginResponse();
        }
        if (list != null && list.size() > 0) {
            LocationItem[] items = new LocationItem[list.size()];
            int i = 0;
            while (i < list.size()) {
                LocationItem item;
                this.logger.debug((Object)("add package: pn: " + list.get(i).getCoordinates().getPackageName() + " pv: " + list.get(i).getCoordinates().getPackageVersion() + " to service : " + list.get(i).getCoordinates().getServiceClass() + " " + list.get(i).getCoordinates().getServiceName() + " " + list.get(i).getCoordinates().getServiceVersion()));
                items[i] = item = new LocationItem(list.get(i).getCoordinates().getPackageName(), list.get(i).getCoordinates().getPackageVersion(), list.get(i).getCoordinates().getServiceClass(), list.get(i).getCoordinates().getServiceName(), list.get(i).getCoordinates().getServiceVersion());
                ++i;
            }
            result.setItems(items);
        }
        return result;
    }
}

