/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.impl.repositorymanager.maven;

import java.io.File;
import java.util.Arrays;
import java.util.Properties;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;

class MavenRequestBuilder {
    private String goal;
    private Properties properties;
    private File folder;
    private File pom;
    private String localRepositoryPath;

    MavenRequestBuilder() {
    }

    MavenRequestBuilder setUserProperties(String[][] props) {
        this.properties = new Properties();
        for (int i = 0; i < props.length; ++i) {
            this.properties.setProperty(props[i][0], props[i][1]);
        }
        return this;
    }

    MavenRequestBuilder execThisGoal(String goal) {
        this.goal = goal;
        return this;
    }

    MavenRequestBuilder setProjectFolder(File folder) {
        this.folder = folder;
        return this;
    }

    MavenRequestBuilder setPom(File pom) {
        this.pom = pom;
        return this;
    }

    MavenRequestBuilder useThisRepository(String path) {
        this.localRepositoryPath = path;
        return this;
    }

    MavenExecutionRequest build() {
        DefaultMavenExecutionRequest request = new DefaultMavenExecutionRequest();
        request.setGoals(Arrays.asList(this.goal));
        request.setUserProperties(this.properties);
        request.setLocalRepositoryPath(this.localRepositoryPath);
        request.setBaseDirectory(this.folder);
        request.setPom(this.pom);
        request.setRecursive(true);
        request.setOffline(false);
        request.setShowErrors(true);
        request.setLoggingLevel(0);
        return request;
    }
}

