/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.answer.xml;

import java.util.List;
import org.gcube.vremanagement.softwaregateway.answer.ReportObject;
import org.gcube.vremanagement.softwaregateway.answer.xml.XMLModel;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.GCubeCoordinates;

public class XMLBuilder
extends XMLModel {
    @Override
    public void addHeader() {
        this.xml.append("<Packages>\n");
    }

    @Override
    public void addFooter() {
        this.xml.append("</Packages>\n");
    }

    @Override
    public void addDependencies(List<GCubeCoordinates> resolved, List<GCubeCoordinates> missing) {
        this.xml.append("<DependencyResolutionReport>\n");
        this.xml.append("\t<ResolvedDependencies>\n");
        if (resolved != null && resolved.size() > 0) {
            for (GCubeCoordinates gCubeCoordinates : resolved) {
                this.xml.append("\t\t\t<Dependency>\n");
                this.xml.append("\t\t\t\t<Service>\n");
                this.xml.append("\t\t\t\t\t<Class>").append(gCubeCoordinates.getServiceClass().trim()).append("</Class>\n");
                this.xml.append("\t\t\t\t\t<Name>").append(gCubeCoordinates.getServiceName().trim()).append("</Name>\n");
                this.xml.append("\t\t\t\t\t<Version>").append(gCubeCoordinates.getServiceVersion().trim()).append("</Version>\n");
                this.xml.append("\t\t\t\t</Service>\n");
                this.xml.append("\t\t\t\t<Package>").append(gCubeCoordinates.getPackageName().trim()).append("</Package>\n");
                this.xml.append("\t\t\t\t<Version>").append(gCubeCoordinates.getPackageVersion()).append("</Version>\n");
                this.xml.append("\t\t\t</Dependency>\n");
            }
        }
        this.xml.append("\t</ResolvedDependencies>\n");
        this.xml.append("\t<MissingDependencies>\n");
        if (missing != null && missing.size() > 0) {
            for (GCubeCoordinates gCubeCoordinates : missing) {
                this.xml.append("\t\t\t<MissingDependency>\n");
                this.xml.append("\t\t\t\t<Service>\n");
                this.xml.append("\t\t\t\t\t<Class>").append(gCubeCoordinates.getServiceClass().trim()).append("</Class>\n");
                this.xml.append("\t\t\t\t\t<Name>").append(gCubeCoordinates.getServiceName().trim()).append("</Name>\n");
                this.xml.append("\t\t\t\t\t<Version>").append(gCubeCoordinates.getServiceVersion().trim()).append("</Version>\n");
                this.xml.append("\t\t\t\t</Service>\n");
                this.xml.append("\t\t\t\t<Package>").append(gCubeCoordinates.getPackageName().trim()).append("</Package>\n");
                this.xml.append("\t\t\t\t<Version>").append(gCubeCoordinates.getPackageVersion()).append("</Version>\n");
                this.xml.append("\t\t\t</MissingDependency>\n");
            }
        }
        this.xml.append("\t</MissingDependencies>\n");
        this.xml.append("</DependencyResolutionReport>\n");
    }

    @Override
    public void addPlugin(List<GCubeCoordinates> plugin) {
        this.xml.append("<ServicePlugins>\n");
        for (GCubeCoordinates gCubeCoordinates : plugin) {
            this.xml.append("\t<Plugin>\n");
            this.xml.append("\t\t<Service>\n");
            this.xml.append("\t\t\t<Class>").append(gCubeCoordinates.getServiceClass()).append("</Class>\n");
            this.xml.append("\t\t\t<Name>").append(gCubeCoordinates.getServiceName()).append("</Name>\n");
            this.xml.append("\t\t\t<Version>").append(gCubeCoordinates.getServiceVersion()).append("</Version>\n");
            this.xml.append("\t\t</Service>\n");
            this.xml.append("\t</Plugin>\n");
        }
        this.xml.append("</ServicePlugins>");
    }

    @Override
    public void addPackages(List<GCubeCoordinates> plugin) {
        this.xml.append("<Package>\n");
        for (GCubeCoordinates gCubeCoordinates : plugin) {
            this.xml.append("\t\t\t<ServiceClass>").append(gCubeCoordinates.getServiceClass()).append("</ServiceClass>\n");
            this.xml.append("\t\t\t<ServiceName>").append(gCubeCoordinates.getServiceName()).append("</ServiceName>\n");
            this.xml.append("\t\t\t<ServiceVersion>").append(gCubeCoordinates.getServiceVersion()).append("</ServiceVersion>\n");
            this.xml.append("\t\t\t<PackageName>").append(gCubeCoordinates.getServiceName()).append("</PackageName>\n");
            this.xml.append("\t\t\t<PackageVersion>").append(gCubeCoordinates.getServiceVersion()).append("</PackageVersion>\n");
        }
        this.xml.append("</Package>");
    }

    @Override
    public void addReportPackage(ReportObject obj) {
        this.xml.append("\t<Package>\n");
        this.xml.append("\t\t<groupID>").append(obj.getGroupId()).append("</groupID>\n");
        this.xml.append("\t\t<artifactID>").append(obj.getArtifactId()).append("</artifactID>\n");
        this.xml.append("\t\t<version>").append(obj.getVersion()).append("</version>\n");
        this.xml.append("\t\t<ID>").append(obj.getID()).append("</ID>\n");
        this.xml.append("\t\t<URL>").append(obj.getUrl()).append("</URL>\n");
        this.xml.append("\t\t<javadoc>").append(obj.getJavadocUrl()).append("</javadoc>\n");
        this.xml.append("\t\t<Status>").append(obj.getStatus()).append("</Status>\n");
        this.xml.append("\t\t<Operation>").append(obj.getOperation()).append("</Operation>\n");
        this.xml.append("\t\t<Timestamp>").append(obj.getTimestamp()).append("</Timestamp>\n");
        this.xml.append("\t</Package>\n");
    }
}

