/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.vremanagement.softwaregateway.client.SGAccessLibrary;
import org.gcube.vremanagement.softwaregateway.client.fws.Types;
import org.gcube.vremanagement.softwaregateway.client.proxies.Proxies;

public class GetPackagesClient {
    public static void main(String[] args) {
        List items;
        SGAccessLibrary library;
        for (int i = 0; i < args.length; ++i) {
            System.out.println("param N." + i + ": " + args[i]);
        }
        if (args.length != 5) {
            System.out.println("Usage:");
            System.out.println("\tjava  GetPackagesClient   SoftwareGatewayEPR  scope  ServiceName   ServiceClass   ServiceVersion \n\n");
            System.out.println("Example:");
            System.out.println("\tjava  GetPackagesClient  http://node2.d.d4science.research-infrastructures.eu:9001/wsrf/services/gcube/vremanagement/softwaregateway/Registration /gcube/devsec Test3 TestProfile3 1.00.00 \n\n");
            return;
        }
        ScopeProvider.instance.set(args[1]);
        try {
            library = (SGAccessLibrary)Proxies.accessService().at(new URI(args[0])).withTimeout(1, TimeUnit.MINUTES).build();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return;
        }
        String serviceClass = args[2];
        String serviceName = args[3];
        String serviceVersion = args[4];
        Types.ServiceCoordinates sc = new Types.ServiceCoordinates();
        sc.sc = serviceClass;
        sc.sn = serviceName;
        sc.sv = serviceVersion;
        Types.getPackagesResponse response = null;
        response = library.getPackages(sc);
        if (response != null && (items = response.items) != null) {
            System.out.println("Packages found: \n" + items.size());
            for (Types.LocationItem item : items) {
                System.out.println("  package name: " + item.pn + "  version: " + item.pv);
            }
        }
    }
}

