/**
 * 
 */
package org.gcube.vremanagement.softwaregateway.client.util;

import java.util.List;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;

/**
 * @author "Federico De Faveri defaveri@isti.cnr.it"
 *
 */
public class ISUtil {
	
	public static EndpointReferenceType getSoftwareGatewayEndpoint(GCUBEScope scope) throws Exception {
		return getServicePortTypeEndpoint(scope, "VREManagement", "SoftwareGateway", "gcube/vremanagement/softwaregateway/Registration", false);
	}
	
	public static EndpointReferenceType getServicePortTypeEndpoint(GCUBEScope scope, String serviceClass, String serviceName, String portTypeFullName, boolean scopeSpecific) throws Exception{

		ISClient client = GHNContext.getImplementation(ISClient.class);
		GCUBERIQuery query = client.getQuery(GCUBERIQuery.class);
		query.addAtomicConditions(
				new AtomicCondition("//ServiceClass", serviceClass), 
				new AtomicCondition("//ServiceName", serviceName)
		);
		List<GCUBERunningInstance> RIs = client.execute(query, scope);

		if(RIs.size()==0) throw new RuntimeException("No services found");

		GCUBERunningInstance serviceRI = null;

		if(RIs.size()>1) {
			if  (!scopeSpecific) throw new RuntimeException("More than one service found");

			for (GCUBERunningInstance ri:RIs){
				if (ri.getScopes().size() == 1 && ri.getScopes().containsKey(scope.toString())) {
					serviceRI = ri;
					break;
				}
			}
			if (serviceRI==null) throw new RuntimeException("No specific RI instaces found for scope "+scope);
			
		} else serviceRI = RIs.get(0);


		EndpointReferenceType epr = serviceRI.getAccessPoint().getEndpoint(portTypeFullName);
		return epr;
	}

}
