<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes"/>
	<xsl:template match="/"><html>
		<head>
			<meta http-equiv="Cache-Control" content="No-cache"/>
			<meta http-equiv="Expires" content="0"/>
			<meta http-equiv="Pragma" content="No-cache"/>
			<meta http-equiv="Cache-Control" content="no-store"/>
			<meta http-equiv="Cache-Control" content="max-age=0"/>
			<link href="../styles.css" rel="stylesheet" type="text/css" />
			
		</head>
		<body>
		<table border="0">
			<tbody>
				<tr>
					<th  class="header">URL</th>
					<th  class="header">ID</th>
					<th  class="header">Service Class</th>
					<th  class="header">Service Name</th>
					<th   class="header">Service Version</th>
					<th  class="header">Status</th>
					<th class="header">Operation</th>
					<th class="header">Timestamp</th>
					<th  class="header">Report URL</th> 
				</tr>
				<xsl:apply-templates select="//Service"></xsl:apply-templates>
			</tbody>
		</table>
		</body>
	</html>
	</xsl:template>
	
	<xsl:template match="//Service">
		<xsl:variable name="color">
			<xsl:choose>
				<xsl:when test="Status">
					<xsl:variable name="status"><xsl:value-of select="Status"></xsl:value-of></xsl:variable>
					<xsl:if test="$status='ERROR'">#FFC7CA</xsl:if>
					<xsl:if test="$status='SUCCESS'">#D8F3D7</xsl:if>
					<xsl:if test="$status='WARNING'">#FFFF00</xsl:if>
				</xsl:when>
			</xsl:choose>
		</xsl:variable>
		
		<tr bgcolor="{$color}">
			<xsl:for-each select="child::*">
				<xsl:choose>
					<xsl:when test="name()='URL'">  <!--  matches the first column                      -->
						<xsl:variable name="url"><xsl:value-of select="."></xsl:value-of></xsl:variable>
						<th><a href="{$url}"> download </a></th>
					</xsl:when>
					<xsl:when test="name()='ReportURL'">   <!--  matches the last column                      -->
						<xsl:variable name="url"><xsl:value-of select="."></xsl:value-of></xsl:variable>
						<th><a href="{$url}" target="_blank"> open </a></th>
					</xsl:when>
					<xsl:otherwise>
						<th><xsl:value-of select="."></xsl:value-of></th>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
		</tr>
	</xsl:template>
</xsl:stylesheet>
