/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.virtualplatform.tomcat;

import java.io.File;
import java.io.FileFilter;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.catalina.ant.DeployTask;
import org.apache.catalina.ant.StartTask;
import org.apache.catalina.ant.StopTask;
import org.apache.catalina.ant.UndeployTask;
import org.apache.tools.ant.BuildException;
import org.gcube.vremanagement.virtualplatform.model.DeployedPackage;
import org.gcube.vremanagement.virtualplatform.model.PackageSet;
import org.gcube.vremanagement.virtualplatform.model.TargetPlatform;
import org.gcube.vremanagement.virtualplatform.model.UndeployedPackage;
import org.gcube.vremanagement.virtualplatform.tomcat.DeployedWebapp;
import org.gcube.vremanagement.virtualplatform.tomcat.UndeployedWebapp;
import org.gcube.vremanagement.virtualplatform.tomcat.Webapp;

public class Container
extends TargetPlatform<Webapp> {
    String user;
    String password;
    String manager;
    URL baseURL;
    static final String platform = "TOMCAT";
    static final int platformVersion = 6;
    static final int platformMinorVersion = 0;

    public DeployedPackage deploy(Webapp webapp) throws Exception {
        Object object;
        DeployedWebapp deployedWebapp = new DeployedWebapp(webapp);
        try {
            object = new DeployTask();
            object.setUsername(this.user);
            object.setPassword(this.password);
            object.setWar(webapp.getFile().getAbsolutePath());
            object.setPath(webapp.getTargetPath());
            object.setUrl(this.manager);
            object.setDescription(webapp.getDescription());
            object.execute();
        }
        catch (Exception exception) {
            for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                System.err.println("Container says: " + stackTraceElement);
            }
            throw new Exception(exception);
        }
        object = webapp.getEntrypoints();
        String[] stringArray = new String[object.size() + 1];
        stringArray[0] = this.baseURL.toString() + (webapp.getTargetPath().startsWith("/") ? webapp.getTargetPath() : "/" + webapp.getTargetPath());
        for (int i = 0; i < object.size(); ++i) {
            stringArray[i + 1] = stringArray[0] + (((String)object.get(i)).startsWith("/") ? (String)object.get(i) : "/" + (String)object.get(i));
        }
        deployedWebapp.setEndpoints(stringArray);
        deployedWebapp.setSuccess(true);
        return deployedWebapp;
    }

    public UndeployedPackage undeploy(Webapp webapp) throws Exception {
        UndeployedWebapp undeployedWebapp = new UndeployedWebapp(webapp);
        try {
            UndeployTask undeployTask = new UndeployTask();
            undeployTask.setUrl(this.manager);
            undeployTask.setUsername(this.user);
            undeployTask.setPassword(this.password);
            undeployTask.setPath(webapp.getTargetPath());
            undeployTask.execute();
        }
        catch (BuildException buildException) {
            throw new Exception(buildException);
        }
        undeployedWebapp.setSuccess(true);
        return undeployedWebapp;
    }

    public String getPlatform() {
        return platform;
    }

    public int getPlatformVersion() {
        return 6;
    }

    public int getPlatformMinorVersion() {
        return 0;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setBaseURL(URL uRL) {
        this.baseURL = uRL;
        this.manager = uRL.toString() + "/manager";
    }

    public Class<Webapp> getResourceClass() {
        return Webapp.class;
    }

    public boolean activate(Webapp webapp) throws Exception {
        StartTask startTask = new StartTask();
        startTask.setPath(webapp.getTargetPath());
        startTask.setUsername(this.user);
        startTask.setPassword(this.password);
        startTask.setUrl(this.manager);
        try {
            startTask.execute();
        }
        catch (BuildException buildException) {
            throw new Exception(buildException);
        }
        return true;
    }

    public boolean deactivate(Webapp webapp) throws Exception {
        StopTask stopTask = new StopTask();
        stopTask.setPath(webapp.getTargetPath());
        stopTask.setUsername(this.user);
        stopTask.setPassword(this.password);
        stopTask.setUrl(this.manager);
        try {
            stopTask.execute();
        }
        catch (BuildException buildException) {
            throw new Exception(buildException);
        }
        return true;
    }

    public PackageSet<Webapp> list() throws Exception {
        return null;
    }

    public void initialize() throws Exception {
    }

    public FileFilter getAcceptedFilesFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getAbsolutePath().endsWith(".war") && file.exists();
            }
        };
    }

    public void shutdown() throws Exception {
    }

    public boolean supportHotDeployment() {
        return true;
    }

    public boolean isAvailable() {
        try {
            HttpURLConnection.setFollowRedirects(false);
            HttpURLConnection httpURLConnection = (HttpURLConnection)this.baseURL.openConnection();
            httpURLConnection.setRequestMethod("HEAD");
            return httpURLConnection.getResponseCode() == 200;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("failed to check if tomcat is available");
            return false;
        }
    }
}

