/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.virtualplatform.image;

import java.io.FileFilter;
import java.lang.reflect.Method;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.virtualplatform.image.PlatformConfiguration;
import org.gcube.vremanagement.virtualplatform.image.PlatformLoader;
import org.gcube.vremanagement.virtualplatform.model.DeployedPackage;
import org.gcube.vremanagement.virtualplatform.model.Package;
import org.gcube.vremanagement.virtualplatform.model.PackageSet;
import org.gcube.vremanagement.virtualplatform.model.TargetPlatform;
import org.gcube.vremanagement.virtualplatform.model.UndeployedPackage;

public class VirtualPlatform {
    GCUBELog logger = new GCUBELog(VirtualPlatform.class);
    TargetPlatform<?> container;
    PlatformLoader cl;
    PlatformConfiguration configuration;

    public VirtualPlatform(PlatformConfiguration platformConfiguration) throws Exception {
        this.configuration = platformConfiguration;
        try {
            this.cl = new PlatformLoader(platformConfiguration.getResources());
            Class<?> clazz = this.getClass().getClassLoader().loadClass("org.gcube.vremanagement.virtualplatform.model.TargetPlatform");
            if (clazz == null) {
                System.out.println("target platform is null");
            } else {
                System.out.println("TargetPlatform was loaded using this classloader: " + clazz.getClassLoader().toString());
            }
            Object object = this.cl.getInstanceOf(platformConfiguration.getPlatformClass(), new Object[0]);
            if (object != null) {
                System.out.println("Container was loaded using this classloader: " + object.getClass().getClassLoader().toString());
            }
            this.logger.trace((Object)("I'm using this classloader: " + object.getClass().getClassLoader().toString()));
            if (!(object instanceof TargetPlatform)) {
                this.logger.error((Object)("The loaded platform is an instance of " + object.getClass().getName()));
                throw new Exception("The loaded platform does not implements the Target Platform interface");
            }
            this.container = (TargetPlatform)object;
            this.container.setBaseURL(platformConfiguration.getBaseURL());
            this.container.setUser(platformConfiguration.getUser());
            this.container.setPassword(platformConfiguration.getPassword());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logger.fatal((Object)("Unable to initialize the virtual platform " + platformConfiguration.getName()), (Throwable)exception);
            throw exception;
        }
    }

    public Package getNewAppInstance() throws Exception {
        Package package_ = null;
        try {
            package_ = (Package)this.cl.getInstanceOf(this.container.getResourceClass().getName(), new Object[0]);
        }
        catch (Exception exception) {
            this.logger.error((Object)"Failed to get a new application instance from the platform", (Throwable)exception);
            throw exception;
        }
        return package_;
    }

    public PackageSet<DeployedPackage> deploy(PackageSet<Package> packageSet) throws Exception {
        PackageSet<DeployedPackage> packageSet2 = new PackageSet<DeployedPackage>();
        try {
            Method method = this.container.getClass().getMethod("deploy", this.container.getResourceClass());
            for (Package package_ : packageSet) {
                try {
                    this.logger.info((Object)("Deploying package on platform " + this.configuration.getName()));
                    packageSet2.add((DeployedPackage)method.invoke(this.container, package_));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.logger.error((Object)"Failed to deploy ", (Throwable)exception);
                    break;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Exception("Invalid platform", exception);
        }
        return packageSet2;
    }

    public FileFilter getAcceptedFilesFilter() throws Exception {
        try {
            Method method = this.container.getClass().getMethod("getAcceptedFilesFilter", this.container.getResourceClass());
            return (FileFilter)method.invoke(this.container, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public PackageSet<UndeployedPackage> undeploy(PackageSet<?> packageSet) throws Exception {
        PackageSet<UndeployedPackage> packageSet2 = new PackageSet<UndeployedPackage>();
        try {
            Method method = this.container.getClass().getMethod("undeploy", this.container.getResourceClass());
            for (Object e : packageSet) {
                try {
                    this.logger.info((Object)("Undeploying package from platform " + this.configuration.getName()));
                    packageSet2.add((UndeployedPackage)method.invoke(this.container, e));
                }
                catch (Exception exception) {
                    this.logger.error((Object)"Failed to undeploy ", (Throwable)exception);
                    break;
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("Invalid platform", exception);
        }
        return packageSet2;
    }

    public boolean activate(PackageSet<?> packageSet) throws Exception {
        try {
            Method method = this.container.getClass().getMethod("activate", this.container.getResourceClass());
            for (Object e : packageSet) {
                try {
                    this.logger.info((Object)("Activating resource in platform " + this.configuration.getName()));
                    Boolean bl = (Boolean)method.invoke(this.container, e);
                    if (bl.booleanValue()) continue;
                    this.logger.info((Object)("Failed to activate the resource in platform " + this.configuration.getName()));
                }
                catch (Exception exception) {
                    this.logger.error((Object)"Failed to activate ", (Throwable)exception);
                    break;
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("Invalid platform", exception);
        }
        return true;
    }

    public boolean deactivate(PackageSet<?> packageSet) throws Exception {
        try {
            Method method = this.container.getClass().getMethod("deactivate", this.container.getResourceClass());
            for (Object e : packageSet) {
                try {
                    this.logger.info((Object)("Deactivating resource in platform " + this.configuration.getName()));
                    Boolean bl = (Boolean)method.invoke(this.container, e);
                    if (bl.booleanValue()) continue;
                    this.logger.info((Object)("Failed to deactivate the resource in platform " + this.configuration.getName()));
                }
                catch (Exception exception) {
                    this.logger.error((Object)"Failed to deactivate ", (Throwable)exception);
                    break;
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("Invalid platform", exception);
        }
        return true;
    }

    public void initialize() throws Exception {
        Method method = this.container.getClass().getMethod("initialize", new Class[0]);
        method.invoke(this.container, new Object[0]);
    }

    public void shutdown() throws Exception {
        Method method = this.container.getClass().getMethod("shutdown", new Class[0]);
        method.invoke(this.container, new Object[0]);
    }

    public boolean isAvailable() {
        try {
            Method method = this.container.getClass().getMethod("isAvailable", new Class[0]);
            return (Boolean)method.invoke(this.container, new Object[0]);
        }
        catch (Exception exception) {
            this.logger.warn((Object)"Failed to check if the platform is available or not", (Throwable)exception);
            return false;
        }
    }

    public String getName() {
        return this.configuration.getName();
    }

    public short getVersion() {
        return this.configuration.getVersion();
    }

    public short getMinorVersion() {
        return this.configuration.getMinorVersion();
    }
}

