/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.vremodeler.resources.handlers;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.support.ConnectionSource;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEServiceQuery;
import org.gcube.common.core.resources.GCUBEService;
import org.gcube.common.core.resources.service.MainPackage;
import org.gcube.common.core.resources.service.Package;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.vremodeler.db.DBInterface;
import org.gcube.vremanagement.vremodeler.impl.ServiceContext;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.Service;
import org.gcube.vremanagement.vremodeler.resources.handlers.ResourceHandler;

public class ServiceHandler
implements ResourceHandler<Service> {
    private static GCUBELog logger = new GCUBELog(ServiceHandler.class);

    @Override
    public List<Service> initialize() throws Exception {
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBEServiceQuery query = (GCUBEServiceQuery)client.getQuery(GCUBEServiceQuery.class);
        List gcubeServiceList = client.execute((ISQuery)query, ServiceContext.getContext().getScope());
        ArrayList<Service> services = new ArrayList<Service>();
        for (GCUBEService gcubeService : gcubeServiceList) {
            try {
                String packageName = null;
                String packageVersion = null;
                for (Package packageSW : gcubeService.getPackages()) {
                    if (packageSW instanceof MainPackage) {
                        packageName = packageSW.getName();
                        packageVersion = packageSW.getVersion();
                        break;
                    }
                    if (packageName != null && packageVersion != null) continue;
                    packageName = packageSW.getName();
                    packageVersion = packageSW.getVersion();
                }
                Service service = new Service(gcubeService.getID(), gcubeService.getServiceClass(), gcubeService.getServiceName(), gcubeService.getVersion(), packageName, packageVersion);
                this.insert(service);
                services.add(service);
                logger.trace((Object)("added service " + service.getServiceClass() + " " + service.getServiceName() + " " + packageName + " " + packageVersion));
            }
            catch (Exception e) {
                logger.error((Object)"error inserting service", (Throwable)e);
            }
        }
        return services;
    }

    @Override
    public void add(Service resource) throws Exception {
        this.insert(resource);
    }

    @Override
    public void drop(String resourceId) throws Exception {
        Dao serviceDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), Service.class);
        serviceDao.deleteById((Object)resourceId);
    }

    private void insert(Service resource) throws Exception {
        Dao serviceDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), Service.class);
        serviceDao.createOrUpdate((Object)resource);
        logger.trace((Object)("inserting service with name " + resource.getServiceName() + " class " + resource.getServiceClass() + " version " + resource.getVersion()));
    }
}

