/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.vremodeler.impl.util;

import com.j256.ormlite.dao.Dao;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.FunctionalityPersisted;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.VreFunctionalityRelation;
import org.gcube.vremanagement.vremodeler.impl.util.ServicePair;
import org.gcube.vremanagement.vremodeler.impl.util.Util;
import org.gcube.vremanagement.vremodeler.utils.reports.DeployReport;
import org.gcube.vremanagement.vremodeler.utils.reports.FunctionalityDeployingReport;
import org.gcube.vremanagement.vremodeler.utils.reports.FunctionalityReport;
import org.gcube.vremanagement.vremodeler.utils.reports.Resource;
import org.gcube.vremanagement.vremodeler.utils.reports.ResourceDeployingReport;
import org.gcube.vremanagement.vremodeler.utils.reports.ServiceReport;
import org.gcube.vremanagement.vremodeler.utils.reports.Status;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class ReportFiller {
    public static GCUBELog logger = new GCUBELog(ReportFiller.class);

    public static void initializeFunctionalityForReport(FunctionalityDeployingReport report, String vreResourceId, Dao<VreFunctionalityRelation, String> vreFunctionalityDao, Dao<FunctionalityPersisted, Integer> functionalityDao) throws Exception {
        report.setStatus(Status.Running);
        List<FunctionalityPersisted> functs = Util.getSelectedFunctionality(vreFunctionalityDao, functionalityDao, vreResourceId);
        for (FunctionalityPersisted functionality : functs) {
            logger.trace((Object)("adding report for functionality " + functionality.getId()));
            FunctionalityReport funcReport = new FunctionalityReport();
            funcReport.setFunctionalityId(functionality.getId());
            funcReport.setFunctionalityName(functionality.getName());
            funcReport.setStatus(Status.Running);
            ArrayList<ServiceReport> listService = new ArrayList<ServiceReport>();
            for (ServicePair servicePair : functionality.getServices()) {
                ServiceReport servReport = new ServiceReport();
                servReport.setServiceName(servicePair.getServiceName());
                servReport.setServiceClass(servicePair.getServiceClass());
                servReport.setServiceVersion("1.0.0");
                servReport.setStatus(Status.Running);
                listService.add(servReport);
            }
            report.getFunctionalityTable().put(funcReport, listService);
        }
    }

    public static void initializeResourcesForReport(ResourceDeployingReport report) throws Exception {
        report.setStatus(Status.Running);
    }

    public static void addResourceToReport(String resourceId, String resourceType, ResourceDeployingReport report) {
        report.getResources().add(new Resource(resourceId, resourceType));
    }

    public static void reportElaboration(DeployReport report) {
        logger.trace((Object)"Elaborationg report");
        String rmReport = report.getFunctionalityDeployingReport().getResourceManagerReport();
        if (rmReport == null) {
            return;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(new ByteArrayInputStream(rmReport.getBytes()));
            XPath xpath = XPathFactory.newInstance().newXPath();
            for (Map.Entry entry : report.getFunctionalityDeployingReport().getFunctionalityTable().entrySet()) {
                Status generalFunctState = Status.Finished;
                for (ServiceReport serviceReport : (List)entry.getValue()) {
                    if (serviceReport.getStatus() == Status.Finished || serviceReport.getStatus() == Status.Failed) continue;
                    NodeList nResoulution = (NodeList)xpath.evaluate("/ResourceReport/Services/Service/DeploymentActivity/GHN/LastReportReceived/Packages/Package[/ServiceClass/text()='" + serviceReport.getServiceClass() + "' and /ServiceName/text()='" + serviceReport.getServiceName() + "' and /ServiceVersion/text()='" + serviceReport.getServiceVersion() + "']/Status", document, XPathConstants.NODESET);
                    boolean isServiceDeployed = true;
                    boolean isServiceFailed = false;
                    for (int i = 0; i < nResoulution.getLength(); ++i) {
                        logger.trace((Object)("retrieved package for service " + serviceReport.getServiceName()));
                        if (nResoulution.item(i).getFirstChild().getNodeValue().compareTo("FAILED") == 0) {
                            isServiceFailed = true;
                            break;
                        }
                        if (nResoulution.item(i).getFirstChild().getNodeValue().compareTo("RUNNING") == 0 || nResoulution.item(i).getFirstChild().getNodeValue().compareTo("ACTIVATED") == 0) continue;
                        isServiceDeployed = false;
                    }
                    if (isServiceFailed) {
                        serviceReport.setStatus(Status.Failed);
                        generalFunctState = Status.Failed;
                    }
                    if (isServiceDeployed) {
                        serviceReport.setStatus(Status.Finished);
                        continue;
                    }
                    generalFunctState = Status.Running;
                }
                ((FunctionalityReport)entry.getKey()).setStatus(generalFunctState);
            }
            logger.trace((Object)"second step : resources retrieving");
            for (Resource resource : report.getResourceDeployingReport().getResources()) {
                if (resource.getStatus() == Status.Finished || resource.getStatus() == Status.Failed) continue;
                logger.trace((Object)("checking resource with id " + resource.getResourceId()));
                NodeList nResoulution = (NodeList)xpath.evaluate("/ResourceReport/Resources//Resource[./ID/text()='" + resource.getResourceId() + "']/Status", document, XPathConstants.NODESET);
                logger.trace((Object)("found " + nResoulution.getLength()));
                if (nResoulution.getLength() <= 0) continue;
                logger.trace((Object)("found " + nResoulution.item(0).getFirstChild().getNodeValue()));
                if (nResoulution.item(0).getFirstChild().getNodeValue().compareTo("FAILED") == 0) {
                    resource.setStatus(Status.Failed);
                    continue;
                }
                resource.setStatus(Status.Finished);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"cannot fill report", (Throwable)e);
        }
    }
}

